set rcsId {$Id: scrolist.tcl,v 1.23 1997/09/07 20:07:30 jfontain Exp $}

class scrollList {}

proc scrollList::scrollList {this parentPath args} composite {
    [new frame $parentPath -highlightthickness $widget::(default,ButtonHighlightWidth)] $args
} {
    composite::manage $this [new listbox $widget::($this,path) -highlightthickness 0] listbox
    set listboxPath $composite::($this,listbox,path)

    bind $widget::($this,path) <FocusIn> "focus $listboxPath"          ;# when focus is set on base Tk widget, pass it on to listbox
    bind $listboxPath <Button2-Motion> break                                                           ;# disable button 2 scrolling
    pack $listboxPath -fill both -expand 1

    composite::manage $this\
        [new scrollbar $widget::($this,path) -command "$listboxPath yview" -highlightthickness 0 -takefocus 0] scrollbar
    widget::configure $composite::($this,listbox) -yscrollcommand "scrollList::updateScrollbar $this"

    composite::complete $this
}

proc scrollList::~scrollList {this} {}

proc scrollList::options {this} {
    return [list\
        [list -font font Font $widget::(default,ListboxFont) $widget::(default,ListboxFont)]\
        [list -height height Height $widget::(default,ListboxHeight) $widget::(default,ListboxHeight)]\
        [list -list list List {} {}]\
        [list -selectmode selectMode SelectMode $widget::(default,ListboxSelectMode) $widget::(default,ListboxSelectMode)]\
        [list -width width Width $widget::(default,ListboxWidth) $widget::(default,ListboxWidth)]\
    ]
}

proc scrollList::set-list {this value} {
    set listboxPath $composite::($this,listbox,path)
    $listboxPath delete 0 end
    eval $listboxPath insert 0 $value
    $listboxPath activate 0
}

foreach option {-font -height -selectmode -width} {
    proc scrollList::set$option {this value} "\$composite::(\$this,listbox,path) configure $option \$value"
}

# wrap all relevant listbox commands
foreach command {activate bbox curselection delete get index insert nearest scan see selection size} {
    proc scrollList::$command {this args} "eval \$composite::(\$this,listbox,path) $command \$args"
}

proc scrollList::updateScrollbar {this first last} {
    if {($last-$first)<1} {
        $composite::($this,scrollbar,path) set $first $last
        # pack scrollbar to the right of listbox and before it in the packing order so that it is visible for small ensemble widths
        pack $composite::($this,scrollbar,path) -fill y -before $composite::($this,listbox,path) -side right
    } else {                                                        ;# there is no need for a scrollbar since whole list can be seen
        pack forget $composite::($this,scrollbar,path)
    }
}
