set rcsId {$Id: widgetip.tcl,v 1.24 1997/09/30 17:53:20 jfontain Exp $}

class topLabel {}

proc topLabel::topLabel {this parentPath args} composite {
    [new toplevel $parentPath -highlightbackground black -highlightthickness 1] $args
} {
    composite::manage $this [new label $widget::($this,path)] label
    composite::complete $this
    pack $composite::($this,label,path)
    wm overrideredirect $widget::($this,path) 1                                                     ;# no window manager decorations
}

proc topLabel::~topLabel {this} {}

proc topLabel::options {this} {
    return [list\
        [list -bordercolor borderColor BorderColor Black Black]\
        [list -borderwidth borderWidth BorderWidth 1 1]\
        [list -background background Background $widget::(default,ButtonBackgroundColor) $widget::(default,ButtonBackgroundColor)]\
        [list -font font Font $widget::(default,ButtonFont) $widget::(default,ButtonFont)]\
        [list -foreground foreground Foreground $widget::(default,ButtonForeground) $widget::(default,ButtonForeground)]\
        [list -text text Text {} {}]\
    ]
}

foreach option {-background -font -foreground -text} {
    proc topLabel::set$option {this value} "\$composite::(\$this,label,path) configure $option \$value"
}

proc topLabel::set-bordercolor {this value} {
    $widget::($this,path) configure -highlightbackground $value
}

proc topLabel::set-borderwidth {this value} {
    $widget::($this,path) configure -highlightthickness $value
}

class widgetTip {}

if {![info exists widgetTip::(label)]} {
    set widgetTip::(label) [new topLabel . -font {Helvetica -12 normal} -background #FFFFBF]
    set widgetTip::(path) $widget::($widgetTip::(label),path)
    wm withdraw $widget::($widgetTip::(label),path)
    # handle button and key presses as global events because some child widgets (such as entries) don't pass them on to their parent
    bind all <ButtonPress> {widgetTip::globalEvent %W}
    bind all <KeyPress> {widgetTip::globalEvent %W}
    set widgetTip::(xLast) -1
    set widgetTip::(yLast) -1
}

# hack warning: use the widget class as a configuration interface. the base widget is always the same, is never used nor destroyed
proc widgetTip::widgetTip {this ignore args} composite {[new widget $widgetTip::(path)] $args} {
    composite::complete $this
}

proc widgetTip::~widgetTip {this} {
    disable $this
    catch {delete $widgetTip::($this,bindings)}                                                        ;# eventually remove bindings
}

proc widgetTip::options {this} {
    return [list\
        [list -text text Text {} {}]\
        [list -path path path {} {}]\
    ]
}

proc widgetTip::set-path {this value} {
    if {$composite::($this,complete)} {
        error {option -path cannot be set dynamically}
    }
    if {![winfo exists $value]} {
        error "invalid widget: \"$value\""
    }
    set bindings [new bindings $value 0]
    bindings::add $bindings <Enter> "widgetTip::enable $this"
    bindings::add $bindings <Leave> "widgetTip::disable $this"
    bindings::add $bindings <Destroy> "delete $this"                                                  ;# self destruct before target
    set widgetTip::($this,bindings) $bindings
}

proc widgetTip::set-text {this value} {}                                          ;# nothing to do, text is saved at composite level

proc widgetTip::globalEvent {widget} {
    if {![catch {string first $composite::($widgetTip::(active),-path) $widget} value]&&($value==0)} {
        # hide if active widget exists and is a descendant of the active target widget
        disable $widgetTip::(active)
    }
}

proc widgetTip::show {this x y} {
    set path $widgetTip::(path)
    widget::configure $widgetTip::(label) -text $composite::($this,-text)                                        ;# update tip label
    update idletasks                                                                                               ;# avoid flashing
    wm geometry $path +$x+$y                                                                                          ;# position it
    wm deiconify $path                                                                                                ;# and show it
    raise $path
}

proc widgetTip::enable {this} {
    set x [winfo pointerx $widgetTip::(path)]
    set y [winfo pointery $widgetTip::(path)]
    if {($x==$widgetTip::(xLast))&&($y==$widgetTip::(yLast))} {
        widgetTip::show $this [expr {$x+7}] [expr {$y+10}]
    } else {
        set widgetTip::(xLast) $x
        set widgetTip::(yLast) $y
        set widgetTip::(event) [after 500 "widgetTip::enable $this"]                                       ;# poll every half second
    }
    set widgetTip::(active) $this                                                                          ;# remember active object
}

proc widgetTip::disable {this} {
    # event and active tip may no longer exist when the pointer leaves after a click (for example)
    catch {after cancel $widgetTip::(event)}
    catch {unset widgetTip::(active)}
    wm withdraw $widgetTip::(path)
}
