source parray.tcl
source stooop.tcl

# expected output:
## a::a 1 x y X Y {1 2} 3
## b::b 1 x y X Y {1 2} 3
## a(1,_derived) = b
## a(1,m) = 1 2
## a(1,p) = x y
## a(1,q) = X Y
## b(1,n) = 1 2

proc a::a {this p q args} {
    puts "a::a $this $p $q $args"
    set a($this,m) [lindex $args 0]
    set a($this,p) $p
    set a($this,q) $q
}
proc a::~a {this} {
    puts "a::~a $this"
}
proc b::b {this p q args} a {$p $q $args} {
    puts "b::b $this $p $q $args"
    set b($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}

new b {x y} {X Y} {1 2} 3
printArrays a b
