source stooop.tcl

### check that virtual procedure invocations from base class constructor behave as in C++

# expected output:
## a::f 1 x
## a::g 1 x {y z}
## 1
## 1

proc a::a {this} {
    a::f $this x
    a::g $this x {y z}
    # pure virtual invocations behavior is undefined
    puts [catch {a::h $this x}]
    puts [catch {a::i $this x {y z}}]
}
proc a::~a {this} {}
virtual proc a::f {this p} {
    puts "a::f $this $p"
}
virtual proc a::g {this p args} {
    puts "a::g $this $p $args"
}
virtual proc a::h {this p}
virtual proc a::i {this p args}

proc b::b {this} a {} {}
proc b::~b {this} {}
virtual proc b::f {this p} {
    puts "b::f $this $p"
}
virtual proc b::g {this p args} {
    puts "b::g $this $p $args"
}
virtual proc b::h {this p} {
    puts "b::h $this $p"
}
proc b::i {this p args} {
    puts "b::i $this $p $args"
}

new b
