source parray.tcl
source stooop.tcl

### check that procedure invocation on variable arguments in derived class base class constructor arguments works

# expected output:
## a::a 1 {1 2} 3
## b::b 1 {1 2} 3
## a(1,_derived) = b
## a(1,m) = 1 2
## b(1,n) = 1 2

proc a::a {this args} {
    puts "a::a $this $args"
    set a($this,m) [lindex $args 0]
}
proc a::~a {this} {
    puts "a::~a $this"
}

proc b::b {this args} a {[concat $args]} {
    puts "b::b $this $args"
    set b($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}

new b {1 2} 3
printArrays a b
