source parray.tcl
source stooop.tcl

### check that variable arguments in derived class work with base class constructor constant arguments

# expected output:
## a::a 1 {1 2} 3
## b::b 1 x y {1 2} 3
## a(1,_derived) = b
## a(1,m) = {1 2} 3

proc a::a {this p} {
    puts "a::a $this $p"
    set a($this,m) $p
}
proc a::~a {this} {}

proc b::b {this p args} a {$args} {
    puts "b::b $this $p $args"
}
proc b::~b {this} {}

new b {x y} {1 2} 3
printArrays a
