set rcsId {$Id: stooop.tcl,v 1.50 1996/10/09 20:28:41 jfontain Exp $}


catch {rename proc ::proc}

if {[llength [info commands new]]==0} {

if {![info exists _newId]} {
    set _newId 0
}

::proc new {classOrId args} {

    global _newId _class

    if {[catch {expr $classOrId}]} {
        set _class([set id [incr _newId]]) $classOrId
        eval $classOrId::$classOrId $id $args
    } {
        [set _class([set id [incr _newId]]) $_class($classOrId)]::_copy $id $classOrId
    }
    return $id
}

::proc delete {args} {
    global _class

    foreach id $args {
        _delete $_class($id) $id
        unset _class($id)
    }
}

::proc _delete {class id} {

    $class::~$class $id
    global $class
    foreach name [array names $class $id,*] {
        unset ${class}($name)
    }
}

::proc classof {id} {
    global _class

    return $_class($id)
}

::proc _copy {class from to} {

    global $class

    set index [string length $from]
    foreach name [array names $class $from,*] {
        set ${class}($to[string range $name $index end]) [set ${class}($name)]
    }
    set index [string length $class$from]
    foreach name [info globals $class$from*] {
        global [set target $class$to[string range $name $index end]] $name
        array set $target [array get $name]
    }
}

}

::proc virtual {keyword name arguments args} {

    if {[string compare $keyword proc]!=0} {
        error "virtual operator works only on proc, not $keyword"
    }
    if {![regexp {^(.+)::(.+)$} $name dummy class procedure]} {
        error "$name is not a valid member procedure name"
    }
    if {[string compare $class $procedure]==0} {
        error "cannot make class $class constructor virtual"
    }
    if {[string compare ~$class $procedure]==0} {
        error "cannot make class $class destructor virtual"
    }
    if {[string compare [lindex $arguments 0] this]!=0} {
        error "cannot make static procedure $procedure of class $class virtual"
    }
    global _pureVirtual
    set _pureVirtual [expr [llength $args]==0]
    proc $name $arguments [lindex $args 0]
    unset _pureVirtual
}


::proc proc {name arguments args} {


    if {![regexp {^(.+)::(.+)$} $name dummy class procedure]} {
        ::proc $name $arguments [lindex $args 0]
        return
    }
    if {[llength $args]==0} {
        error "missing body for $name"
    }
    if {[string compare $class $procedure]==0} {
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class constructor first argument must be this"
        }
        if {[string compare [lindex $arguments 1] copy]==0} {
            if {[llength $arguments]!=2} {
                error "class $class copy constructor must have 2 arguments exactly"
            }
            if {[catch {info body $class::$class}]} {
                error "class $class copy constructor defined before constructor"
            }
            eval _constructorDeclaration $class 1 \{$arguments\} $args
        } {
            eval _constructorDeclaration $class 0 \{$arguments\} $args
            _generateDefaultCopyConstructor $class
        }
    } elseif {[string compare ~$class $procedure]==0} {
        if {[llength $arguments]!=1} {
            error "class $class destructor must have 1 argument exactly"
        }
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class destructor argument must be this"
        }
        if {[catch {info body $class::$class}]} {
            error "class $class destructor defined before constructor"
        }
        _destructorDeclaration $class $arguments [lindex $args 0]
    } {
        if {[catch {info body $class::$class}]} {
            error "class $class member procedure $procedure defined before constructor"
        }
        _memberProcedureDeclaration $class $procedure $arguments [lindex $args 0]
    }
}

::proc _ancestors {class} {
    global _bases _ancestors

    if {[info exists _ancestors($class)]} {
        return $_ancestors($class)
    }
    foreach base $_bases($class) {
        set ancestors($base) {}
        foreach ancestor [_ancestors $base] {
            set ancestors($ancestor) {}
        }
    }
    return [set _ancestors($class) [array names ancestors]]
}

::proc _constructorDeclaration {class copy arguments args} {
    global _bases _variable

    set number [llength $args]
    if {($number%2)==0} {
        error "bad $class constructor declaration, a base class, contructor arguments or body may be missing"
    }

    if {[string compare [lindex $arguments end] args]==0} {
        set _variable($class) {}
    }
    if {!$copy} {
        set _bases($class) {}
    }
    foreach {base baseArguments} [lrange $args 0 [expr $number-2]] {
        if {!$copy} {
            if {[lsearch -exact $_bases($class) $base]>=0} {
                error "class $class directly inherits from class $base more than once"
            }
            lappend _bases($class) $base
        }
        regsub -all \n $baseArguments {} constructorArguments($base)
    }
    set body [lindex $args end]

    if {[llength $_bases($class)]>0} {
        foreach base $_bases($class) {
            if {[string compare $class $base]==0} {
                error "class $class cannot be derived from itself"
            }
            if {[catch {info body $base::$base}]} {
                error "class $class constructor defined before base class $base constructor"
            }
        }
        set constructorBody \
"
global [_ancestors $class] $class
"
        if {[info exists _variable($class)]} {
            foreach base $_bases($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                if {[info exists _variable($base)]&&([string first {$args} $constructorArguments($base)]>=0)} {
                    append constructorBody \
"set _list \[list $constructorArguments($base)\]
eval $base::$base \$this \[lrange \$_list 0 \[expr \[llength \$_list\]-2\]\] \[lindex \$_list end\]
unset _list
set ${base}(\$this,_derived) $class
"
                } {
                    append constructorBody \
"$base::$base \$this $constructorArguments($base)
set ${base}(\$this,_derived) $class
"
                }
            }
        } {
            foreach base $_bases($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                append constructorBody \
"$base::$base \$this $constructorArguments($base)
set ${base}(\$this,_derived) $class
"
            }
        }
    } {
        set constructorBody \
"
global $class
"
    }
    if {$copy} {
        append constructorBody \
"catch {set ${class}(\$this,_derived) \[set ${class}(\$[lindex $arguments 1],_derived)\]}
"
    }
    append constructorBody $body
    if {$copy} {
        ::proc $class::_copy $arguments $constructorBody
    } {
        ::proc $class::$class $arguments $constructorBody
    }
}

::proc _destructorDeclaration {class arguments body} {
    global _bases

    set body \
"
global [_ancestors $class] $class
$body
"
    for {set index [expr [llength $_bases($class)]-1]} {$index>=0} {incr index -1} {
        set base [lindex $_bases($class) $index]
        append body \
"_delete $base \$this
"
    }
    ::proc $class::~$class $arguments $body
}

::proc _memberProcedureDeclaration {class name arguments body} {
    global _pureVirtual

    if {[info exists _pureVirtual]} {
        if {$_pureVirtual} {
            ::proc $class::$name $arguments \
"
global [_ancestors $class] $class
eval \$${class}(\$this,_derived)::$name \[lrange \[info level 0\] 1 end\]
"
        } {
            ::proc ::$class::$name $arguments \
"
global [_ancestors $class] $class
$body
"
            ::proc $class::$name $arguments \
"
global [_ancestors $class] $class
if {!\[catch {info body \$${class}(\$this,_derived)::$name}\]} {
return \[eval \$${class}(\$this,_derived)::$name \[lrange \[info level 0\] 1 end\]\]
}
eval ::\[info level 0\]
"
        }
    } {
        ::proc $class::$name $arguments \
"
global [_ancestors $class] $class
$body
"
    }
}

::proc _generateDefaultCopyConstructor {class} {

    global _bases

    foreach base $_bases($class) {
        append body \
"$base::_copy \$this \$sibling
"
    }
    append body \
"_copy $class \$sibling \$this
"
    ::proc $class::_copy {this sibling} $body
}

proc graphic::graphic {this canvas item} {
    set graphic($this,canvas) $canvas
    set graphic($this,item) $item
    $canvas bind $item <Button1-Motion> "graphic::moveTo $this %x %y"
    $canvas bind $item <ButtonRelease-1> "capture $this"
}

proc graphic::~graphic {this} {
    $graphic($this,canvas) delete $graphic($this,item)
}

virtual proc graphic::add {this object}

virtual proc graphic::moveBy {this x y} {
    $graphic($this,canvas) move $graphic($this,item) $x $y
}

virtual proc graphic::moveTo {this x y} {
    set coordinates [$graphic($this,canvas) coords $graphic($this,item)]
    $graphic($this,canvas) move $graphic($this,item) [expr $x-[lindex $coordinates 0]] [expr $y-[lindex $coordinates 1]]
}


proc picture::picture {this canvas} graphic {
    $canvas [$canvas create rectangle 0 0 100 80 -outline red -width 3]
} {
    set picture($this,graphics) {}
}

proc picture::~picture {this} {
}

proc picture::add {this object} {
    if {$object==$this} {
        return 0
    }
    set coordinates [$graphic($this,canvas) coords $graphic($object,item)]
    set x [lindex $coordinates 0]
    set y [lindex $coordinates 1]
    set box [$graphic($this,canvas) bbox $graphic($this,item)]
    if {($x>=[lindex $box 0])&&($x<=[lindex $box 2])&&($y>=[lindex $box 1])&&($y<=[lindex $box 3])} {
        if {[lsearch -exact $picture($this,graphics) $object]<0} {
            lappend picture($this,graphics) $object
        }
        return 1
    }
    return 0
}

proc picture::moveBy {this x y} {
    foreach object $picture($this,graphics) {
        graphic::moveBy $object $x $y
    }
    ::graphic::moveBy $this $x $y
}

proc picture::moveTo {this x y} {
    set coordinates [$graphic($this,canvas) coords $graphic($this,item)]
    picture::moveBy $this [expr $x-[lindex $coordinates 0]] [expr $y-[lindex $coordinates 1]]
}

proc oval::oval {this canvas} graphic {
    $canvas [$canvas create oval 0 0 22 12 -fill green]
} {}

proc oval::~oval {this} {}

proc oval::add {this object} {return 0}

proc rectangle::rectangle {this canvas} graphic {
    $canvas [$canvas create rectangle 0 0 20 10 -fill cyan]
} {}

proc rectangle::~rectangle {this} {}

proc rectangle::add {this object} {return 0}

set graphics {}

proc capture {moved} {
    global graphics

    foreach object $graphics {
        if {[graphic::add $object $moved]} {
            return 1
        }
    }
    return 0
}


bind . <q> exit

set canvas [canvas .canvas -highlightthickness 0 -width 500 -height 300]
pack $canvas -fill both -expand 1

label .create -text Create:
button .picture -text Picture -command {lappend graphics [new picture $canvas]}
button .rectangle -text Rectangle -command {lappend graphics [new rectangle $canvas]}
button .oval -text Oval -command {lappend graphics [new oval $canvas]}
button .exit -text Exit -command exit

button .clear -text Clear -command {
    eval delete $graphics
    set graphics {}
}

pack .create .picture .rectangle .oval -side left
pack .exit .clear -side right

