#!/bin/sh
# the next line restarts using the interpreter \
exec tclsh "$0" "$@"

set rcsId {$Id: source.tcl,v 1.3 1996/09/17 20:58:23 jfontain Exp $}

proc sourceCode {fileName} {
    global env sourced

    if {[info exists sourced($fileName)]} {
        # do not process the same file more than once
        return {}
    }
    set sourced($fileName) {}

    set code {}
    if {[string length $fileName]==0} {
        set file stdin
    } else {
        set file [open $fileName]
    }
    set skip 0
    while {[gets $file line]>=0} {
        if {[regexp {^[ 	]*#} $line]||$skip} {
            # skip comments and eventually following line
            set skip [string match {*\\} $line]
            continue
        }
        if {[regexp {^[ 	]*source[ 	]+([^ 	]+)} $line dummy name]} {
            append code [sourceCode [subst $name]]
            continue
        }
        append code $line\n
    }
    if {[string length $fileName]>0} {
        close $file
    }
    return $code
}

if {[string match -h* [lindex $argv 0]]} {
    puts "usage: $argv0 \[-o outputFile\] \[inputFile\]"
    exit
}

if {[string compare [lindex $argv 0] -o]==0} {
    set output [open [lindex $argv 1] w]
    set index 2
} else {
    set output stdout
    set index 0
}

puts $output [sourceCode [lindex $argv $index]]
close $output
