//
// matlab.i
// SWIG Module for Matlab 4.2
%module ml
%{
#include "engine.h"
%}

%section "MATLAB System Commands"

extern void init(char *);
/* Initialize the matlab application */

extern char *matlab(char *command);
/* Execute a matlab command */

extern Matrix *GetMatrix(char *name);
/* Retrieve a matrix from Matlab */

extern int PutMatrix(Matrix *matrix);
/* Give a matrix back to matlab */

extern double getr(Matrix *matrix, int i, int j);
/* Get real element (i,j) from matrix */

extern void setr(Matrix *matrix, int i, int j, double val);
/* Set real matrix element (i,j) to val */

%section "Matrix Data Structure Manipulation"

Matrix *mxCreateFull(int m, int n, int ComplexFlag);
/* Creates a full (dense) matrix.
   ConflexFlag is 0 = REAL or 1 = COMPLEX */

void mxFreeMatrix(Matrix *matrix);
/* Frees a matrix created by mxCreateFull */

int mxGetM(Matrix *mat);
/* Return number of rows */

int mxGetN(Matrix *mat);
/* Return number of columns */

void mxSetM(Matrix *mat, int m);
/* Sets number of rows */

void mxSetN(Matrix *mat, int n);
/* Sets number of columns */

char *mxGetName(Matrix *mat);
/* Gets matrix name */

void mxSetName(Matrix *mat, char *name);
/* Sets matrix name */

double *mxGetPr(Matrix *mat);
/* Get pointer to real part */

void mxSetPr(Matrix *mat, double *pr);
/* Set real pointer */



