# Tcl Script for PDE Problem

init matlab42
set npoints 40
set tolerance 0.0005
set ncontours 10
set viewa 45

proc run_it {npoints tolerance} {
            global ncontours
	    solve $npoints $tolerance

	    set M [mxCreateFull [expr {$npoints+1}] [expr {$npoints+1}] 0]
	    mxSetName $M Z

	    # Put solution into matrix

	    for {set i 0} {$i <= $npoints} {incr i 1} {
		for {set j 0} {$j <= $npoints} {incr j 1 } {
		    set u [get_u $i $j];
		    setr $M $j $i $u;
		}
	    }

	    # Dump it over to matlab and make a plot
	    
	    PutMatrix $M
            mxFreeMatrix $M
    matlab "contour(Z,[expr {$ncontours}])"
	}

proc tol {val} {
    global npoints tolerance
    set tolerance [expr {1/pow(10,[expr {[.error get]/2.0}])}];
#    run_it $npoints $tolerance;
}
proc npts {val} {
    global npoints tolerance
    set npoints [.npoints get]
#    run_it $npoints $tolerance;
}

proc nctrs {val} {
    global ncontours
    set ncontours [.ncontours get]
    matlab "contour(Z,[expr {$ncontours}])"
}

button .mesh -text "Mesh" -command {matlab {mesh(Z)}}
button .surf -text "Surf" -command {matlab {surf(Z)}}
button .contour -text "Contour" -command {matlab {contour(Z)}}
button .rotate -text "Rotate" -command {set viewa [expr {$viewa+30}];
    matlab "view([expr {$viewa}],45)";
}
button .print -text "Print" -command {matlab {print pout.ps -dpsc}}
button .normal -text "Colors : normal" -command {matlab {colormap hsv}}
button .hot -text "Colors : hot" -command {matlab {colormap hot}}
button .cool -text "Colors : cool" -command {matlab {colormap cool}}
button .shade_smooth -text "Smooth" -command {matlab {shading interp}}
button .shade_facet -text "Facet" -command {matlab {shading faceted}}
button .run -text "Calculate" -command {run_it $npoints $tolerance}
scale .error -label "Tolerance" -from 0 -to 16 -length 10c -orient horizontal -command tol
scale .npoints -label "Npoints" -from 10 -to 100 -length 10c -orient horizontal -command npts
scale .ncontours -label "Contours" -from 10 -to 40 -length 10c -orient horizontal -command nctrs

pack .mesh .surf .contour .rotate .normal .hot .cool .shade_smooth .shade_facet .print .run .error .npoints .ncontours -side top -fill x




