// ptrconst.i
//
// This module shows how SWIG can be used to handle constants
// that are pointers.   In C, it may not be necessary to have
// these, but in scripting languages, it can be extremely
// useful to manipulate function pointers, and other things.
//
// Of particular interest here :
// Notice the mix of "Vector" and "Vector *" datatypes.
// In a Tcl script they can be used interchangably!

%module ptrconst
%{

#include "vector.h"

extern Vector unit_i;
extern Vector unit_j;
extern Vector unit_k;

%}

%include tclsh.i

// A few basic operations

extern Vector *new_Vector(double x, double y, double z);
extern void delete_Vector(Vector *v);
extern Vector add_Vector(Vector *v1, Vector *v2);
extern Vector sub_Vector(Vector *v1, Vector *v2);

// Now we need to wrap this function :
//
// Vector op_Vector(Vector (*op)(Vector *, Vector *), Vector *v1, Vector *v2);
// 
// SWIG doesn't allow function pointers in a declaration like this, but
// you can fix it by using the typedef above and doing the following.
//
// Note : %typedef provides a C typedef automatically!

%typedef Vector (*VectorOp)(Vector *, Vector *);
extern Vector op_Vector(VectorOp, Vector *v1, Vector *v2);

// You can use SWIG to create callback functions for use in other
// C functions like this :

const VectorOp VADD = add_Vector;    // Note that these are really
const VectorOp VSUB = sub_Vector;    // functions!

// Now, let's install the unit vectors unit_i, etc... as constants
// This just creates a bunch of pointers (since SWIG likes that)

const Vector *UI = &unit_i;
const Vector *UJ = &unit_j;
const Vector *UK = &unit_k;

// Finally a debugging function

void print_Vector(Vector v1) {
    printf("v.x = %g, v.y = %g, v.z = %g\n");
}

