;;; Guile script for testing out matrix operations
;;; Hey, it's ugly, but oh well.

(define (zero M)
  (let ((define (zero_loop M i j)
	 (if (< i 4)
	     (if (< j 4) (begin
			   (set_m M i j 0.0)
			   (zero_loop M i (+ j 1))
			   )
                          (zero_loop M (+ i 1) 0)
			  )
	     )
        )
     ) (zero_loop M 0 0)
)
)

		      

def zero(M) :
    for i in range(0,4):
	for j in range(0,4):
	    set_m(M,i,j,0.0);

def identity(M) :
    zero(M);
    for i in range(0,4):
	for j in range(0,4):
	    set_m(M,i,i,1.0);

# Rotate around x axis

def rotx(M,r) :
    temp = new_matrix();
    rd = r*3.14159/180.0;
    zero(temp);
    set_m(temp,0,0,1.0);
    set_m(temp,1,1,cos(rd));
    set_m(temp,1,2,-sin(rd));
    set_m(temp,2,1, sin(rd));
    set_m(temp,2,2, cos(rd));
    set_m(temp,3,3,1.0);
    mat_mult(M,temp,M);
    destroy_matrix(temp);

# Rotate around y axis

def roty(M,r):
    temp = new_matrix();
    rd = r*3.14159/180.0;
    zero(temp);
    set_m(temp,1,1,1.0);
    set_m(temp,0,0, cos(rd));
    set_m(temp,0,2, sin(rd));
    set_m(temp,2,0, -sin(rd));
    set_m(temp,2,2, cos(rd));
    set_m(temp,3,3,1.0);
    mat_mult(M,temp,M);
    destroy_matrix(temp);

# Rotate around z axis

def rotz(M,r):
    temp = new_matrix();
    rd = r*3.14159/180.0;
    zero(temp);
    set_m(temp,0,0,cos(rd));
    set_m(temp,0,1,-sin(rd));
    set_m(temp,1,0,sin(rd));
    set_m(temp,1,1,cos(rd));
    set_m(temp,2,2,1.0);
    set_m(temp,3,3, 1.0);
    mat_mult(M,temp,M);
    destroy_matrix(temp);

def scale(M,s) :
    temp = new_matrix();
    zero(temp);
    for i in range(0,4):
	set_m(temp,i,i,s);
    mat_mult(M,temp,M);
    destroy_matrix(temp);

def randmat(M) :
    for i in range(0,4) :
        for j in range(0,4) :
	    set_m(M,i,j,drand48());

# Now we'll hammer on things a little bit just to make
# sure everything works.

print "Testing matrix program...";

M1=new_matrix();
identity(M1);
print_matrix(M1);
print "Rotate x 45 degrees";
rotx(M1,45);
print_matrix(M1);
print "Rotate y 30 degrees";
roty(M1,30);
print_matrix(M1);
print "Rotate z 15 degrees";
rotz(M1,15);
print_matrix(M1);
print "Scale 0.5";
scale(M1,0.5);
print_matrix(M1);

# Create a vector

v= createv(1,2,3,4);
print "Created vector (1,2,3,4)";
t = createv(0,0,0,0);

# Rotating ...
print "Rotating...";
for i in range(0,360):
    rotx(M1,1);
    rotz(M1,-0.5);
    transform(M1,v,t);

printv(t);

print "\nCreating 2000 matrices\n";

M_list = [];
for i in range(0,2000):
    M = new_matrix();
    randmat(M);
    M_list.append(M);

print "Adding them together (in Python)";
zero(M1);
for m in M_list:
    for i in range(0,4):
	for j in range(0,4):
	    set_m(M1,i,j, get_m(m,i,j) + get_m(M1,i,j));

print_matrix(M1);

print "Doing 2000 multiplications (mostly in C)";
M=new_matrix();
randmat(M);
for m in M_list:
    mat_mult(M1,m,M1);

print "Cleaning up\n";
for m in M_list:
    destroy_matrix(m);




