//
// SWIG C++ Test file
//

struct Vector {
  double x,y,z;
};

class Test {
public:
  
  // Test all basic datatypes

  int            num_int;
  short          num_short;
  long           num_long;
  unsigned int   num_uint;
  unsigned short num_ushort;
  unsigned long  num_ulong;
  unsigned char  num_uchar;
  signed   int   num_sint;
  signed   short num_sshort;
  signed   long  num_slong;
  signed   char  num_schar;
  double         num_double;
  float          num_float;
  char           char_c;
  char          *char_string;

  // Test pointers 

  int           *ptr_int;
  short         *ptr_short;
  long          *ptr_long;
  float         *ptr_float;
  double        *ptr_double;
  unsigned char *ptr_uchar;

  // Complex data types

  Vector         vec_value;       // Complex datatype by value
  Vector        *vec_ptr;         // Complex datatype by ptr

  // A few basic member functions

  int  sum_int(int a) {
    return a+num_int;
  }

  // A static member function

static double sum_double(double a, double b) {
  return a+b;
}

  // A member function with a reference

  int  sum_ref(int &a) {
    return a+num_int;
  }

  // A member function returning a reference 

  double &double_array(int size) {
    double *d;
    d = new double[size];
    return *d;
  }

  // Print out values of this structure 

static void print(Test &t) {
  printf("num_int = %d\n", t.num_int);
  printf("num_short = %hd\n", t.num_short);
  printf("num_long = %ld\n", t.num_long);
  printf("num_uint = %u\n", t.num_uint);
  printf("num_ushort = %u\n", t.num_ushort);
  printf("num_ulong = %lu\n", t.num_ulong);
  printf("num_uchar = %u\n", t.num_uchar);
  printf("num_ssint = %d\n", t.num_sint);
  printf("num_sshort = %d\n", t.num_sshort);
  printf("num_slong = %ld\n", t.num_slong);
  printf("num_schar = %d\n", t.num_schar);
  printf("num_float = %g\n", t.num_float);
  printf("num_double = %g\n", t.num_double);
  printf("char_c = %c\n", t.char_c);
  printf("char_string = %s\n", t.char_string);
  printf("ptr_int = %p\n", t.ptr_int);
  printf("ptr_short = %p\n", t.ptr_short);
  printf("ptr_long = %p\n", t.ptr_long);
  printf("ptr_float = %p\n", t.ptr_float);
  printf("ptr_double = %p\n", t.ptr_double);
  printf("ptr_uchar = %p\n", t.ptr_uchar);
  printf("vec_value : x= %g, y = %g, z = %g\n", t.vec_value.x, t.vec_value.y, t.vec_value.z);
  printf("vec_ptr : x = %g, y = %g, z= %g\n", t.vec_ptr->x, t.vec_ptr->y, t.vec_ptr->z);
  
}
  
  Test() {
    char_string = 0;
    ptr_int = 0;
    ptr_short = 0;
    ptr_long = 0;
    ptr_float = 0;
    ptr_double = 0;
    ptr_uchar = 0;
  }
};


  
    
  
  

  


  
  

  

  
  
    
