//
// SWIG C++ Test file
// This file should compile, link, and run correctly.
// 

%{

#include "test.h"

%}

%include tclsh.i
%include carray.i

struct Vector {
  double x,y,z;
  Vector();
  ~Vector();
};

class Test {
public:
  Test();
  ~Test();
  // Test all basic datatypes

  int            num_int;
  short          num_short;
  long           num_long;
  unsigned int   num_uint;
  unsigned short num_ushort;
  unsigned long  num_ulong;
  unsigned char  num_uchar;
  signed   int   num_sint;
  signed   short num_sshort;
  signed   long  num_slong;
  signed   char  num_schar;
  double         num_double;
  float          num_float;
  char           char_c;
  char          *char_string;

  // Test pointers 

  int           *ptr_int;
  short         *ptr_short;
  long          *ptr_long;
  float         *ptr_float;
  double        *ptr_double;
  unsigned char *ptr_uchar;

  // Complex data types

  Vector         vec_value;       // Complex datatype by value
  Vector        *vec_ptr;         // Complex datatype by ptr

  // A few basic member functions

  int  sum_int(int a);

  // A static member function

static double sum_double(double a, double b);

  // A member function with a reference

  int  sum_ref(int &a);

  // A member function returning a reference 

  double &double_array(int size);

static void print(Test &);

};


  
    
  
  

  


  
  

  

  
  
    
