#
# Tcl test file
# We're just going to exercise our ++ class a little bit
#

set t [new_Test];

# Initialize the various member parameters

Test_num_int_set      $t 5
Test_num_short_set    $t -7
Test_num_long_set     $t 12345789
Test_num_uint_set     $t 3000000000
Test_num_ulong_set    $t 5000000000    ;# May overflow on some machines
Test_num_uchar_set    $t 230
Test_num_sint_set     $t -8829
Test_num_sshort_set   $t -31000
Test_num_slong_set    $t -2800000000   ;# May overflow on some machines
Test_num_schar_set    $t -23
Test_num_double_set   $t 3.141592654
Test_num_float_set    $t 2.71828
Test_char_c_set       $t a
Test_char_string_set  $t {Hello World}

# Set a few pointers

Test_ptr_int_set      $t [array_int 40];
set d1 [array_double 40];

# Create a vector

set v [new_Vector]
Vector_x_set $v 2
Vector_y_set $v 3
Vector_z_set $v 4

# Set vector pointer

Test_vec_ptr_set $t $v

set v1 [Test_vec_value_get $t];
Vector_x_set $v1 10
Vector_y_set $v1 20
Vector_z_set $v1 30

# Test out some functions

puts "Testing basic member functions."
puts "Testing sum_int..."
set a [Test_sum_int $t 7]
puts "$a <-- Should get 12"

puts "Testing sum_double ..."
set a [Test_sum_double 3.14 5.2]
puts "$a <-- Should get 8.34"

puts "Testing sum_ref ..."
set ai [Test_ptr_int_get $t]
set_int $ai 0 18
set a [Test_sum_ref $t $ai]
puts "$a <-- Should get 23"

puts "Testing double_array"
set ad [Test_double_array $t 20]
set_double $ad 0 10.5
Test_ptr_double_set $t $ad
set ad1 [Test_ptr_double_get $t]
set b [get_double $ad1 0]
puts "$b <-- Should get 10.5"

# Retrieving vector value

puts "Retrieving vector"
set v1 [Test_vec_value_get $t]
set vx [Vector_x_get $v1]
set vy [Vector_y_get $v1]
set vz [Vector_z_get $v1]
puts "vx = $vx <-- Should be 10"
puts "vy = $vy <-- Should be 20"
puts "vz = $vz <-- Should be 30"

# Change Vector "value"

puts "Changing vector value"
Test_vec_value_set $t $v
set v1 [Test_vec_value_get $t]
set vx [Vector_x_get $v1]
set vy [Vector_y_get $v1]
set vz [Vector_z_get $v1]
puts "vx = $vx <-- Should be 2"
puts "vy = $vy <-- Should be 3"
puts "vz = $vz <-- Should be 4"

# Change pointer value

puts "Changing vector pointer values"
Vector_x_set $v 100
Vector_y_set $v 200
Vector_z_set $v 300
set v1 [Test_vec_value_get $t]
set vx [Vector_x_get $v1]
set vy [Vector_y_get $v1]
set vz [Vector_z_get $v1]
puts "vx = $vx <-- Should still be 2"
puts "vy = $vy <-- Should still be 3"
puts "vz = $vz <-- Should still be 4"

# Print out values

puts "Value of temp vector"
set vx [Vector_x_get $v]
set vy [Vector_y_get $v]
set vz [Vector_z_get $v]
puts "vx = $vx <-- Should be 100"
puts "vy = $vy <-- Should be 200"
puts "vz = $vz <-- Should be 300"

# Dump values

Test_print $t




