#!findfile
# This file defines some functions for building binary
# search trees.  All written in Tcl, but we're using
# a few functions for handling "Nodes" which are really
# C data structures.

set tree_head [new_Node "" head]
set tree_z    [new_Node __end__ ""]
Node_right_set $tree_head $tree_z
Node_left_set $tree_z $tree_z
Node_right_set $tree_z $tree_z

# Insert an item into the tree

proc insert_tree_tcl {key value} {
    global tree_head tree_z tree_size
    set p $tree_head
    set x [Node_right_get $tree_head]
    while {$x != $tree_z} {
	set p $x
	if {$key < [Node_key_get $x]} {set x [Node_left_get $x]} {set x [Node_right_get $x]}
    }
    set x [new_node $key $value]
    if {$key < [Node_key_get $p]} {Node_left_set $p $x} {Node_right_set $p $x}
    Node_left_set $x $tree_z
    Node_right_set $x $tree_z
    set tree_size [expr $tree_size + 1]
}

proc search_tree {key} {
    global tree_head tree_z
    set found {}
    set x [Node_right_get $tree_head]
    while {[Node_key_get $x] != "__end__"} {
	if {[Node_key_get $x] == $key} {lappend found [Node_value_get $x]} 
	if {$key < [Node_key_get $x]} {set x [Node_left_get $x]} {set x [Node_right_get $x]}
    }
    return $found
}

proc build_dir_tree {pathname} {
    global tree_head tree_z
    set error [catch {set filelist [glob -nocomplain $pathname/*]}]
    if {$error == 0} {
	foreach f $filelist {
	    if {[file isdirectory $f] == 1} {
		insert_tree [file tail $f] $f $tree_head $tree_z
		if {[file type $f] != "link"} {build_dir_tree $f}
	    } {
		insert_tree [file tail $f] $f $tree_head $tree_z
	    }
	}
    }
}

proc print_traverse {n} {
    global tree_z
    if {$n != $tree_z} {
	print_traverse [Node_left_get $n]
	puts [Node_value_get $n]
	print_traverse [Node_right_get $n]
    }
}

proc print_all {} {
    global tree_head
    print_traverse [Node_right_get $tree_head]
}

frame .path 
label .path.plabel -text "Search path :"
entry .path.pentry -width 64 -relief sunken -bd 2 -textvariable StartPath
pack .path.plabel .path.pentry -side left
pack .path -side top -fill x

bind .path.pentry <Return> {
	build_dir_tree $StartPath
        puts "Read $tree_size files so far..."
}
frame .find
label .find.flabel -text "Find file     :"
entry .find.fentry -width 32 -relief sunken -bd 2 -textvariable StartFile
pack .find.flabel .find.fentry -side left -padx 1m -pady 2m
pack .find -side top -fill x

bind .find.fentry <Return> {
    set search_list [search_tree $StartFile]
    destroy .files
    destroy .scroll
    listbox .files -relief raised -width 80 -borderwidth 2 -yscrollcommand ".scroll set"
    scrollbar .scroll -command ".files yview"
    pack .files .scroll -side left -fill both
    foreach i $search_list {
	.files insert end $i
    }

}

set StartPath "."    
set search_term ""
set search_list {}

listbox .files -relief raised -width 80 -borderwidth 2 -yscrollcommand ".scroll set"
pack .files -side left -fill both 
scrollbar .scroll -command ".files yview"
pack .scroll -side right -fill y
foreach i $search_list {
    .files insert end $i
}




