//
// SWIG File for a normal "structure"
//

%{

#include <math.h>

typedef struct {
  double x,y,z;
} Vector;

void Vector_print(Vector *v) {
  printf("x = %g, y = %g, z = %g\n", v->x, v->y, v->z);
}

void Vector_add(Vector *v1,Vector *v2, Vector *v3) {
  v3->x = v1->x + v2->x;
  v3->y = v1->y + v2->y;
  v3->z = v1->z + v2->z;
}

double Vector_mag(Vector *v) {
  return sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
}

%}

// SWIG Stuff

typedef struct {
  Vector();           // Note : These are SWIG extensions to create
  ~Vector();          // constructors and destructors in C
  double x,y,z;
} Vector;

void Vector_print(Vector *v);
void Vector_add(Vector *v1,Vector *v2,Vector *v3);
double Vector_mag(Vector *v);

%include tclsh.i



