
/* Solve a simple molecular dynamics calculation */

#include "md.h"

double Dt = 0.005;         /* Integration timestep */
double Mass = 1.0;

/* Create a new particle */

Particle *new_Particle(double x, double y, double vx, double vy) {
    Particle *p;
    p = (Particle *) malloc(sizeof(Particle));
    p->r.x = x;
    p->r.y = y;
    p->v.x = vx;
    p->v.y = vy;
    p->f.x = 0.0;
    p->f.y = 0.0;
    return p;
}

/* Calculate all of the forces on the atoms */

void forces(ParticleList *l, double (*force_func)(double r)) {
    ParticleList *l1, *l2;
    Particle *p1, *p2;
    double f,dx,dy,r;

    l1 = l;
    while (l1) {
	p1 = l1->p;
	p1->f.x = p1->f.y = 0.0;
	l1 = l1->next;
    }
    l1 = l;
    while (l1) {
	p1 = l1->p;
	l2 = l1->next;
	while (l2) {
	    /* Calculate forces between two particles */
	    p2 = l2->p;
	    dx = p2->r.x - p1->r.x;
	    dy = p2->r.y - p1->r.y;
	    r = sqrt(dx*dx + dy*dy);
	    f = (*force_func)(r);
	    f = f/r;
	    p1->f.x += f*dx;
	    p2->f.x -= f*dx;
	    p1->f.y += f*dy;
	    p2->f.y -= f*dy;
	    l2 = l2->next;
	}
	l1 = l1->next;
    }
}

/*
 * Integrate the equations of motion.  Super simple and inaccurate.
 * (hey this was only cooked up in about an hour).
 */

void integrate(ParticleList *l) {
    ParticleList *l1;
    Particle *p;
    l1 = l;
    while (l1) {
	p = l1->p;
	p->r.x += Dt*p->v.x;
	p->r.y += Dt*p->v.y;
	p->v.x += Dt*p->f.x/Mass;
	p->v.y += Dt*p->f.y/Mass;
	l1 = l1->next;
    }
}

/*
 * Here are some force functions
 */

/* Coulomb type force */

double force_invr(double r) {
    return 0.25/(r*r);
}

/* Lennard-jones force */

double force_lj(double r) {
    double r6;
    double r13;

    r6 = pow(r,6.0);
    r13 = pow(r,13.0);
    return 24.0*(r6 - 2.0)/r13;
}
