%module md
%{

#include "md.h"

%}

typedef struct Vector {
    double x,y;
} Vector;

typedef struct Particle {
    Vector r;
    Vector v;
    Vector f;
} Particle;

typedef struct ParticleList {
    ParticleList();
   ~ParticleList();
    Particle *p;
    ParticleList *next;
} ParticleList;

extern Particle *new_Particle(double x, double y, double vx, double vy);
extern double Dt;
extern double Mass;

%typedef double (*FORCE_FUNC)(double);

extern void  forces(ParticleList *l,FORCE_FUNC);
extern void  integrate(ParticleList *l);

const FORCE_FUNC  COULOMB = force_invr;
const FORCE_FUNC  LJ = force_lj;

double drand48();






