//
// This SWIG module shows how a simple C++ array can be created with
// SWIG

%module darray
%{

class DoubleArray {
public:
    int n;
    double *ptr;
    DoubleArray(int size) {
	ptr = new double[size];
	n = size;
    }
    ~DoubleArray() {
	delete ptr;
    }
    // Now declare some Python accessor functions	
    int    __len__() {
	return n;
    }
    double __getitem__(int i) {
	if ((i >= 0) && (i < n))
	    return ptr[i];
	else
	    return 0;
    }
    void __setitem__(int i, double val) {
	if ((i >= 0) && (i < n))
	    ptr[i] = val;
    }
};

%}

class DoubleArray {
public:
    int n;
    double *ptr;
    DoubleArray(int size);
    ~DoubleArray();
    int    __len__();
    double __getitem__(int i);
    void __setitem__(int i, double val);

};

