%module shapes
%{
#include "shapes.h"
%}

// An inheritance example with shapes

#define PI 3.141592654

class Shape {
private:
  double xc, yc;
public:
  virtual double area() = 0;
  virtual double perimeter() = 0;
  void    set_center(double _x, double _y);
  void    print_center();
};

class Circle: public Shape {
 private:
  double radius;
 public:
  Circle(double _r);
  double area();
  double perimeter();
};

class Square : public Shape {
private:
  double width;
public:
  Square(double _w);
  double area();
  double perimeter();
};





