/* File : except.i */

/* Here's an interesting file. Maybe something like this could be used
 * to extend SWIG with exceptions.
 */

%{

int  SWIG_Except = 0;
char *SWIG_ExceptMsg = 0;

void SWIG_Raise(char *msg) {
  SWIG_Except = 1;
  SWIG_ExceptMsg = msg;
}

/* Now execute a Tcl command and check for an exception */

int _wrap_swig_catch(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) {

  int ret;
  if (argc != 2) {
    Tcl_SetResult(interp, "swig_catch : wrong # args.", TCL_STATIC);
    return TCL_ERROR;
  }
  SWIG_Except = 0;
  ret = Tcl_Eval(interp, argv[1]);
  if (SWIG_Except) {
    Tcl_AppendResult(interp,"** SWIG Exception : ", SWIG_ExceptMsg, (char *) NULL);
    return TCL_ERROR;
  }
  return ret;
}

%}

%init %{
  Tcl_CreateCommand(interp, "swig_catch", _wrap_swig_catch,
		    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
  %}


