#!matrix
# Script file for testing out matrix operations.

proc zero M {
    for {set i 0} {$i < 4} {incr i 1} {
	for {set j 0} {$j < 4} {incr j 1} {
	    set_m $M $i $j 0.0
	}
    }
}

proc identity M {
    zero $M
    for {set i 0} {$i < 4 || $i < 4} {incr i 1} {
	set_m $M $i $i 1.0
    }
}

# Rotate around x axis

proc rotx {M r} {
    set temp [new_matrix]
    set rd [expr $r*3.14159/180]
    zero $temp
    set_m $temp 0 0 1.0
    set_m $temp 1 1 [expr cos($rd)]
    set_m $temp 1 2 [expr -sin($rd)]
    set_m $temp 2 1 [expr sin($rd)]
    set_m $temp 2 2 [expr cos($rd)]
    set_m $temp 3 3 1.0
    mat_mult $M $temp $M
    destroy_matrix $temp
}

# Rotate around y axis

proc roty {M r} {
    set temp [new_matrix]
    set rd [expr $r*3.14159/180]
    zero $temp
    set_m $temp 1 1 1.0
    set_m $temp 0 0 [expr cos($rd)]
    set_m $temp 0 2 [expr sin($rd)]
    set_m $temp 2 0 [expr -sin($rd)]
    set_m $temp 2 2 [expr cos($rd)]
    set_m $temp 3 3 1.0
    mat_mult $M $temp $M
    destroy_matrix $temp
}

# Rotate around z axis

proc rotz {M r} {
    set temp [new_matrix]
    set rd [expr $r*3.14159/180]
    zero $temp
    set_m $temp 0 0 [expr cos($rd)]
    set_m $temp 0 1 [expr -sin($rd)]
    set_m $temp 1 0 [expr sin($rd)]
    set_m $temp 1 1 [expr cos($rd)]
    set_m $temp 2 2 1.0
    set_m $temp 3 3 1.0
    mat_mult $M $temp $M
    destroy_matrix $temp
}

proc scale {M s} {
    set temp [new_matrix]
    zero $temp
    for {set i 0} {$i < 4} {incr i 1} {
	set_m $temp $i $i $s
    }
    mat_mult $M $temp $M
    destroy_matrix $temp
}

# Fill a matrix with random numbers 

proc randmat {M} {
    for {set i 0 } {$i < 4} {incr i 1} {
	for {set j 0} {$j < 4} {incr j 1} {
	    set_m $M $i $j 1
	}
    }
}

# Now we'll hammer on things a little bit just to make
# sure everything works.

puts "Testing matrix program..."

set M1 [new_matrix]
identity $M1
print_matrix $M1
puts "Rotate x 45 degrees"
rotx $M1 45
print_matrix $M1
puts "Rotate y 30 degrees"
roty $M1 30
print_matrix $M1
puts "Rotate z 15 degrees"
rotz $M1 15
print_matrix $M1
puts "Scale 0.5"
scale $M1 0.5
print_matrix $M1

# Create a vector

set v [createv 1 2 3 4]
puts "Created vector (1,2,3,4)"
set t [createv 0 0 0 0]

# Rotating ...
puts "Rotating..."
for {set i 0} {$i < 360} {incr i 1} {
    rotx $M1 1
    rotz $M1 -0.5
    transform $M1 $v $t
}

printv $t

puts "\n"
puts "Creating 2000 matrices"

set M_list {}
for {set i 0} {$i < 2000} {incr i 1} {
    set M [new_matrix]
    randmat $M
    lappend M_list $M
}

puts [time {
puts "Adding them together (in Tcl)"
zero $M1
foreach m $M_list {
    for {set i 0} {$i < 4} {incr i 1} {
	for {set j 0} {$j < 4} {incr j 1} {
	    set_m $M1 $i $j [expr {[get_m $m $i $j] + [get_m $M1 $i $j]}]
	}
    }
}
} 1]

print_matrix $M1

puts [time {    
puts "Doing 2000 multiplications (mostly in C)"
set M [new_matrix]
randmat $M
foreach m $M_list {
    mat_mult $M1 $m $M1
}
} 1]

puts "Cleaning up"
foreach m $M_list {
    destroy_matrix $m
}




