/* File : pragma.i */

// This file tests a new experimental %pragma directive.
// In this case, we are telling SWIG that the result of
// a function is dynamically allocated and that Tcl can clean
// it up.   %pragma will be fully supported in SWIG 1.1.
// This is only experimental.

%module prag
%{

/* Big time memory leak with normal SWIG */
    
char *new_string() {
    char *c;
    c = (char *) malloc(256);
    strcpy(c,"Hello world\n");
    return c;
}
%}

%include tclsh.i

// Take out this next line to get a big memory leak
%pragma(tcl,dynamic)    // Enable DYNAMIC return results
char *new_string();
%pragma(tcl,volatile)   // Back to volatile return results (the default)



