#!findfile
# This file defines some functions for building binary
# search trees.  All written in Tcl, but we're using
# a few functions for handling "Nodes" which are really
# C data structures.

set tree_head [new_node "" head]
set tree_z    [new_node __end__ ""]
set_right $tree_head $tree_z
set_left $tree_z $tree_z
set_right $tree_z $tree_z

# Insert an item into the tree

proc insert_tree_tcl {key value} {
    global tree_head tree_z tree_size
    set p $tree_head
    set x [get_right $tree_head]
    while {$x != $tree_z} {
	set p $x
	if {$key < [get_key $x]} {set x [get_left $x]} {set x [get_right $x]}
    }
    set x [new_node $key $value]
    if {$key < [get_key $p]} {set_left $p $x} {set_right $p $x}
    set_left $x $tree_z
    set_right $x $tree_z
    set tree_size [expr $tree_size + 1]
}

proc search_tree {key} {
    global tree_head tree_z
    set found {}
    set x [get_right $tree_head]
    while {[get_key $x] != "__end__"} {
	if {[get_key $x] == $key} {lappend found [get_value $x]} 
	if {$key < [get_key $x]} {set x [get_left $x]} {set x [get_right $x]}
    }
    return $found
}

proc build_dir_tree {pathname} {
    global tree_head tree_z
    set error [catch {set filelist [glob -nocomplain $pathname/*]}]
    if {$error == 0} {
	foreach f $filelist {
	    if {[file isdirectory $f] == 1} {
		insert_tree [file tail $f] $f $tree_head $tree_z
		if {[file type $f] != "link"} {build_dir_tree $f}
	    } {
		insert_tree [file tail $f] $f $tree_head $tree_z
	    }
	}
    }
}

proc print_traverse {n} {
    global tree_z
    if {$n != $tree_z} {
	print_traverse [get_left $n]
	puts [get_value $n]
	print_traverse [get_right $n]
    }
}

proc print_all {} {
    global tree_head
    print_traverse [get_right $tree_head]
}

frame .path 
label .path.plabel -text "Search path :"
entry .path.pentry -width 64 -relief sunken -bd 2 -textvariable StartPath
pack .path.plabel .path.pentry -side left
pack .path -side top -fill x

bind .path.pentry <Return> {
	build_dir_tree $StartPath
        puts "Read $tree_size files so far..."
}
frame .find
label .find.flabel -text "Find file     :"
entry .find.fentry -width 32 -relief sunken -bd 2 -textvariable StartFile
pack .find.flabel .find.fentry -side left -padx 1m -pady 2m
pack .find -side top -fill x

bind .find.fentry <Return> {
    set search_list [search_tree $StartFile]
    destroy .files
    destroy .scroll
    listbox .files -relief raised -width 80 -borderwidth 2 -yscrollcommand ".scroll set"
    scrollbar .scroll -command ".files yview"
    pack .files .scroll -side left -fill both
    foreach i $search_list {
	.files insert end $i
    }

}

set StartPath "."    
set search_term ""
set search_list {}

listbox .files -relief raised -width 80 -borderwidth 2 -yscrollcommand ".scroll set"
pack .files -side left -fill both 
scrollbar .scroll -command ".files yview"
pack .scroll -side right -fill y
foreach i $search_list {
    .files insert end $i
}




