
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/Include/RCS/swig.h,v 1.25 1996/08/31 21:54:55 dmb Exp dmb $
 *
 * swig.h
 *
 * This is the header file containing the main class definitions and
 * declarations.   Should be included in all extensions and code
 * modules.
 *
 * -- Revision History
 * $Log: swig.h,v $
 * Revision 1.25  1996/08/31 21:54:55  dmb
 * Minor changes
 *
 * Revision 1.24  1996/08/28 16:43:11  dmb
 * Minor changes
 *
 * Revision 1.23  1996/08/27 22:57:56  dmb
 * Added SWIG_exit() prototype
 *
 * Revision 1.22  1996/08/27 05:06:24  dmb
 * Added field to sstring class to get big performance boost
 *
 * Revision 1.21  1996/08/25 00:04:21  dmb
 * Added parameter to cpp_inherit() function in the Language class.
 * Added pragma function to Language class
 *
 * Revision 1.20  1996/08/21 16:49:50  dmb
 * Minor cleanup to eliminate warnings.
 *
 * Revision 1.19  1996/08/21 05:46:09  dmb
 * Minor modifications to language class in order to support better
 * parsing of structs and classes.
 *
 * Revision 1.18  1996/08/15 05:07:36  dmb
 * Add type-mangling as a language-dependent option (in order to
 * support Perl5 pointers).
 *
 * Revision 1.17  1996/08/12 01:53:06  dmb
 * Changes to language class structure
 *
 * Revision 1.16  1996/06/10 21:50:18  beazley
 * Changed version number
 *
 * Revision 1.15  1996/06/02  00:16:55  beazley
 * Cleaned up a few things
 *
 * Revision 1.14  1996/05/22  20:24:20  beazley
 * Added some more emit functions
 *
 * Revision 1.13  1996/05/20  23:36:25  beazley
 * Extended language class with C++ functions.   Default methods
 * are provided, but each target language can certainly override
 * these.
 *
 * Revision 1.12  1996/05/17  05:52:15  beazley
 * A few more minor changes
 *
 * Revision 1.11  1996/05/14  23:24:40  beazley
 * Minor changes
 *
 * Revision 1.10  1996/05/13  23:47:26  beazley
 * Changed Language class for better handling of module names
 *
 * Revision 1.9  1996/05/10  23:39:23  beazley
 * Removed some obsolete variables.  Added a mode field to Documentation class.
 *
 * Revision 1.8  1996/05/03  22:30:05  dmb
 * Added IncludeFile() function.
 *
 * Revision 1.7  1996/05/03 05:12:10  dmb
 * Added CPlusPlus variable.
 *
 * Revision 1.6  1996/05/01 22:43:00  dmb
 * Added check_options() stub.
 *
 * Revision 1.5  1996/04/14 15:25:05  dmb
 * Took out <unistd.h>
 * ./
 *
 * Revision 1.4  1996/04/03 22:49:21  beazley
 * Added IgnoreComments variable.
 *
 * Revision 1.3  1996/03/28  02:48:34  beazley
 * Added implicit_ptr field to datatypes in order to handle certain types of
 * datatypes correctly.
 *
 * Revision 1.2  1996/03/22  23:43:56  beazley
 * Changed class structure slightly. Cleaned stuff up.
 *
 * Revision 1.1  1996/03/16  06:30:32  beazley
 * Initial revision
 *
 * Revision 1.12  1996/03/04  21:30:22  beazley
 * Changed usage() function prototypes.
 *
 * Revision 1.11  1996/02/20  04:16:16  beazley
 * Took out stream library.
 *
 * Revision 1.10  1996/02/16  08:31:01  beazley
 * Added <stdlib.h>
 *
 * Revision 1.9  1996/02/16  05:21:35  beazley
 * Added Perl5 support back
 *
 * Revision 1.8  1996/02/15  22:38:57  beazley
 * Changed copyright.  Added typedef stuff.
 *
 * Revision 1.7  1996/02/12  08:21:07  beazley
 * Minor changes
 *
 * Revision 1.6  1996/02/07  05:21:00  beazley
 * Added declarations for documentation.  Cleaned up alot of stuff.
 *
 * Revision 1.5  1996/01/16  00:56:00  beazley
 * Minor changes.
 *
 * Revision 1.4  1996/01/15  22:12:17  beazley
 * Added guile support
 *
 * Revision 1.3  1996/01/13  01:33:38  beazley
 * Added Perl 4.0 include
 *
 * Revision 1.2  1996/01/05  22:41:04  dmb
 * *** empty log message ***
 *
 * Revision 1.1  1995/12/30 04:34:43  dmb
 * Initial revision
 *
 *
 ***********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define SWIG_MAJOR_VERSION 1
#define SWIG_MINOR_VERSION 0
#define SWIG_SPIN " (September 9,1996)"

/* Global variables.   Needs to be cleaned up */


extern  FILE      *f_header;                        // Some commonly used
extern  FILE      *f_wrappers;                      // FILE pointers
extern  FILE      *f_init;
extern  FILE      *f_input;
extern  char      InitName[256];             
extern  char      LibDir[512];                      // Library directory
extern  char     **InitNames;                       // List of other init functions
extern  int       Status;                           // Variable creation status
extern  int       TypeStrict;                       // Type checking strictness
extern  int       Verbose;
extern  int       yyparse();
extern  int       line_number;
extern  char     *input_file;                       // Current input file
extern  int       IgnoreComments;                   // Ignore comments flag
extern  int       CPlusPlus;                        // C++ mode
extern  int       Dirty;                            // Dirty mode

/* Miscellaneous stuff */

#define  STAT_READONLY  1


/************************************************************************
 * class DataType
 *
 * Defines the basic datatypes supported by the translator.
 *
 ************************************************************************/

#define    T_INT       1
#define    T_DOUBLE    2
#define    T_CHAR      3
#define    T_VOID      4
#define    T_FLOAT     5
#define    T_SHORT     6
#define    T_LONG      7
#define    T_USER      8
#define    T_ERROR     99

// Unsigned versions of the above types.   

#define    T_UINT      11
#define    T_USHORT    16
#define    T_ULONG     17
#define    T_UCHAR     13

// Signed versions of the above

#define    T_SINT      21
#define    T_SSHORT    26
#define    T_SLONG     27
#define    T_SCHAR     23

#define    M_NONE      0
#define    M_UNSIGNED  10
#define    M_SIGNED    20

// Class for storing data types

class DataType {
public:
  int         type;          // SWIG Type code
  char        name[64];      // Name of type
  int         is_pointer;    // Is this a pointer?
  int         implicit_ptr;  // Implicit ptr				  
  int         is_reference;  // A C++ reference type
  char        *qualifier;    // A qualifier string (ie. const).
  DataType();
  DataType(DataType *);
  DataType(int type);
  ~DataType();
  char       *print_type();  // Return string containing datatype
  char       *print_full();  // Return string with full datatype
  char       *print_cast();  // Return string for type casting
  char       *print_mangle();// Return mangled version of type
  char       *print_mangle_default(); // Default mangling scheme
};

/************************************************************************
 * class ParmList
 *
 * Maintains function parameter lists as a linked list.
 *
 * Parameters have a calling type (call_type)
 *   
 *      CALL_VALUE  -->  Call by value even though function parameter
 *                       is a pointer.   
 *                          ex :   foo(&_arg0);  
 *      CALL_REF    -->  Call by reference even though function parameter
 *                       is by value
 *                          ex :   foo(*_arg0);
 ************************************************************************/

#define CALL_VALUE      0x01
#define CALL_REFERENCE  0x02

struct Parm {
  DataType   *t;                // Datatype of this parameter
  int        call_type;         // Call type (value or reference)
  char       *name;             // Name of parameter (optional)
};

class ParmList {
  private :
  struct   Pnode {              // Maintain a linked list of parms
    Parm        *p;
    Pnode       *next;
  };
  Pnode  *head, *z;
  Pnode  *current;
  public :
  ParmList();
  ParmList(ParmList *);
  ~ParmList();
  void   add_param(Parm *p);    // Add a new parameter to list
  Parm  *get_first();           // Get first parameter from list
  Parm  *get_next();            // Get next parameter from list      
  void   print_types(FILE *f);  // Print list of datatypes
  void   make_string(FILE *f);  // Not sure what this is for now
};

// Functions for default C++ methods 

extern void cpp_member_func_default(char *, char *, DataType *, ParmList *);
extern void cpp_constructor_default(char *classname, char *iname, ParmList *);
extern void cpp_destructor_default(char *classname, char *newname);
extern void cpp_inherit_default(char *baseclass, int);
extern void cpp_variable_default(char *name, char *iname, DataType *t);
extern void cpp_static_func_default(char *name, char *iname, DataType *, ParmList *);
extern void cpp_declare_const_default(char *name, char *iname, DataType *, char *value);
extern void cpp_static_var_default(char *name, char *iname, DataType *);

/************************************************************************
 * class language:
 *
 * This class defines the functions that need to be supported by the
 * scripting language being used.    The translator calls these virtual
 * functions to output different types of code for different languages.
 *
 * By implementing this using virtual functions, hopefully it will be
 * easy to support different types of scripting languages.
 *
 * The following functions are used :
 *
 *    parse_args(argc, argv)
 *           Parse the arguments used by this language.
 *
 *    parse()
 *           Entry function that starts parsing of a particular language
 *
 *    create_function(fname, iname, rtype, parmlist)
 *           Creates a function wrappper.
 *
 *    link_variable(vname, iname, type)
 *           Creates a link to a variable.
 *    
 *    declare_const(cname, type, value)
 *           Creates a constant (for #define).
 *
 *    initialize(char *fn)
 *           Produces initialization code.
 *
 *    headers()
 *           Produce code for headers
 *
 *    close()
 *           Close up files
 *
 *    usage_var(iname,type,string)
 *           Produces usage string for variable declaration.
 *
 *    usage_func(iname,rttype, parmlist, string)
 *           Produces usage string for function declaration.
 *
 *    usage_const(iname, type, value, string)
 *           Produces usage string for constants
 *           
 *    set_module(char *modname)
 *           Sets the name of the module (%module directive)
 *
 *    set_init(char *initname)
 *           Sets name of initialization function (an alternative to set_module)
 *    add_native(char *name, char *funcname);
 *           Adds a native wrapper function to the initialize process
 *
 *    type_mangle(DataType *t);
 *           Mangles the name of a datatype.
 * --- C++ Functions ---
 *
 *    These functions are optional additions to any of the target
 *    languages.   SWIG handles inheritance, symbol tables, and other
 *    information.
 *
 *    cpp_open_class(char *classname, char *rname) 
 *          Open a new C++ class definition.
 *    cpp_close_class(char *)
 *          Close current C++ class
 *    cpp_member_func(char *name, char *rname, DataType *rt, ParmList *l)
 *          Create a C++ member function
 *    cpp_constructor(char *name, char *iname, ParmList *l) 
 *          Create a C++ constructor.
 *    cpp_destructor(char *name, char *iname) 
 *          Create a C++ destructor
 *    cpp_variable(char *name, char *iname, DataType *t)
 *          Create a C++ member data item.
 *    cpp_declare_const(char *name, char *iname, int type, char *value)
 *          Create a C++ constant.
 *    cpp_inherit(char *baseclass)
 *          Inherit data from baseclass.
 *    cpp_static_func(char *name, char *iname, DataType *t, ParmList *l) 
 *          A C++ static member function.
 *    cpp_static_var(char *name, char *iname, DataType *t)
 *          A C++ static member data variable.
 *
 *************************************************************************/

class Language {
public:
  virtual void parse_args(int argc, char *argv[]) = 0;
  virtual void parse() = 0;
  virtual void create_function(char *, char *, DataType *, ParmList *) = 0; 
  virtual void link_variable(char *, char *, DataType *)  = 0;
  virtual void declare_const(char *, DataType *, char *) = 0;
  virtual void initialize(void) = 0;
  virtual void headers(void) = 0;
  virtual void close(void) = 0;
  virtual void usage_var(char *, DataType *, char **) = 0;
  virtual void usage_func(char *, DataType *, ParmList *, char **) = 0;
  virtual void usage_const(char *, DataType *, char *, char **) = 0;
  virtual void set_module(char *mod_name) = 0;
  virtual void set_init(char *init_name) = 0;
  virtual void add_native(char *, char *);
  virtual char *type_mangle(DataType *t) {
    return t->print_mangle_default();
  }
  //
  // C++ language extensions.
  // You can redefine these, or use the defaults below
  //
       
  virtual void cpp_member_func(char *name, char *iname, DataType *t, ParmList *l) {
    cpp_member_func_default(name,iname,t,l);
  }
  virtual void cpp_constructor(char *name, char *iname, ParmList *l) {
    cpp_constructor_default(name, iname, l);
  }
  virtual void cpp_destructor(char *name, char *newname) {
    cpp_destructor_default(name, newname);
  }
  virtual void cpp_open_class(char *, char *, char *) { };
  virtual void cpp_close_start(char *) { };
  virtual void cpp_close_class() { };
  virtual void cpp_cleanup() { };
  virtual void cpp_inherit(char *baseclass) { 
    cpp_inherit_default(baseclass,1);
  }
  virtual void cpp_variable(char *name, char *iname, DataType *t) {
    cpp_variable_default(name, iname, t);
  }
  virtual void cpp_static_func(char *name, char *iname, DataType *t, ParmList *l) {
    cpp_static_func_default(name, iname, t, l);
  }
  virtual void cpp_declare_const(char *name, char *iname, DataType *type, char *value) {
    cpp_declare_const_default(name, iname, type, value);
  } 
  virtual void cpp_static_var(char *name, char *iname, DataType *t) {
    cpp_static_var_default(name,iname,t);
  }
  // Pragma directive (currently unsupported)
  virtual void pragma(char *lname, char *name, char *value) { }
};

/* Documentation system */

#define  D_VAR   1
#define  D_FUNC  2
#define  D_TEXT  3

class DocEntry {
private:
public :
  char  *name;             // Name of the entry
  char  *usage;            // Usage string
  int    type;             // Entry type
  char  *descrip;          // Description (optional)
  char  *category;         // Category
  DocEntry();              // A bunch of constructors for different types
  DocEntry(char *cat);
  DocEntry(char *cat, char *iname, DataType *t, ParmList *l);
  DocEntry(char *cat, char *iname, DataType *t);
  DocEntry(char *cat, char *name, int type, char *value);
  DocEntry(char *cat, char *text);
};

class Documentation {
private:
  struct DocNode {
    DocEntry *de;
    DocNode  *next;
  };
  DocNode *head, *z;        // Head, tail of documentation list
  enum DocMode {RAW, ALPHA};				 
  DocMode  mode;
public:
  Documentation();
  void       add_doc(DocEntry *de);
  DocEntry **sort_doc(void);
  void       print_doc(void);
  void       set_doc_raw(void) {
    mode = RAW;
  } 
  void       set_doc_alpha(void) {
    mode = ALPHA;
  }

  // These functions used for specific documentation systems

  virtual void print_entry(DocEntry *) = 0; 
  virtual void print_title(char *fn) = 0;
  virtual void print_category(char *category) = 0;
  virtual void print_subcategory(char *subcat) = 0;
  virtual void init(char *filename) = 0;
  virtual void close(void) = 0;
};

/* Emit functions */

extern  void  emit_extern_var(char *, DataType *, int, FILE *);
extern  void  emit_extern_func(char *, DataType *, ParmList *, int, FILE *);
extern  int   emit_args(DataType *, ParmList *, FILE *);

extern  void  emit_func_call(char *, DataType *, ParmList *, FILE *);

extern  void  emit_hex(FILE *);
extern  void  emit_set_get(char *, char *, DataType *);
extern  void  emit_banner(FILE *);
extern  void  emit_ptr_equivalence(char *name, FILE *);
extern  int   SWIG_main(int, char **, Language *, Documentation *);
extern  void  make_wrap_name(char *);

/* Function for building search directories */

extern  void  Add_directory(char *dirname);
extern  int   IncludeFile(char *, FILE *);

/* Miscellaneous */

extern void check_options();
extern void init_args(int argc, char **);
extern void mark_arg(int n);
extern void arg_error();
extern char *copy_string(char *);

// --------------------------------------------------------------------------
// EXPERIMENTAL ADD-ONS
//
// The following definitions are not used by the SWIG 1.0 core, but will be
// available in SWIG 2.0.   They are provided for use in SWIG Target language
// modules.
// --------------------------------------------------------------------------

// -------------------------------------------------------------------
// Hash table class
// -------------------------------------------------------------------

class Hash {
private:
  struct Node {
    Node(const char *k, void *obj, void (*d)(void *)) {
      key = new char[strlen(k)+1];
      strcpy(key,k);
      object = obj;
      del_proc = d;
      next = 0;
    };
    ~Node() {
      delete key;
      if (del_proc) (*del_proc)(object);
    };
    char        *key;
    void        *object;
    struct Node *next;
    void (*del_proc)(void *);
  };
  int    h1(const char *key);      // Hashing function
  int    hashsize;                 // Size of hash table
  Node  **hashtable;               // Actual hash table
public:
  Hash();
  ~Hash();
  int    add(const char *key, void *object);
  int    add(const char *key, void *object, void (*del)(void *));
  void  *lookup(const char *key);
};

// -----------------------------------------------------------------------
// Experimental String class (from SWIG 2.0)
// -----------------------------------------------------------------------

class String {
private:
  char  *str;               // String data (NULL terminated)
  int   maxsize;            // Max size of current string
  void  add(const char *newstr);  // Function to add a new string
  int   len;
public:
  String();
  String(const char *s);
  ~String();
  char  *get() const;                
  friend String& operator<<(String&,const char *s);
  friend String& operator<<(String&,const int);
  friend String& operator<<(String&,String&);
  String& operator=(const char *);   
};

#define  tab2   "  "
#define  tab4   "    "
#define  tab8   "        "
#define  br     "\n"
#define  endl   "\n"
#define  quote  "\""

// -----------------------------------------------------------------------
// Experimental Class for Creating Wrapper Functions
// -----------------------------------------------------------------------

class WrapperFunction {
private:
  Hash    h;
public:
  String  def;
  String  locals;
  String  code;
  String  init;                    
  void    print(FILE *f);
  void    add_local(char *type, char *name);
static    void    del_type(void *obj);
};

extern  int   emit_args(DataType *, ParmList *, WrapperFunction &f);
extern  void  emit_func_call(char *, DataType *, ParmList *, WrapperFunction &f);

extern  void  SWIG_exit(int);
