
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/**********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/Modules/RCS/pycpp.cxx,v 1.5 1996/08/26 23:34:37 dmb Exp $
 *
 * pycpp.cxx
 *
 * $Log: pycpp.cxx,v $
 * Revision 1.5  1996/08/26 23:34:37  dmb
 * Minor fixes
 *
 * Revision 1.4  1996/08/26 16:31:42  dmb
 * Made it so shadow class modules do not include the low-level C
 * interface functions
 *
 * Revision 1.3  1996/08/25 00:04:57  dmb
 * Made some more improvements to shadow classes
 *
 * Revision 1.2  1996/08/21 05:50:00  dmb
 * Changed method of accessing structure attributes
 *
 * Revision 1.1  1996/08/18 03:32:14  dmb
 * Initial revision
 *
 *
 * This module contains code to generate Python shadow classes of C/C++
 * objects.   This is highly experimental!!!!!!
 **************************************************************************/


#include "swig.h"
#include "python.h"

static  String   *setattr;
static  String   *getattr;
static  String   *pyclass;
static  String   *construct;
static  String   *cinit;
static  int       have_constructor;
static  int       have_destructor;
static  char     *class_name;
static  char     *class_type;
static  char     *real_classname;
static  char     *base_class = 0;

// --------------------------------------------------------------------------
// PYTHON::cpp_open_class(char *classname, char *rname)
//
// Opens a new C++ class or structure.
// --------------------------------------------------------------------------

void PYTHON::cpp_open_class(char *classname, char *rname, char *ctype) {

  if (shadow) {
    /* Create new strings for building up a wrapper function */
    
    setattr   = new String();
    getattr   = new String();
    pyclass   = new String();
    construct = new String();
    cinit     = new String();
    
    //  *pyclass << "class " << rname << ":\n";
    *setattr << tab4 << "def __setattr__(self,name,value):\n";
    *getattr << tab4 << "def __getattr__(self,name):\n";
    have_constructor = 0;
    have_destructor = 0;
    if (rname)
      class_name = copy_string(rname);
    else
      class_name = copy_string(classname);
  }

  real_classname = copy_string(classname);
  if (base_class) delete base_class;
  base_class = (char *) 0;
  class_type = copy_string(ctype);
}

// --------------------------------------------------------------------------
// PYTHON::cpp_member_func(char *name, char *iname, DataType *t, ParmList *l)
//
// Creates a C++ member function
// --------------------------------------------------------------------------

void PYTHON::cpp_member_func(char *name, char *iname, DataType *t, ParmList *l) {

  Parm *p;
  int   i;
  char *realname;
  int   oldshadow;
  // Create the default member function
  
  oldshadow = shadow;    // Disable shadowing when wrapping member functions
  shadow = 0;
  cpp_member_func_default(name,iname,t,l);
  shadow = oldshadow;
  if (shadow) {
    if (!iname)
      realname = name;
    else
      realname = iname;
    
    
    // Now add it to the class
    
    *pyclass << tab4 << "def " << realname << "(self";
    p = l->get_first();
    if (p) *pyclass << ",";
    i = 0;
    while(p) {
      *pyclass << "arg" << i;
      p = l->get_next();
      if (p)
	*pyclass << ",";
      i++;
    }
    *pyclass << "):\n";
    *pyclass << tab8;
    if ((t->type != T_VOID) || (t->is_pointer > 0))
      *pyclass << "val = ";
    
    if ((hash.lookup(t->name)) && (t->is_pointer <=1))
      *pyclass << (char *) hash.lookup(t->name) << "Ptr(";
    
    *pyclass << module << "." << class_name << "_" << realname << "(self.this";
    p = l->get_first();
    i = 0;
    if (p) *pyclass << ",";
    while(p) {
      *pyclass << "arg" << i;
      if ((hash.lookup(p->t->name)) && (p->t->is_pointer <= 1))
	*pyclass << ".this";
      p = l->get_next();
      if (p)
	*pyclass << ",";
      i++;
    }
    if ((hash.lookup(t->name)) && (t->is_pointer <=1))
      *pyclass << "))\n";
    else
      *pyclass << ")\n";
    if ((hash.lookup(t->name)) && (t->is_pointer < 1))
      *pyclass << tab8 << "val.thisown = 1\n";
    if ((t->type != T_VOID) || (t->is_pointer))
      *pyclass << tab8 << "return val\n";
  }
}

// -----------------------------------------------------------------------------
// void PYTHON::cpp_constructor(char *name, char *iname, ParmList *l)
//
// Make a constructor for our class
// -----------------------------------------------------------------------------

void PYTHON::cpp_constructor(char *name, char *iname, ParmList *l) {
  char *realname;
  Parm *p;
  int   i;
  int   oldshadow = shadow;

  shadow = 0;
  cpp_constructor_default(name, iname, l);
  shadow = oldshadow;

  if (shadow) {
    *construct << tab4 << "def __init__(self";
    p = l->get_first();
    i = 0;
    if (p)
      *construct << ",";
    while (p) {
      *construct << "arg" << i;
      p = l->get_next();
      if (p)
	*construct << ",";
      
      i++;
    }
    *construct << ") :\n";
    
    if (iname)
      realname = iname;
    else
      realname = name;
    
    *construct << tab8 << "self.this = " << module << "." << "new_" << realname << "(";
    p = l->get_first();
    i = 0;
    while (p) {
      *construct << "arg" << i;
      p = l->get_next();
      if (p)
	*construct << ",";
      i++;
    }
    *construct << ")\n";
    *construct << tab8 << "self.thisown = 1\n";
    have_constructor = 1;
  }
}

// ------------------------------------------------------------------------------
// void PYTHON::cpp_destructor(char *name, char *newname)
//
// Creates a destructor for this object
// ------------------------------------------------------------------------------

void PYTHON::cpp_destructor(char *name, char *newname) {
  char *realname;
  int oldshadow = shadow;

  shadow = 0;
  cpp_destructor_default(name, newname);
  shadow = oldshadow;
  if (shadow) {
    if (newname) realname = newname;
    else realname = name;
    
    *pyclass << tab4 << "def __del__(self):\n"
	     << tab8 << "if self.thisown == 1 :\n"
	     << tab8 << tab4 << module << ".delete_" << realname << "(self.this)\n";
    
    have_destructor = 1;
  }
}

// -------------------------------------------------------------------------------
// PYTHON::cpp_close_class()
//
// Closes a Python class and writes out a wrapper
// -------------------------------------------------------------------------------

void PYTHON::cpp_close_start(char *newname) {

  char temp[128];
  
  /* This starts the process of closing a class.  We check to see if the class
     suddenly got renamed */

  if (newname) class_name = copy_string(newname);

  if (newname) 
    hash.add(newname,copy_string(class_name));        /* Map new name to classname       */
  hash.add(real_classname,copy_string(class_name));   /* Map original classname to class */

  // Add full name of datatype to the hash table

  sprintf(temp,"%s %s", class_type, real_classname);
  hash.add(temp,copy_string(class_name));             /* Map full classname to classs    */

}

    
void PYTHON::cpp_close_class() {
  String    ptrclass;

  if (shadow) {
    *setattr << tab8 << "self.__dict__[name] = value\n";
    *getattr << tab8 << "return\n";

    if (!have_constructor) {
      // Build a constructor that takes a pointer to this kind of object
      *construct << tab4 << "def __init__(self,this):\n";
      *construct << tab8 << "self.this = this\n";
    }

    // First, build the pointer base class

    if (base_class)
      ptrclass << "class " << class_name << "Ptr(" << base_class << "Ptr):\n";
    else
      ptrclass << "class " << class_name << "Ptr :\n";
    ptrclass << tab4 << "def __init__(self,this):\n"
	     << tab8 << "self.this = this\n"
	     << tab8 << "self.thisown = 0\n"
	     << *cinit;
    fprintf(f_shadow,"%s", ptrclass.get());
    fprintf(f_shadow,"%s", pyclass->get());
    fprintf(f_shadow,"%s", setattr->get());
    fprintf(f_shadow,"%s", getattr->get());
    fprintf(f_shadow,"\n\n");

    // Now build the real class with a normal constructor

    fprintf(f_shadow,"class %s(%sPtr):\n", class_name, class_name);
    fprintf(f_shadow,"%s\n\n", construct->get());
    delete pyclass;
    delete setattr;
    delete getattr;
  }
}

void PYTHON::cpp_cleanup() { };

void PYTHON::cpp_inherit(char *baseclass) {

  char *bc;
  
  // Register the inheritance with the type-checker and C++ module,
  // but don't actually add the functions.
  cpp_inherit_default(baseclass,0);

  // Now tell the Python module that we're inheriting from a base class

  /* Lookup the base-class in the hash table */

  bc = (char *) hash.lookup(baseclass);
  if (bc) {
    base_class = copy_string(bc);
  }

  // The base class retrieved, is the "python" name of the base-class.
}

// --------------------------------------------------------------------------------
// PYTHON::cpp_variable(char *name, char *iname, DataType *t)
//
// Adds an instance member.
// --------------------------------------------------------------------------------

void PYTHON::cpp_variable(char *name, char *iname, DataType *t) {
  char *realname;
  int   inhash = 0;
  int   oldshadow = shadow;

  shadow = 0;
  cpp_variable_default(name, iname, t);
  shadow = oldshadow;

  if (shadow) {
    if (!iname)
      realname = name;
    else
      realname = iname;
    
    // Figure out if we've seen this datatype before
    
    if ((hash.lookup(t->name)) && (t->is_pointer <= 1)) inhash = 1;
    
    // Now write some code to set the variable
    *setattr << tab8 << "if name == \"" << realname << "\" :\n";
    if (inhash) {
      *setattr << tab8 << tab4 << module << "." << class_name << "_" << realname << "_set(self.this,value.this)\n";
    } else {
      *setattr << tab8 << tab4 << module << "." << class_name << "_" << realname << "_set(self.this,value)\n";
    }
    *setattr << tab8 << tab4 << "return\n";
    
    // Write some code to get the variable
    *getattr << tab8 << "if name == \"" << realname << "\" : \n";
    if (inhash) {
      *getattr << tab8 << tab4 << "return " << (char *) hash.lookup(t->name) << "Ptr(" << module << "."
	       << class_name << "_" << realname << "_get(self.this))\n";
    } else {
      *getattr << tab8 << tab4 << "return " << module << "." << class_name << "_" << realname << "_get(self.this)\n";
    }
  }
}

// --------------------------------------------------------------------------------
// PYTHON::cpp_declare_const(char *name, char *iname, DataType *type, char *value)
//
// Add access to a C++ constant
// --------------------------------------------------------------------------------

void PYTHON::cpp_declare_const(char *name, char *iname, DataType *type, char *value) {
  char *realname;
  int   oldshadow = shadow;
  
  shadow = 0;
  cpp_declare_const_default(name, iname, type, value);
  shadow = oldshadow;

  if (shadow) {
    if (!iname)
      realname = name;
    else
      realname = iname;
    
    *cinit << tab8 << "self." << realname << " = " << module << "." << class_name << "_" << realname << "\n";
  }
  
}

    
