
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/Modules/RCS/swigmain.cxx,v 1.9 1996/08/21 05:50:43 dmb Exp $
 *
 * swig_main.cc
 *
 * The main program.
 *
 * -- Revision History
 * $Log: swigmain.cxx,v $
 * Revision 1.9  1996/08/21 05:50:43  dmb
 * Minor changes
 *
 * Revision 1.8  1996/08/12 01:51:19  dmb
 * Changed handling of command line options
 *
 * Revision 1.7  1996/05/22 20:20:21  beazley
 * Changed name of tcl class
 *
// Revision 1.6  1996/05/01  22:42:30  dmb
// Cleaned up command line options and fixed -help option
//
 * Revision 1.5  1996/04/14 15:24:20  dmb
 * Changed name of the file. Fixed headers.
 *
 * Revision 1.4  1996/03/28 02:47:41  beazley
 * Added Guile3 support back in
 *
// Revision 1.3  1996/03/24  22:15:03  beazley
// Added python support.
//
// Revision 1.2  1996/03/22  23:42:04  beazley
// Added Perl4, Perl5
//
// Revision 1.1  1996/03/16  06:28:54  beazley
// Initial revision
//
 *
 ***********************************************************************/

#include "wrap.h"
#include "swigtcl.h"
#include "perl4.h"
#include "perl5.h"
#include "python.h"
#include "guile3.h"
#include "ascii.h"
#include "latex.h"
#include "html.h"
#include "nodoc.h"

static char  *usage = "\
swig <options> filename\n\n\
Target Language Options:\n\
     -tcl            - Generate Tcl wrappers.\n\
     -python         - Generate Python wrappers.\n\
     -perl5          - Generate Perl5 wrappers.\n\
     -perl4          - Generate Perl4 wrappers.\n\
     -guile3         - Generate Guile3 wrappers.\n";

//-----------------------------------------------------------------
// main()
//
// Main program.    Initializes the files and starts the parser.
//-----------------------------------------------------------------

int main(int argc, char *argv[]) {
  int i;

  Language *dl = new SWIG_LANG;
  Documentation *dd = new SWIG_DOC;
  extern int SWIG_main(int, char **, Language *, Documentation *);

  init_args(argc,argv);
  
  // Get options
  for (i = 1; i < argc; i++) {
      if (argv[i]) {
	  if(strcmp(argv[i],"-tcl") == 0) {
	      dl = new TCL;
	      mark_arg(i);
	  } else if (strcmp(argv[i],"-perl4") == 0) {
	      dl = new PERL4;
	      mark_arg(i);
	  } else if (strcmp(argv[i],"-perl5") == 0) {
	      dl = new PERL5;
	      mark_arg(i);
	  } else if (strcmp(argv[i],"-python") == 0) {
	      dl = new PYTHON;
	      mark_arg(i);
	  } else if (strcmp(argv[i],"-guile3") == 0) {
	      dl = new GUILE3;
	      mark_arg(i);
	  } else if (strcmp(argv[i],"-help") == 0) {
	      fputs(usage,stderr);
	      mark_arg(i);
	  }
      }
  }
  SWIG_main(argc,argv,dl,dd);
  return 0;
}


