
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/ascii.cxx,v 1.9 1996/08/27 22:58:14 dmb Exp $
 *
 * ASCII.c
 *
 * ASCII specific functions for producing documentation.
 *
 * -- Revision History
 * $Log: ascii.cxx,v $
 * Revision 1.9  1996/08/27 22:58:14  dmb
 * Minor fix to error handling
 *
 * Revision 1.8  1996/08/21 16:48:40  dmb
 * Minor cleanup to eliminate compiler warnings.
 *
 * Revision 1.7  1996/08/21 05:46:43  dmb
 * Minor cleanup of output
 *
 * Revision 1.6  1996/05/22 20:20:21  beazley
 * Fixed bug with uninitialized usage vars.
 *
// Revision 1.5  1996/05/10  23:37:16  beazley
// Cleaned up documentation a little bit.  Added support for text blocks.
//
// Revision 1.4  1996/03/16  06:25:25  beazley
// Changed to work with new headers.
//
// Revision 1.3  1996/02/20  04:06:58  beazley
// Took out streams stuff.
//
// Revision 1.2  1996/02/15  22:36:52  beazley
// Changed copyright
//
// Revision 1.1  1996/02/07  05:24:20  beazley
// Initial revision
//
 *
 ***********************************************************************/

#include "swig.h"
#include "ascii.h"

// -------------------------------------------------------------------
// print_string(char *)
//
// Prints a string to the document file.   Wraps around to next line
// if exceeds line length.
// -------------------------------------------------------------------

void ASCII::print_string(char *s) { 

  char *c;
  int i;
  c = s;
  int lbreak = 0;

  while (*c) {
    switch(*c) {
    case '\n':
    case '\\':
      if (lbreak) {
	col = startc;
	fputc('\n',f_doc);
	for (i = 0; i < startc; i++)
	  fputc(' ',f_doc);
	lbreak = 0;
      } else {
	if ((*c) == '\n') {
	  fputc(' ',f_doc);
	  col++;
	}
	lbreak++;
      }
      break;
    case ' ':
    case '\t':
      if (col > endc) {
	fputc('\n',f_doc);
	for (i = 0; i < startc; i++)
	  fputc(' ',f_doc);
	col = startc;
      } else {
	fputc(' ',f_doc);
	col++;
      }
      // Skip over rest of white space found 
      while ((*c) && ((*c) == ' ') || ((*c) == '\t') || ((*c) == '\n')) c++;
      c--;
      lbreak = 0;
      break;
    default :
      lbreak = 0;
      fputc(*c,f_doc);
      col++;
      break;
    }
    c++;
  }
}

// --------------------------------------------------------------
// print_entry(DocEntry *)
//
// Print a documentation entry
// --------------------------------------------------------------

void ASCII::print_entry(DocEntry *de) { 

  int i;
  char *c;
  startc = 0;
  endc = 70;
  col = 0;

  if (!de->usage) return;

  c = de->usage;
  while ((*c) && ((*c == ' ') || (*c == '\t') || (*c == '\n'))) c++;
  if (c) print_string(c);
  
  if (de->descrip != 0) {
    fprintf(f_doc,"\n");
    startc = 10;
    col = 0;
    for ( i = 0; i < startc; i++,col++)
      fputc(' ',f_doc);
    c = de->descrip;
    while ((*c) && ((*c == ' ') || (*c == '\t'))) c++;
    print_string(c);
    fprintf(f_doc,"\n\n");
    startc = 0;
    col = 0;
  } else {
      fprintf(f_doc,"\n\n");
      col = 0;
      startc = 0;
  }
}

void ASCII::print_title(char *f) { 
  extern char *get_time();

  col = 0;
  startc = 0;
  endc = 70;
  print_string(f);
  fprintf(f_doc,"\n");
  col = 0;
  print_string("Created : ");
  print_string(get_time());
  fprintf(f_doc,"\n\n");
  col = 0;
  
}

void ASCII::print_category(char *category) {
  int i;
  cat_count++;
  fprintf(f_doc,"\n%d. %s\n", cat_count, category);
  for (i = 0; i < 3+(int) strlen(category); i++)
    fputc('=',f_doc);
  fprintf(f_doc,"\n\n");
  col = 0;
}

void ASCII::print_subcategory(char *category) {
  int i;
  fprintf(f_doc,"\n%s : \n",category);
  for (i = 0; i < 2+(int) strlen(category); i++)
    fputc('-',f_doc);
  fprintf(f_doc,"\n\n");
  col = 0;
}

void ASCII::init(char *filename) {
  char f[256];

  cat_count = 0;
  col = 0;
  startc = 0;
  endc = 70;

  sprintf(f,"%s_wrap.doc",filename);
  sprintf(fn,"%s",filename);
  f_doc = fopen(f,"w");
  if (f_doc == NULL) {
    fprintf(stderr, "Unable to open %s\n", fn);
    SWIG_exit(1);
  }

}

void ASCII::close(void) {

  fclose(f_doc);
  if (Verbose) 
    fprintf(stderr,"Documentation written to %s_wrap.doc\n", fn);

}
      



    
    
  






  
  
