
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/doc.cxx,v 1.10 1996/08/21 16:48:40 dmb Exp $
 *
 * doc.c
 *
 * This is the header file containing declarations for the documentation
 * system.
 *
 * -- Revision History
 * $Log: doc.cxx,v $
 * Revision 1.10  1996/08/21 16:48:40  dmb
 * Minor cleanup to eliminate compiler warnings.
 *
 * Revision 1.9  1996/08/12 01:47:36  dmb
 * Added support for %disabledoc and %enabledoc
 *
 * Revision 1.8  1996/06/15 22:36:26  beazley
 * Fixed subtle bug in constructors
 *
// Revision 1.7  1996/05/13  23:43:28  beazley
// Wrote a whole new set of constructors (of various) types.
// Cleans up alot of junk in the parser and elsewhere.
//
// Revision 1.6  1996/05/10  23:37:39  beazley
// Added support for text-blocks and in-order formatting.
//
// Revision 1.5  1996/04/14  15:23:32  dmb
// Fixed header files.
//
 * Revision 1.4  1996/03/16 06:25:34  beazley
 * Changed to work with new headers.
 *
// Revision 1.3  1996/02/16  06:38:49  beazley
// Removed a few unused variables.
//
// Revision 1.2  1996/02/15  22:37:15  beazley
// Changed copyright
//
// Revision 1.1  1996/02/07  05:26:00  beazley
// Initial revision
//
 *
 ***********************************************************************/

#include "internal.h"

// Make new documentation entries

DocEntry::DocEntry(char *cat) {
  category = new char[strlen(cat)+1];
  strcpy(category,cat);
  descrip = 0;
  type = 0;
  usage = 0;
  name = 0;
}

// Make a new documentation entry for a function call

DocEntry::DocEntry(char *cat, char *i, DataType *t, ParmList *l) {
  category = new char[strlen(cat)+1];
  strcpy(category, cat);
  descrip = 0;
  usage = 0;
  type = D_FUNC;
  name = new char[strlen(i)+1];
  strcpy(name, i);
  lang->usage_func(i,t,l, &usage);
}

// Make a new documentation entry for a variable

DocEntry::DocEntry(char *cat, char *i, DataType *t) {
  category = new char[strlen(cat)+1];
  strcpy(category, cat);
  descrip = 0;
  usage = 0;
  type = D_VAR;
  name = new char[strlen(i)+1];
  strcpy(name, i);
  lang->usage_var(i,t,&usage);
}

// Make a new documentation entry for a constant

DocEntry::DocEntry(char *cat, char *i, int, char *) {
  category = new char[strlen(cat)+1];
  strcpy(category, cat);
  descrip = 0;
  usage = 0;
  type = D_VAR;
  name = new char[strlen(i)+1];
  strcpy(name, i);
}

// Make a new documentation entry for a text block

DocEntry::DocEntry(char *cat, char *text) {
  category = new char[strlen(cat)+1];
  strcpy(category, cat);
  descrip = 0;
  type = D_TEXT;
  name = "";
  usage = new char[strlen(text)+1];
  strcpy(usage, text);
}

DocEntry::DocEntry() {
    category = new char[1];
    category[0] = 0;
    descrip = 0;
    type = 0;
    usage = 0;
    name = 0;
  }


// Make new documentation class

Documentation::Documentation() {
    z = new DocNode;
    z->next = z;
    z->de = new DocEntry;
    z->de->category = new char[1];
    z->de->category[0] = 0;
    head = new DocNode;
    head->de = new DocEntry;
    head->next = z;
    mode = RAW;
  }

// ------------------------------------------------------------------
// add_doc(DocEntry *de)
//
// Add a documentation entry to the list.
// Will add to the end of the list to preserve documentation order.
// ------------------------------------------------------------------

void Documentation::add_doc(DocEntry *de) {
    DocNode *d,*d1;
    
    if (IgnoreDoc) return;       /* Do nothing */		
    d1 = head;
    d = head->next;
    while (d != z) {
      d1 = d;
      d = d->next;
    }
    d = new DocNode;
    d->de = de;
    d->next = z;
    d1->next = d;

    if (de->type == D_TEXT) {
      de->name = "";
    }
  }

// -------------------------------------------------------------------
// sort_doc()
//
// Sorts the documentation entry list
// -------------------------------------------------------------------

DocEntry ** Documentation::sort_doc(void) {

    int count = 0;
    int i,j;
    DocNode  *d;
    DocEntry **list;
    DocEntry  *v;

    // First count how many entries we've got

    d = head->next;
    while (d != z) {
      d = d->next;
      count++;
    }

    list = (DocEntry **) malloc((count+2)*sizeof(DocEntry *));
    
    // Now put pointers into list
    
    d = head->next;
    i = 0;
    while (d != z) {
      list[i] = d->de;
      d = d->next;
      i++;
    }

    if (mode == ALPHA) {
      // Now do an insertion sort by name

      for (i = 1; i < count; i++) {
	v = list[i];
	j = i;
	while((j > 0) && (strcmp(list[j-1]->name,v->name) > 0)) {
	  list[j] = list[j-1];
	  j--;
	}
	list[j] = v;
      }

      // Now do an insertion sort by category

      for (i = 1; i < count; i++) {
	v = list[i]; 
	j = i;
	while((j > 0) && (strcmp(list[j-1]->category,v->category)) > 0) {
	  list[j] = list[j-1];
	  j--;
	}
	list[j] = v;
      }
    }

    list[count] = 0;
    return list;

  }

// -------------------------------------------------------------------
// print_doc()
//
// Print out all of the documentation 
// -------------------------------------------------------------------

void Documentation::print_doc(void) {

    DocEntry  **list;
    DocEntry  **d,**last;
    char      *category;
    int       vc, fc;

    list = sort_doc();    // Sort it all out

    // Print category title 

    last = list;
    while ((*last) != 0) {
      category = (*last)->category;
      print_category(category);
      d = last;    
      vc = 0;
      fc = 0;
      // Count up how many of each time we have

      while (((*d) != 0) && (strcmp((*d)->category,category) == 0)) {
	if ((*d)->type == D_VAR) vc++;
	if ((*d)->type == D_FUNC) fc++;
	d++;
      }

      if (mode == ALPHA) {
	// Now print out all of the functions

	d = last;
	while(((*d) != 0) && (strcmp((*d)->category,category) == 0)) {
	  if ((*d)->type == D_TEXT)
	    print_entry(*d);
	  d++;
	}
	
	if ((vc) && (fc))
	  print_subcategory("Functions");
    
	d = last;
	while(((*d) != 0) && (strcmp((*d)->category,category) == 0)) {
	  if ((*d)->type == D_FUNC)
	    print_entry(*d);
	  d++;
	}

	// Now print out all of the variables

	d = last;
	if (vc) 
	  print_subcategory("Variables");

	while (((*d) != 0) && (strcmp((*d)->category,category) == 0)) {
	  if ((*d)->type == D_VAR)
	    print_entry(*d);
	  d++;
	}
      } else {

	// In raw mode.   Go in order 
	d = last;
	while (((*d) != 0) && (strcmp((*d)->category,category) == 0)) {
	    print_entry(*d);
	    d++;
	}
      }	
      last = d;
    }
  }


    
      



    
    
  






  
  
