
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/emit.cxx,v 1.30 1996/08/31 21:41:18 dmb Exp $
 *
 * emit.c
 *
 * This file contains some useful functions for emitting code that would be
 * common to all of the interface languages.  Mainly this function deals with
 * declaring functions external, creating lists of arguments, and making
 * function calls.
 *
 *
 * -- Revision History
 * $Log: emit.cxx,v $
 * Revision 1.30  1996/08/31 21:41:18  dmb
 * Minor fix to emit_hex()
 *
 * Revision 1.29  1996/08/29 17:13:14  dmb
 * Whoops, didn't quite nail it....
 *
 * Revision 1.28  1996/08/29 17:07:08  dmb
 * Fixed bug in return type.
 *
 * Revision 1.27  1996/08/27 22:58:44  dmb
 * Took out #line directives
 *
 * Revision 1.26  1996/08/21 16:48:40  dmb
 * Minor cleanup to eliminate compiler warnings.
 *
 * Revision 1.25  1996/08/21 05:47:32  dmb
 * Minor changes to clean things up
 *
 * Revision 1.24  1996/08/12 01:47:54  dmb
 * Many changes to fix C++ references.  Also added some code in support
 * of new wrapper coding style.
 *
 * Revision 1.23  1996/08/02 02:59:12  dmb
 * Changed to use better parameter list functions
 *
 * Revision 1.22  1996/08/01 16:46:27  dmb
 * Removed unused variable "dt" from emit_hex function.
 *
 * Revision 1.21  1996/07/23 14:39:33  dmb
 * Minor change to pointer handling
 *
 * Revision 1.20  1996/07/17 15:46:55  dmb
 * Whoops. Didn't quite do it right last time.
 *
 * Revision 1.19  1996/07/17 15:43:24  dmb
 * Changed hex-emit code.
 *
 * Revision 1.18  1996/06/20 18:27:56  dmb
 * Fixed bug in get/set function
 *
 * Revision 1.17  1996/06/18 15:33:13  dmb
 * Fixed string constant bugs with SPARCWorks compiler
 *
 * Revision 1.16  1996/06/10 23:33:56  beazley
 * Added const to hex functions.
 *
// Revision 1.15  1996/06/02  00:14:04  beazley
// Fixed bug with C++ references.
//
// Revision 1.14  1996/05/22  20:20:21  beazley
// Minor changes
//
// Revision 1.13  1996/05/20  23:35:18  beazley
// Added a few things to help support C++
//
// Revision 1.12  1996/05/17  05:52:50  beazley
// Added set/get functions.  Changed emit_hex() function to include
// C++ support.
//
// Revision 1.11  1996/05/14  23:23:34  beazley
// A few minor fixes to emit_hex()
//
// Revision 1.10  1996/05/13  23:43:53  beazley
// Modified the emit_hex() function to look for an input file
// (allowing the user to redefine the pointer conversions).
//
// Revision 1.9  1996/04/14  15:24:03  dmb
// Fixed headers.
//
 * Revision 1.8  1996/03/28 02:46:00  beazley
 * Made a few slight changes to support bug fix in %typedef declaration.
 *
// Revision 1.7  1996/03/24  22:14:09  beazley
// Changed pointer/hex functions to use "NULL" for 0 pointer instead of 0.
//
// Revision 1.6  1996/03/22  23:40:07  beazley
// A few minor changes. Cleaned some stuff up.
//
// Revision 1.5  1996/03/16  06:25:44  beazley
// Major revision. Cleaned up functions.  Added type checking
// to hex conversion functions.
//
// Revision 1.4  1996/03/04  21:28:05  beazley
// Add typename to hex conversion functions.
//
// Revision 1.3  1996/02/19  05:31:49  beazley
// Added function to emit hexadecimal conversions.
//
// Revision 1.2  1996/02/15  22:37:24  beazley
// Changed copyright.   A few minor fixes.
//
// Revision 1.1  1996/02/07  05:25:24  beazley
// Initial revision
//
 *
 ***********************************************************************/

#define EMIT
#include "internal.h"

// ----------------------------------------------------------------------
// emit_banner(FILE *f)
//
// Emits the SWIG identifying banner.
// ----------------------------------------------------------------------

void emit_banner(FILE *f) {

  extern char *get_time();
  extern char fn_header[];

  fprintf(f,
"/*\n\
 * FILE : %s\n\
 * %s \
 * \n\
 * This file was automatically generated by :\n\
 * Simplified Wrapper and Interface Generator (SWIG)\n\
 * Version %d.%d %s\n\
 * \n\
 * Copyright (c) 1995,1996\n\
 * The Regents of the University of California and\n\
 * The University of Utah\n\
 *\n\
 */\n\n", fn_header,get_time(), SWIG_MAJOR_VERSION, SWIG_MINOR_VERSION, SWIG_SPIN);

}

// ----------------------------------------------------------------------
// emit_extern_var(char *decl, DataType *t, int extern_type)
//
// Emits an external variables declaration.   Extern_type defines the
// type of external declaration.  Currently, only C/C++ declarations
// are allowed, but this might be extended to allow Fortran linkage
// someday
// ----------------------------------------------------------------------

void emit_extern_var(char *decl, DataType *t, int extern_type, FILE *f) {

  switch(extern_type) {

  case 0:
    // No extern.  Just a forward reference
    if (t->is_reference) {
      t->is_pointer--;
      fprintf(f,"%s& %s; \n", t->print_full(), decl);
      t->is_pointer++;
    } else {
      fprintf(f,"%s %s; \n", t->print_full(), decl);
    }
    
    break;
  case 1: case 2:
    // Normal C/C++ extern
//    fprintf(f,"#line %d \"%s\"\n", line_number, input_file);
    if (t->is_reference) {
      t->is_pointer--;
      fprintf(f,"extern %s& %s; \n", t->print_full(), decl);
      t->is_pointer++;
    } else {
      fprintf(f,"extern %s %s; \n", t->print_full(), decl);
    }
  default:
    break;
  }
}

// ----------------------------------------------------------------------
// emit_extern_func(char *decl, DataType *t, ParmList *L, int extern_type,
//                  FILE *f)
//
// Emits an external function declaration (similiar to emit_extern_var).
// ----------------------------------------------------------------------

void emit_extern_func(char *decl, DataType *t, ParmList *L, int extern_type, FILE *f) {

  switch(extern_type) {
  case 0:
    if (t->is_reference) {
      t->is_pointer--;
      fprintf(f,"%s&", t->print_full());
      t->is_pointer++;
    } else {
      fprintf(f,"%s", t->print_full());
    }
    
    fprintf(f,"%s(", decl);
    L->print_types(f);
    fprintf(f,");\n");
    break;
  case 1:
    // Normal C/C++ extern
//    fprintf(f,"#line %d \"%s\"\n", line_number, input_file);
    if (t->is_reference) {
      t->is_pointer--;
      fprintf(f,"extern %s&", t->print_full());
      t->is_pointer++;
    } else {
      fprintf(f,"extern %s", t->print_full());
    }
    fprintf(f,"%s(", decl);
    L->print_types(f);
    fprintf(f,");\n");
    break;
  case 2:
    // A C++ --- > C Extern
//    fprintf(f,"#line %d \"%s\"\n", line_number, input_file);
    if (t->is_reference) {
      t->is_pointer--;
      fprintf(f,"extern \"C\" %s&", t->print_full());
      t->is_pointer++;
    } else {
      fprintf(f,"extern \"C\" %s", t->print_full());
    }
    fprintf(f,"%s(", decl);
    L->print_types(f);
    fprintf(f,");\n");
    break;
  default:
    break;
  }
}  

// -------------------------------------------------------------------
// char *emit_local(int i)
//
// Emit the name of local variable for parameter i
// -------------------------------------------------------------------

char *emit_local(int i) {
  static char arg[64];

  sprintf(arg,"_arg%d", i);
  return arg;
}
  
// -------------------------------------------------------------------
// int emit_args(char *d, DataType *rt, ParmList *l, FILE *f)
//
// Creates a list of variable declarations for both the return value
// and function parameters.
//
// The return value is always called _result and arguments label as
// _arg0, _arg1, _arg2, etc...
//
// Returns the number of parameters associated with a function.
// ------------------------------------------------------------------

int emit_args(DataType *rt, ParmList *l, FILE *f) {

  Parm *p;
  int   i;

  // Declare the return variable

  if ((rt->type != T_VOID) || (rt->is_pointer)) {
    if ((rt->type == T_USER) && (!rt->is_pointer)) {

      // Special case for return by "value"

      rt->is_pointer++;
      fprintf(f,"\t %s _result;\n", rt->print_full());
      rt->is_pointer--;
    } else {

      // Normal return value

      fprintf(f,"\t %s _result;\n", rt->print_full());
    }
  }

  // Emit function arguments

  i = 0;
  p = l->get_first();
  while (p != 0) {
    if ((p->t->type != T_VOID) || (p->t->is_pointer))  {
      fprintf(f,"\t %s _arg%d;\n", p->t->print_type(),i);
      i++;
    }
    p = l->get_next();
  }
  
  // i now contains number of parameters
  
  return(i);

 }

// -------------------------------------------------------------------
// int emit_args(char *d, DataType *rt, ParmList *l, WrapperFunction &f)
//
// Creates a list of variable declarations for both the return value
// and function parameters.
//
// The return value is always called _result and arguments label as
// _arg0, _arg1, _arg2, etc...
//
// Returns the number of parameters associated with a function.
//
// ** New version taking WrapperFunction argument **
// ------------------------------------------------------------------

int emit_args(DataType *rt, ParmList *l, WrapperFunction &f) {

  Parm *p;
  int   i;
  
  // Declare the return variable

  if ((rt->type != T_VOID) || (rt->is_pointer)) {
    if ((rt->type == T_USER) && (!rt->is_pointer)) {

      // Special case for return by "value"
      rt->is_pointer++;
      f.add_local(rt->print_full(), "_result");
      rt->is_pointer--;
    } else {

      // Normal return value

      f.add_local(rt->print_full(), "_result");
    }
  }

  // Emit function arguments

  i = 0;
  p = l->get_first();
  while (p != 0) {
    if ((p->t->type != T_VOID) || (p->t->is_pointer))  {
      f.add_local(p->t->print_type(), emit_local(i));
      i++;
    }
    p = l->get_next();
  }

  // i now contains number of parameters
  
  return(i);
}

// --------------------------------------------------------------
// emit_func_call(char *decl, DataType *t, ParmList *l, FILE *f)
//
// Emits code for a function call.
// Now modified to work properly with C++ references.
// --------------------------------------------------------------

void emit_func_call(char *decl, DataType *t, ParmList *l, FILE *f) {

  int  i;
  Parm  *p;

//  fprintf(f,"#line %d \"%s\"\n", line_number, input_file);
  fprintf(f,"\t ");

  // First check if there is a return value

  if ((t->type != T_VOID) || (t->is_pointer)) {
    if ((t->type == T_USER) && (!t->is_pointer)) {

      // Special case for return by "value"
      // Caution : This *will* cause a memory leak if not
      // used properly.

      if (CPlusPlus) {
	fprintf(f,"_result = new %s;\n", t->print_type());
	fprintf(f,"\t*(_result) = ");
      } else {
	t->is_pointer++;
	fprintf(f,"_result = %s malloc(sizeof(", t->print_cast());
	t->is_pointer--;
	fprintf(f,"%s));\n", t->print_type());
	fprintf(f,"\t*(_result) = ");
      }
    } else {

      // Check if this is a C++ reference
      if (t->is_reference) {
	t->is_pointer--;
	fprintf(f,"%s& _result_ref = ", t->print_full());
	t->is_pointer++;
      } else {
	
      // Normal return values
	fprintf(f,"_result = ");
      }
    }
  }

  // Now print out function call

  fprintf(f,"%s(",decl);

  i = 0;
  p = l->get_first();
  while(p != 0) {
    if ((p->t->type != T_VOID) || (p->t->is_pointer)){
      if ((!p->t->is_reference) && (p->call_type & CALL_VALUE)) fprintf(f,"&");
      if ((!(p->call_type & CALL_VALUE)) &&
	  ((p->t->is_reference) || (p->call_type & CALL_REFERENCE)))
	fprintf(f,"*");
      fprintf(f,"_arg%d",i);
      i++;
    }
    p = l->get_next();
    if (p != 0)
      fprintf(f,",");
  }

  fprintf(f,");\n");
  if (t->is_reference) {
    fprintf(f,"\t _result = &_result_ref;\n");
  }
}


// --------------------------------------------------------------
// emit_func_call(char *decl, DataType *t, ParmList *l, WrapperFunction &f)
//
// Emits code for a function call (new version).
// --------------------------------------------------------------

void emit_func_call(char *decl, DataType *t, ParmList *l, WrapperFunction &f) {

  int  i;
  Parm  *p;

//  f.code << "#line " << line_number << " \"" << input_file << "\"\n";
  f.code << tab4;

  // First check if there is a return value

  if ((t->type != T_VOID) || (t->is_pointer)) {
    if ((t->type == T_USER) && (!t->is_pointer)) {

      // Special case for return by "value"
      // Caution : This *will* cause a memory leak if not
      // used properly.

      if (CPlusPlus) {
	f.code << "_result = new " << t->print_type() << ";\n";
	f.code << tab4 << "*(_result) = ";
      } else {
	t->is_pointer++;
	f.code << "_result = " << t->print_cast() << " malloc(sizeof(";
	t->is_pointer--;
	f.code << t->print_type() << "));\n";
	f.code << tab4 << "*(_result) = ";
      }
    } else {
      // Check if this is a C++ reference
      if (t->is_reference) {
	t->is_pointer--;
	f.code << t->print_full() << "& _result_ref = ";
	t->is_pointer++;
      } else {

	// Normal return value
	f.code << "_result = ";
      }
    }
  }

  // Now print out function call

  f.code << decl << "(";

  i = 0;
  p = l->get_first();
  while(p != 0) {
    if ((p->t->type != T_VOID) || (p->t->is_pointer)){
      if ((!p->t->is_reference) && (p->call_type & CALL_VALUE))
	f.code << "&";
      if ((!(p->call_type & CALL_VALUE)) &&
	  ((p->t->is_reference) || (p->call_type & CALL_REFERENCE)))
	f.code << "*";
      f.code << emit_local(i);
      i++;
    }
    p = l->get_next();
    if (p != 0)
      f.code << ",";
  }
  f.code << ");\n";
  if (t->is_reference) {
    f.code << tab4 << "_result = &_result_ref;\n";
  }
}

// ------------------------------------------------------------
// emit_hex()
//
// Emits the C-code to convert hexadecimal strings
// ------------------------------------------------------------

static char *hex_code = 
"/* swigptr.swg\n\
 *\n\
 * This file contains two functions :\n\
 *\n\
 *       void  _swig_make_hex(char *_c, void *_ptr, char *type)\n\
 *       char *_swig_get_hex(char *_c, void **ptr, char *type)\n\
 *\n\
 * These are used to convert pointers to and from pointer strings\n\
 * and to perform type checking.\n\
 *\n\
 * You can remap these functions by making a file called \"swigptr.swg\" in\n\
 * your the same directory as the interface file you are wrapping.\n\
 *\n\
 * IMPORTANT !!! the function _swig_get_hex returns a non-null char pointer\n\
 * in the event of a type error (this is used to generate an error message).\n\
 * If a type is successfully parsed, a NULL pointer is returned.\n\
 *\n\
 * Revision 1.3  1996/07/17 15:26:08  dmb\n\
 * Made a minor bug fix so pointers of form _0_Type could be used\n\
 * (as described in the manual).   Disable by compiling with -DNO_ZERO.\n\
 *\n\
 * Revision 1.2  1996/06/10 23:42:10  beazley\n\
 * Added const qualifier.\n\
 *\n\
 * Revision 1.1  1996/05/22  17:17:47  beazley\n\
 * Initial revision\n\
 *\n\
 */\n\
\n\
static void \n\
_swig_make_hex (char *_c, const void *_ptr, char *type)\n\
{\n\
  static char _hex[16] =\n\
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\
   'a', 'b', 'c', 'd', 'e', 'f'};\n\
  unsigned long _p, _s;\n\
  char _result[128], *_r;\n\
  _r = _result;\n\
  _p = (unsigned long) _ptr;\n\
  if (_p > 0)\n\
    {\n\
      while (_p > 0)\n\
	{\n\
	  _s = _p & 0xf;\n\
	  *(_r++) = _hex[_s];\n\
	  _p = _p >> 4;\n\
	}\n\
      *_r = '_';\n\
      while (_r >= _result)\n\
	*(_c++) = *(_r--);\n\
    }\n\
  else\n\
    {\n\
      strcpy (_c, \"NULL\");\n\
    }\n\
  if (_ptr)\n\
    strcpy (_c, type);\n\
}\n\
\n\
/* A forward reference; */\n\
\n\
static char ***swig_ptr_derived = 0;\n\
\n\
static char *\n\
_swig_get_hex (char *_c, void **ptr, char *_t)\n\
{\n\
  unsigned long _p;\n\
  char temp_type[256];\n\
  char *_tt;\n\
  char **eq;\n\
  int i, j, n;\n\
  _p = 0;\n\
  if (*_c == '_')\n\
    {\n\
      _c++;\n\
      while (*_c)\n\
	{\n\
	  if ((*_c >= '0') && (*_c <= '9'))\n\
	    _p = (_p << 4) + (*_c - '0');\n\
	  else if ((*_c >= 'a') && (*_c <= 'f'))\n\
	    _p = (_p << 4) + ((*_c - 'a') + 10);\n\
	  else\n\
	    break;\n\
	  _c++;\n\
	}\n\
#ifdef NO_ZERO\n\
      if (_p == 0)\n\
	{\n\
	  return (char *) _c;\n\
	}\n\
#endif\n\
      _tt = _c;\n\
      if (_t)\n\
	{\n\
	  if (strcmp (_c, _t))\n\
	    {\n\
	      /* Have a type mismatch, we're going to have to do some\n\
	         searching here */\n\
	      i = 0;\n\
	      if (swig_ptr_derived)\n\
		{\n\
		  while (swig_ptr_derived[i])\n\
		    {\n\
		      eq = swig_ptr_derived[i];\n\
		      /* Check type */\n\
		      if (strncmp (_t, eq[0], strlen (eq[0])) == 0)\n\
			{\n\
			  /* Found derived type list for this. */\n\
			  n = strlen (eq[0]);\n\
			  j = 1;\n\
			  while (eq[j])\n\
			    {\n\
			      sprintf (temp_type, \"%s%s\", eq[j], _t + n);\n\
			      if (strcmp (_c, temp_type) == 0)\n\
				{\n\
				  *ptr = (void *) _p;\n\
				  return (char *) 0;\n\
				}\n\
			      j++;\n\
			    }\n\
			}\n\
		      i++;\n\
		    }\n\
		}\n\
	      return _tt;\n\
	    }\n\
	  else\n\
	    {\n\
	      *ptr = (void *) _p;\n\
	      return (char *) 0;\n\
	    }\n\
	}\n\
      else\n\
	{\n\
	  *ptr = (void *) _p;\n\
	  return (char *) 0;\n\
	}\n\
    }\n\
  else\n\
    {\n\
#ifdef ALLOW_NULL\n\
      if (strcmp (_c, \"NULL\") == 0)\n\
	{\n\
	  *ptr = (void *) 0;\n\
	  return (char *) 0;\n\
	}\n\
#endif\n\
      *ptr = (void *) 0;\n\
      return _c;\n\
    }\n\
}\n";

void emit_hex(FILE *f) {
  
  int stat;

  // This is a hard-coded version of the swigptr.swg file (just in case
  // the configuration file is gone).
  // Use the "munge" script to turn a configuration file into a
  // pointer like this.


   // Look for a pointer configuration file

   stat = IncludeFile("swigptr.swg", f);

   if (stat == -1) 
       fputs(hex_code,f);

}

// ------------------------------------------------------------------------
// void emit_set_get(char *name, char *iname, DataType *type)
//
// Emits a pair of functions to set/get the value of a variable.
// This should be used as backup in case the target language can't
// provide variable linking.
// 
// double foo;
//
// Gets translated into the following :
//
// double foo_set(double x) {
//      return foo = x;
// }
//
// double foo_get() {
//      return foo;
// }
//
// Need to handle special cases for char * and for user
// defined types. 
//
// 1.  char *
//
//     Will free previous contents (if any) and allocate
//     new storage.   Could be risky, but it's a reasonably
//     natural thing to do.
//
// 2.  User_Defined
//     Will assign value from a pointer. 
//     Will return a pointer to current value.
//
// --------------------------------------------------------------------

void emit_set_get(char *name, char *iname, DataType *t) {

    Parm *p;
    ParmList *l;
    char   new_name[512];
    char   new_iname[512];
    char   wname[256];

    // First write a function to set the variable of the
    // Variable
    strcpy(wname, name);
    make_wrap_name(wname);

    if (!(Status & STAT_READONLY)) {
      if ((t->type == T_USER) && (!t->is_pointer)) {
	t->is_pointer++;
	fprintf(f_header,"static %s %s_set(%s val) {\n",
		t->print_type(), wname, t->print_type());
	t->is_pointer--;
      } else {
	fprintf(f_header,"static %s %s_set(%s val) {\n",
		t->print_type(), wname, t->print_type());
      }
      
      if ((t->type != T_VOID) || (t->is_pointer)) {
	if (!t->is_pointer) {
	  
	  // Have a real value here 
	  // If it's a user defined type, we'll do something special.
	  // Otherwise, just assign it.
	  
	  if (t->type != T_USER) {
	    fprintf(f_header,"\t return (%s = val);\n", name);
	  } else {
	    fprintf(f_header,"\t %s = *(val);\n", name);
	    fprintf(f_header,"\t return &%s;\n", name);
	  }
	} else {
	  
	  // Is a pointer type here.  If string, we do something
	  // special.  Otherwise. No problem.
	  
	  if ((t->type == T_CHAR) && (t->is_pointer == 1)) {
	    if (CPlusPlus) {
	      fprintf(f_header,"\t if (%s) delete %s;\n", name,name);
	      fprintf(f_header,"\t %s = new char[strlen(val)+1];\n",name);
	      fprintf(f_header,"\t strcpy(%s,val);\n", name);
	      fprintf(f_header,"\t return %s;\n", name);
	    } else {
	      fprintf(f_header,"\t if (%s) free(%s);\n", name,name);
	      fprintf(f_header,"\t %s = (char *) malloc(strlen(val)+1);\n",name);
	      fprintf(f_header,"\t strcpy(%s,val);\n", name);
	      fprintf(f_header,"\t return %s;\n", name);
	    }
	  } else {
	    fprintf(f_header,"\t return (%s = val);\n", name);
	  }
	}
      }

      fprintf(f_header,"}\n");

      // Now wrap it.

      l = new ParmList;
      p = new Parm;
      p->t = new DataType;
      p->t->type = t->type;
      p->t->is_pointer = t->is_pointer;
      p->call_type = 0;	
      if ((t->type == T_USER) && (!t->is_pointer)) p->t->is_pointer++;
      p->t->implicit_ptr = t->implicit_ptr;
      strcpy(p->t->name, t->name);
      if (t->qualifier) {
	p->t->qualifier = new char[strlen(t->qualifier)+1];
	strcpy(p->t->qualifier,t->qualifier);
      }
      p->name = "";
      l->add_param(p);
      
      sprintf(new_name,"%s_set", wname);
      sprintf(new_iname,"%s_set", iname);
      
      if ((t->type == T_USER) && (!t->is_pointer)) {
	t->is_pointer++;
	lang->create_function(new_name, new_iname, t, l);
	t->is_pointer--;
      } else {
	lang->create_function(new_name, new_iname, t, l);
      }
      
      delete l;
    }

    // Now write a function to get the value of the variable

    if ((t->type == T_USER) && (!t->is_pointer)) {
      t->is_pointer++;
      fprintf(f_header,"static %s %s_get() { \n",
	      t->print_type(), wname);
      fprintf(f_header,"\t return &%s;\n", name);
      t->is_pointer--;
    } else {
      fprintf(f_header,"static %s %s_get() { \n",
	      t->print_type(), wname);
      fprintf(f_header,"\t return %s;\n", name);
    }

    fprintf(f_header,"}\n");
    
    // Wrap this function

    l = new ParmList;

    sprintf(new_name,"%s_get", wname);
    sprintf(new_iname,"%s_get", iname);

    if ((t->type == T_USER) && (!t->is_pointer)) {
      t->is_pointer++;
      lang->create_function(new_name, new_iname, t, l);
      t->is_pointer--;
    } else {
      lang->create_function(new_name, new_iname, t, l);
    }

    delete l;

}

#undef EMIT
	 
  



