
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/

#include "internal.h"

/* ------------------------------------------------------------------------
   getopt.cxx

   This file defines a few functions for handling command line arguments.
   C++ makes this really funky---especially since each language module
   may want to extract it's own command line arguments.

   We'll put the arguments into an internally maintained list.

   My own special version of getopt.   This is a bit weird, because we
   don't know what the options are in advance (they could be determined
   by a language module).
   ------------------------------------------------------------------------ */
static char **args;
static int    numargs;
static int   *marked;

/* ------------------------------------------------------------------------
   Initializes the argument list 

   ------------------------------------------------------------------------ */

void
init_args(int argc, char **argv)
{
  int i;
  numargs = argc;
  args = argv;
  marked = new int[numargs];
  for (i = 0; i < argc; i++) {
    marked[i] = 0;
  }
  marked[0] = 1;
}

/* -------------------------------------------------------------------------
   void mark_arg(int n)

   Marks argument n in the argument list
   ------------------------------------------------------------------------- */

void
mark_arg(int n) {
  if (marked)
    marked[n] = 1;
}

// -----------------------------------------------------------------
// void check_options();
//
// Checks to see if there are any command line options remaining.
// If so.  Issues an error and exits
// -----------------------------------------------------------------
 
void check_options() {
 
    int error = 0;
    int i;

    if (!marked) {
      fprintf(stderr,"Must specify an input file.  Use -help for available options.\n");
      exit(1);
    }
    for (i = 1; i < numargs-1; i++) {
        if (!marked[i]) {
            fprintf(stderr,"swig error : Unrecognized option %s\n", args[i]);
            error=1;
        }
    }
 
    if (error) {
        fprintf(stderr,"Use 'swig -help' for available options.\n");
        exit(1);
    }

    if (marked[numargs-1]) {
      fprintf(stderr,"Must specify an input file. Use -help for available options.\n");
      exit(1);
    }
}
 
// -------------------------------------------------------------------
// void arg_error()
//
// Print a generic error message.
// --------------------------------------------------------------------

void arg_error() {
  fprintf(stderr,"SWIG : Unable to parse command line options.\n");
  fprintf(stderr,"Use 'swig -help' for available options.\n");
  exit(1);
}

  
  


	
		
