
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/html.cxx,v 1.9 1996/08/27 22:59:02 dmb Exp $
 *
 * HTML.c
 *
 * HTML specific functions for producing documentation.
 *
 * -- Revision History
 * $Log: html.cxx,v $
 * Revision 1.9  1996/08/27 22:59:02  dmb
 * Minor changes to error handling
 *
 * Revision 1.8  1996/08/21 05:47:45  dmb
 * Cleaned up output slightly
 *
 * Revision 1.7  1996/05/22 20:20:21  beazley
 * Fixed bug in usage variable.
 *
// Revision 1.6  1996/05/10  23:37:54  beazley
// Cleaned up output a little bit
//
// Revision 1.5  1996/03/16  06:26:14  beazley
// Changed to work with new headers.
//
// Revision 1.4  1996/02/20  04:16:04  beazley
// Took out streams.
//
// Revision 1.3  1996/02/16  06:38:49  beazley
// Removed a few unused variables.
//
// Revision 1.2  1996/02/15  22:37:45  beazley
// Changed copyright
//
// Revision 1.1  1996/02/07  05:25:06  beazley
// Initial revision
//
 *
 ***********************************************************************/

#include "swig.h"
#include "html.h"

// -------------------------------------------------------------------
// print_string(char *)
//
// Prints a string to the document file, but does some HTML character
// replacements.
// -------------------------------------------------------------------

void HTML::print_string(char *s) { 

  char *c;
  int lbreak = 0;
  c = s;
  while (*c) {
    switch(*c) {
    case '\n':
    case '\\':
      if (lbreak) {
	fprintf(f_doc,"<BR>");
	lbreak = 0;
      } else {
	if ((*c) == '\n') {
	  fputc(' ',f_doc);
	}
	lbreak++;
      }
      break;
/*
    case '\"':
      fprintf(f_doc,"&quot");
      break;
*/

    case '&':
      fprintf(f_doc,"&amp");
      lbreak =0;
      break;
/*
    case '<':
      fprintf(f_doc,"&lt");
      break;
    case '>':
      fprintf(f_doc,"&gt");
      break;
*/

    default :
      fputc(*c,f_doc);
      lbreak =0;
      
      break;
    }
    c++;
  }
}

// -------------------------------------------------------------------
// print_anchor(char *)
//
// Prints an anchor to the html file.  Basically just strips out some
// white space.
// -------------------------------------------------------------------

void HTML::print_anchor(char *s) { 

  char *c;

  c = s;
  while (*c) {
    switch(*c) {
    case ' ':
    case '\t':
      fputc('_',f_doc);
      break;
    default :
      fputc(*c,f_doc);
      break;
    }
    c++;
  }
}

// --------------------------------------------------------------
// print_entry(DocEntry *)
//
// Print a documentation entry
// --------------------------------------------------------------

void HTML::print_entry(DocEntry *de) { 

  if (!de->usage) return;

  if (de->type != D_TEXT)
    fprintf(f_doc,"<B> <TT>");
  print_string(de->usage);
  if (de->type != D_TEXT)
    fprintf(f_doc,"</TT> </B> <BR>\n");
  else fprintf(f_doc,"<BR>\n");

  if (de->descrip != 0) {
    fprintf(f_doc,"<BLOCKQUOTE>\n");
    fprintf(f_doc,"%s\n",de->descrip);
    fprintf(f_doc,"</BLOCKQUOTE>\n");
  } else {
      fprintf(f_doc,"<BR>\n");
  }
}

void HTML::print_title(char *f) { 
  extern char *get_time();


  fprintf(f_doc,"<HEAD>\n");
  fprintf(f_doc,"<TITLE>\n");
  print_string(f);
  fprintf(f_doc,"</TITLE>\n");
  fprintf(f_doc,"<BODY>\n");
  fprintf(f_doc,"<H1>");
  print_string(f);
  fprintf(f_doc,"</H1>");
  fprintf(f_doc,"</H3>");
  fprintf(f_doc,"<BR>\nCreated : ");
  print_string(get_time());
  fprintf(f_doc,"<BR>\n");
  fprintf(f_doc,"</H3>");
  fprintf(f_doc,"<HR>");

}

// -----------------------------------------------------------------------
// Print a table of contents
//
//------------------------------------------------------------------------

void HTML::print_contents() {

  DocEntry  **list;
  char      *category;
  int       i;

  fprintf(f_doc,"\n<H2> Table of Contents </H2>\n");
  fprintf(f_doc,"<UL>\n");

  list = sort_doc();    // Sort it all out

  // Print category title 

  i = 0;
  while (list[i] != 0) {
      category = list[i]->category;
      fprintf(f_doc,"<LI> <A HREF=\"#");
      print_anchor(category);
      fprintf(f_doc,"\"> %s </A>\n", category);

      // Count up how many of each time we have

      while ((list[i] != 0) && (strcmp(list[i]->category,category) == 0)) {
	i++;
      }
  }
  fprintf(f_doc,"</UL>\n");
  contents_printed = 1;

}

// ------------------------------------------------------------
// Print a category heading
// ------------------------------------------------------------

void HTML::print_category(char *category) {
  if (!contents_printed) print_contents();
  fprintf(f_doc,"<HR>\n");
  fprintf(f_doc,"<H2><A NAME=\"");
  print_anchor(category);
  fprintf(f_doc,"\">%s</A></H2>\n\n", category);
}

// -------------------------------------------------------------
// Print a subcategory heading
// -------------------------------------------------------------

void HTML::print_subcategory(char *category) {
  if (!contents_printed) print_contents();
  fprintf(f_doc,"<H3>%s</H3>\n\n",category);
 }

// -------------------------------------------------------------
// Initialize HTML
// -------------------------------------------------------------

void HTML::init(char *filename) {
  char f[256];

  contents_printed = 0;

  sprintf(f,"%s_wrap.html",filename);
  sprintf(fn,"%s",filename);
  f_doc = fopen(f,"w");
  if (f_doc == NULL) {
    fprintf(stderr,"Unable to open %s\n",fn);
    SWIG_exit(1);
  }

  /* Print a HTML banner */

  fprintf(f_doc,"<HTML>\n");

}

void HTML::close(void) {

  fprintf(f_doc,"</BODY>\n");
  fprintf(f_doc,"</HTML>\n");
  fclose(f_doc);
  if (Verbose) 
    fprintf(stderr,"Documentation written to %s_wrap.html\n", fn);

}
      



    
    
  






  
  
