
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/include.cxx,v 1.12 1996/08/21 16:48:40 dmb Exp $
 *
 * include.cc
 *
 * Code for including files into a wrapper file.
 *
 * -- Revision History
 * $Log: include.cxx,v $
 * Revision 1.12  1996/08/21 16:48:40  dmb
 * Minor cleanup to eliminate compiler warnings.
 *
 * Revision 1.11  1996/08/21 05:47:54  dmb
 * Cleanup up output slightly
 *
 * Revision 1.10  1996/08/15 05:04:42  dmb
 * Modified to do some suffix checking.
 *
 * Revision 1.9  1996/05/22 20:20:21  beazley
 * Minor changes
 *
// Revision 1.8  1996/05/03  22:28:17  dmb
// Added IncludeFile subroutine.  Will be used to load general configuration files.
//
 * Revision 1.7  1996/04/14 15:23:44  dmb
 * Fixed header files.
 *
 * Revision 1.6  1996/03/24 22:14:25  beazley
 * Added swig_append() function to replace some "system" calls.
 *
// Revision 1.5  1996/03/22  23:40:19  beazley
// Took out old %include directive.  Replaced with a new and
// improved version.
//
// Revision 1.4  1996/03/16  06:27:42  beazley
// Changed to use new headers.
//
// Revision 1.3  1996/02/20  04:06:46  beazley
// Took out streams stuff.
//
// Revision 1.2  1996/02/15  22:38:04  beazley
// Changed copyright
//
// Revision 1.1  1996/02/12  08:19:16  beazley
// Initial revision
//
 *
 ***********************************************************************/

#include "internal.h"
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
//#include <fcntl.h>

/* Linked list containing search directories */

struct   Dnode {
  char    *dirname;
  Dnode   *next;
};

Dnode   ihead, iz;
int     include_init = 0;

/* Linked list containing included files */

struct  Inode {
  char    *name;
  Inode   *next;
};

Inode  *include_list = 0;

//-----------------------------------------------------------------
// void Add_directory(char *dirname)
// 
// Adds a directory to the search path.
//-----------------------------------------------------------------

void Add_directory(char *dirname) {
  Dnode  *d;

  if (!include_init) {
    ihead.next = &iz;
    iz.next = &iz;
    iz.dirname = new char[2];
    iz.dirname[0] = 0;
    include_init = 1;
  }

  d = new Dnode;
  d->dirname = new char[strlen(dirname)+1];
  strcpy(d->dirname,dirname);
  d->next = ihead.next;
  ihead.next = d;

}

// ----------------------------------------------------------------
// int Add_iname(char *name)
//
// Adds include name to a linked list.   If the name is already in
// The list, returns 1, if not in the list, returns 0
// ----------------------------------------------------------------

int Add_iname(char *name) {

  Inode *newi, *i;

  if (include_list) {
    /* Search list */
    i = include_list;
    while (i) {
      if (strcmp(i->name, name) == 0) return 1;
      i = i->next;
    }
  }

  newi = new Inode;
  newi->name = new char[strlen(name)+1];
  strcpy(newi->name, name);
  newi->next = include_list;
  include_list = newi;
  return 0;
}

// --------------------------------------------------------------------
// Check_Suffix(char *name)
//
// Checks the suffix of an include file to see if we need to do any
// special processing.
// --------------------------------------------------------------------

static void Check_Suffix(char *name) {
  char *c;

  if (!name) return;
  if (strlen(name) == 0) return;
  c = name+strlen(name)-1;
  while (c != name) {
    if (*c == '.') break;
    c--;
  }
  if (c == name) return;

  /* Check suffixes */

  if (strcmp(c,".c") == 0) {
    ForceExtern = 1;
  } else if (strcmp(c,".C") == 0) {
    ForceExtern = 1;
  } else if (strcmp(c,".cc") == 0) {
    ForceExtern = 1;
  } else if (strcmp(c,".cxx") == 0) {
    ForceExtern = 1;
  } else if (strcmp(c,".c++") == 0) {
    ForceExtern = 1;
  } else if (strcmp(c,".cc") == 0) {
    ForceExtern = 1;
  }
}
  
// --------------------------------------------------------------------
// Include(char *name)
//
// Includes a new SWIG wrapper file.
// --------------------------------------------------------------------

void Include(char *name) {

  FILE  *f;
  char   filename[256];
  int    found = 0;
  Dnode  *d;
  extern void scanner_file(FILE *);

  if (!include_init) return;    // Not initialized yet
  if (Add_iname(name)) {
    if (Verbose) fprintf(stderr,"file %s already included.\n", name);
    return;  // Already included this file
  }


  if (Verbose) {
    fprintf(stderr,"Wrapping %s...\n", name);	
    fprintf(stderr,"Looking for ./%s\n", name);
  }

  if ((f = fopen(name,"r")) != NULL) {
    input_file = new char[strlen(name)+1];
    strcpy(input_file,name);
    scanner_file(f);
    Check_Suffix(name);
    return;
  }

  // Now start searching libraries

  d = ihead.next;               // Start of search list
  while (d != &iz) {
    // Look for the wrap file in language directory
    sprintf(filename,"%s/%s/%s", d->dirname,LibDir,name);
    if (Verbose) fprintf(stderr,"Looking for %s\n", filename);
    if((f = fopen(filename,"r")) != NULL) {
      found = 1;
    } else {
      sprintf(filename,"%s/%s", d->dirname, name);
      if (Verbose) fprintf(stderr,"Looking for %s\n", filename);
      if ((f = fopen(filename,"r")) != NULL) {
	found = 1;
      }
    }
    if (found) {
      // Found it, open it up for input
      input_file = new char[strlen(filename)+1];
      strcpy(input_file,filename);
      scanner_file(f);
      Check_Suffix(name);
      return;
    }
    d = d->next;
  }

  if (!found) fprintf(stderr,"%s : Line %d. Unable to find include file %s (ignored).\n",input_file, line_number, name);

}

static char  buffer[1024];

// --------------------------------------------------------------------
// copy_data(FILE *f1, FILE *f2)
//
// --------------------------------------------------------------------

void copy_data(FILE *f1, FILE *f2) {

  while (fgets(buffer,1023,f1)) {
    fputs(buffer, f2);
  }
  fclose(f1);
}

// --------------------------------------------------------------------
// int IncludeFile(char *name, FILE *f)
//
// Looks for a text file and and appends it to f.  Return -1 on failure.
// --------------------------------------------------------------------

int IncludeFile(char *name, FILE *f_out) {

  FILE  *f;
  char   filename[256];
  int    found = 0;
  Dnode  *d;

  if (!include_init) return -1;    // Not initialized yet
  if (Add_iname(name)) {
    if (Verbose) fprintf(stderr,"file %s already included.\n", name);
    return -1;  // Already included this file
  }

  if (Verbose) fprintf(stderr,"Looking for ./%s\n", name);
  if ((f = fopen(name,"r")) != NULL) {
      copy_data(f,f_out);
      return 0;
  }

  // Now start searching libraries

  d = ihead.next;               // Start of search list
  while (d != &iz) {
    // Look for the wrap file in language directory
    sprintf(filename,"%s/%s/%s", d->dirname,LibDir,name);
    if (Verbose) fprintf(stderr,"Looking for %s\n", filename);
    if((f = fopen(filename,"r")) != NULL) {
      found = 1;
    } else {
      sprintf(filename,"%s/%s", d->dirname, name);
      if (Verbose) fprintf(stderr,"Looking for %s\n", filename);
      if ((f = fopen(filename,"r")) != NULL) {
	found = 1;
      }
    }
    if (found) {
	copy_data(f,f_out);
	return 0;
    }
    d = d->next;
  }

  if ((!found) && (Verbose)) fprintf(stderr,"unable to find %s. (Ignored)\n",name);
  return -1;
}

// ---------------------------------------------------------------------
// swig_append(char *filename, FILE *f)
//
// This copies the contents of filename to the stream f.
// ---------------------------------------------------------------------

void swig_append(char *filename, FILE *f) {

  FILE *in_file;

  if ((in_file = fopen(filename,"r")) == NULL) {
      fprintf(stderr,"** SWIG ERROR ** file %s not found.\n",filename);
      return;
  }
  while (fgets(buffer,1023,in_file)) {
    fputs(buffer, f);
  }
  fclose(in_file);
}


