
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/internal.h,v 1.11 1996/08/15 05:05:50 dmb Exp $
 *
 * internals.h
 *
 * Contains global variables used in libswig, but which are otherwise
 * inaccessible to the user.
 *
 * -- Revision History
 * $Log: internal.h,v $
 * Revision 1.11  1996/08/15 05:05:50  dmb
 * Added some more internal variables
 *
 * Revision 1.10  1996/08/12 01:53:06  dmb
 * Changes to language class structure
 *
 * Revision 1.9  1996/05/17 05:51:40  beazley
 * *** empty log message ***
 *
 * Revision 1.8  1996/05/13  23:47:20  beazley
 * A few minor changes
 *
 * Revision 1.7  1996/05/10  23:39:12  beazley
 * Removed a few obsolete variables
 *
 * Revision 1.6  1996/05/03  05:11:59  dmb
 * Added CPlusPlus flag
 *
 * Revision 1.5  1996/04/08 19:44:50  beazley
 * Added stats variables.
 *
 * Revision 1.4  1996/04/03  22:49:11  beazley
 * Added IgnoreComments variable.
 *
 * Revision 1.3  1996/03/24  22:15:23  beazley
 * Added declaration of swig_append().
 *
 * Revision 1.2  1996/03/22  23:43:12  beazley
 * Cleaned this up.
 *
 * Revision 1.1  1996/03/16  06:30:22  beazley
 * Initial revision
 *
 *
 ***********************************************************************/

#include "swig.h"

extern    void          Include(char *);         // Insert library file
extern    char          category[256];
extern    char          title[256];
extern    DocEntry      *doc_entry;
extern    Language      *lang;
extern    Documentation *doc;
extern    void          swig_append(char *, FILE *);
extern    int           Stat_func, Stat_var, Stat_const;
extern    int           IgnoreDoc;
extern    int           ForceExtern;
/* Global variables.   Needs to be cleaned up */

#ifdef WRAP

    FILE      *f_header;                        // Some commonly used
    FILE      *f_wrappers;                      // FILE pointers
    FILE      *f_init;
    FILE      *f_input;
    char      InitName[256];             
    char      LibDir[512];                      // Library directory
    int       IgnoreComments = 0;               // Flag to ignore comments.
    char     **InitNames = 0;
    int       Status; 
    int       TypeStrict;                       // Type checking strictness
    int       Verbose;
    char       category[256];                   // Variables for documentation
    char       title[256];
    DocEntry  *doc_entry = 0;                   // Current documentation entry
    Language  *lang;                            // Language method
    Documentation  *doc;                        // Documentation method
    int        Stat_func = 0;
    int        Stat_var = 0;
    int        Stat_const = 0;
    int        CPlusPlus = 0;
    int        Dirty = 0;
    int        Stats = 0;
    int        IgnoreDoc = 0;                   // Ignore documentation mode
    int        ForceExtern = 0;                // Force extern mode
#endif

/* Number of initialization names that can be used */

#define NI_NAMES    128




