
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/latex.cxx,v 1.7 1996/08/27 22:59:17 dmb Exp $
 *
 * latex.c
 *
 * Latex specific functions for producing documentation.
 *
 * -- Revision History
 * $Log: latex.cxx,v $
 * Revision 1.7  1996/08/27 22:59:17  dmb
 * Minor changes to error handling
 *
 * Revision 1.6  1996/08/21 05:48:09  dmb
 * Cleaned up output
 *
 * Revision 1.5  1996/05/22 20:20:21  beazley
 * Fixed bug in usage variable.
 *
// Revision 1.4  1996/03/16  06:30:05  beazley
// Changed to work with new headers.
//
// Revision 1.3  1996/02/20  04:07:48  beazley
// Took out streams.
//
// Revision 1.2  1996/02/15  22:30:08  beazley
// Changed copyright notice.
//
// Revision 1.1  1996/02/07  05:24:41  beazley
// Initial revision
//
 *
 ***********************************************************************/

#include "swig.h"
#include "latex.h"

char *latex_header = "\
\\documentstyle[11pt]{article}\n\
\\setlength{\\parindent}{0.0in}\n\
\\pagestyle{headings}\n";

// -------------------------------------------------------------------
// print_string(char *)
//
// Prints a string to the document file, but does some LaTeX character
// replacements.
// -------------------------------------------------------------------

void LaTeX::print_string(char *s) { 

  char *c;

  c = s;
  while (*c) {
    switch(*c) {
    case '*':
    case '<':
    case '>':
      fprintf(f_doc,"$%c$",*c);
      break;
    case '\\':
      fprintf(f_doc,"\\\\");
      break;
    case '_':
      fprintf(f_doc,"\\_");
      break;
    case '%':
      fprintf(f_doc,"&");
      break;
    case '$':
      fprintf(f_doc,"\\$");
      break;
    case '&':
      fprintf(f_doc,"\\&");
      break;
    default :
      fputc(*c,f_doc);
      break;
    }
    c++;
  }
}

// --------------------------------------------------------------
// print_entry(DocEntry *)
//
// Print a documentation entry
// --------------------------------------------------------------

void LaTeX::print_entry(DocEntry *de) { 

  //  fprintf(f_doc,"\\index{%s}",de->name);

  if (!de->usage) return;
  fprintf(f_doc,"{\\bf \\tt ");
  print_string(de->usage);
  fprintf(f_doc,"}");
  if (de->descrip != 0) {
      fprintf(f_doc,"\n");
      fprintf(f_doc,"\\begin{itemize}\n");
      fprintf(f_doc,"\\item[] %s\n",de->descrip);
      fprintf(f_doc,"\\end{itemize}\n\n");
  } else {
      fprintf(f_doc," \\\\ \n");
  }
}

void LaTeX::print_title(char *f) { 
  extern char *get_time();
  
  fprintf(f_doc,"\\underline{\\Large \\bf ");
  print_string(f);
  fprintf(f_doc,"}\\\\\n");
  fprintf(f_doc,"{\\bf Created : ");
  print_string(get_time());
  fprintf(f_doc,"}\\\\\n\n");
}

void LaTeX::print_category(char *category) {
  fprintf(f_doc,"\\section{%s}\n\n", category);
}

void LaTeX::print_subcategory(char *category) {
  fprintf(f_doc,"\\subsection{%s}\n\n", category);
 }

void LaTeX::init(char *filename) {
  char f[256];
  sprintf(f,"%s_wrap.tex",filename);
  sprintf(fn,"%s",filename);
  f_doc = fopen(f,"w");
  if (f_doc == NULL) {
    fprintf(stderr,"Unable to open %s\n", fn);
    SWIG_exit(1);
  }

  /* Print a latex banner */

  fprintf(f_doc,"%s",latex_header);
  fprintf(f_doc,"\\begin{document}\n");
}

void LaTeX::close(void) {

  fprintf(f_doc,"\\end{document}\n");
  fclose(f_doc);
  if (Verbose)
    fprintf(stderr,"Documentation written to %s_wrap.tex\n", fn);

}
      



    
    
  






  
  
