%{

/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/parser.y,v 1.41 1996/08/27 22:59:45 dmb Exp $
 *
 * parser.y
 *
 * YACC parser for parsing function declarations.
 *
 * -- Revision History
 * $Log: parser.y,v $
 * Revision 1.41  1996/08/27 22:59:45  dmb
 * Minor change to error handling.
 *
 * Revision 1.40  1996/08/26 23:35:10  dmb
 * Added super-secret %addmethods directive.
 *
 * Revision 1.39  1996/08/25 00:03:56  dmb
 * Added %pragma directive
 *
 * Revision 1.38  1996/08/21 16:49:24  dmb
 * Minor cleanup to eliminate compiler warnings.  Minor bug fixes.
 *
 * Revision 1.37  1996/08/21 05:49:11  dmb
 * Made lots of changes to improve C++ parsing.   Fixed a few minor
 * bugs.  Added some more error checking.
 *
 * Revision 1.36  1996/08/15 05:06:00  dmb
 * More cleanup.  Add feature to emit typedefs when using %typedef.
 * Also added support for "&" when creating constants.
 *
 * Revision 1.35  1996/08/12 01:53:43  dmb
 * Major changes.  Cleanup up type-handling, added more C++ support.
 * Lot's of bug fixes (and hopefully not too many new bugs).
 *
 * Revision 1.34  1996/06/18 16:29:57  dmb
 * Fixed ALLOC definition.
 *
 * Revision 1.33  1996/06/18 15:33:27  dmb
 * Fixed external linkage of yylex and yyerror (maybe)
 *
 * Revision 1.32  1996/06/16 02:28:13  beazley
 * A few minor bug fixes with constants
 *
 * Revision 1.31  1996/06/14  19:56:28  beazley
 * Added check for C++ mode
 *
 * Revision 1.30  1996/06/02  00:16:41  beazley
 * More C++ bug fixes
 *
 * Revision 1.29  1996/05/28  23:17:48  beazley
 * Added arrays, check for pointers to functions
 *
 * Revision 1.28  1996/05/22  20:24:44  beazley
 * More cleanup.  Somewhat improved error handling.
 *
 * Revision 1.27  1996/05/20  23:37:41  beazley
 * Lot's of improvements.  Added more constant types.  Fixed bugs in C++.
 * Cleaned things up---added a few missing rules.
 *
 * Revision 1.26  1996/05/17  19:54:49  beazley
 * Changed error message
 *
 * Revision 1.25  1996/05/17  05:54:40  beazley
 * Changes too numerous to mention.  Lots of bug fixes.  More support
 * for odd syntax and header file parsing.
 *
 * Revision 1.24  1996/05/13  23:44:39  beazley
 * Substantial changes to clean things up abit.
 *
 * Revision 1.23  1996/05/10  23:39:59  beazley
 * Added some improved documentation handling.
 * Added enum and %name directives for C++.
 *
 * Revision 1.22  1996/05/09  22:34:55  beazley
 * Added structs and a little more C++
 *
 * Revision 1.21  1996/05/07  14:42:25  beazley
 * Added C++ reference (&) symbol.  SWIG interprets it quite
 * literally which may lead to confusion.  Need to think about
 * it some more.
 *
 * Revision 1.20  1996/05/06  23:10:52  beazley
 * Added even more C++ support.
 *
 * Revision 1.19  1996/05/03  22:29:51  dmb
 * Preliminary C++ support.
 *
 * Revision 1.18  1996/04/16 17:07:09  dmb
 * Fixed minor problem with free().
 *
 * Revision 1.17  1996/04/14 15:25:34  dmb
 * Fixed header files.
 *
 * Revision 1.16  1996/04/08 19:44:34  beazley
 * Added support for constant expressions and enums.
 *
 * Revision 1.15  1996/04/07  20:31:25  beazley
 * Cleaned up a few things.  Added support for enums.
 *
 * Revision 1.14  1996/04/03  22:49:43  beazley
 * Minor improvements
 *
 * Revision 1.13  1996/03/28  06:32:52  beazley
 * Oops.  Screwed up the %typedef directive, but fixed it again.
 *
 * Revision 1.12  1996/03/28  02:49:21  beazley
 * Minor changes to %typedef rule.
 *
 * Revision 1.11  1996/03/22  23:44:29  beazley
 * Major changes. Cleaned up error messages.   Improved handling
 * of constants.  Took out some obsolete directives.
 *
 * Revision 1.10  1996/03/16  06:30:59  beazley
 * Major changes.   Better error messages, does more.
 *
 * Revision 1.9  1996/03/04  21:30:38  beazley
 * Changed the way documentation is handled.
 *
 * Revision 1.8  1996/02/19  05:32:11  beazley
 * Cleaned up a few things.
 *
 * Revision 1.7  1996/02/17  23:38:14  beazley
 * Fixed problem with documentation system.
 *
 * Revision 1.6  1996/02/16  06:39:18  beazley
 * Fixed a few things related to using YACC.
 *
 * Revision 1.5  1996/02/15  22:34:42  beazley
 * Changed copyright notice.  Added %typedef directive.
 *
 * Revision 1.4  1996/02/07  05:21:34  beazley
 * Radical changes in parser.   Now allows lists of variables and functions.
 * Supports the new documentation system.
 *
 * Revision 1.3  1996/01/16  00:56:25  beazley
 * Minor changes
 *
 * Revision 1.2  1996/01/05  22:40:27  dmb
 * *** empty log message ***
 *
 * Revision 1.1  1995/12/30 04:33:51  dmb
 * Initial revision
 *
 *
 ***********************************************************************/

#define yylex yylex

extern "C" int yylex();
extern "C" void   yyerror (char *s);       
    
extern int  line_number;
extern int  start_line;
extern void skip_brace(void);
extern void skip_define(void);
extern void skip_decl(void);

#include "internal.h"

#ifdef NEED_ALLOC
void *alloca(unsigned n) {
  return((void *) malloc(n));
}
#endif

Parm          *temp;
int            i;
int            Error = 0;
char           id[1024];
char           temp_name[128];
char           temp_iname[128];
char          *tempc;
DataType       temp_type, *temp_typeptr;
char           yy_rename[256];
int            Rename_true = 0;
DataType       Active_type;             // Used to support variable lists
int            Active_extern = 0;       // Whether or not list is external
DocEntry       *prev_doc;
int            InArray = 0;
int            in_then = 0;
int            in_else = 0;
int            allow = 1;
int            doc_scope = 0;

extern void Add_TypeDef(DataType *, char *, int);
extern void Get_TypeDef(DataType *);
extern int  Add_Symbol(char *, DataType *, char *);
extern int  Update_Symbol(char *, DataType *, char *);
extern DataType *Lookup_SymType(char *);
extern char *Lookup_SymValue(char *);
extern int   Lookup_Symbol(char *);

/* Some macros for building constants */

#define E_BINARY(TARGET, SRC1, SRC2, OP)  \
        TARGET = new char[strlen(SRC1) + strlen(SRC2) +strlen(OP)+1];\
	sprintf(TARGET,"%s%s%s",SRC1,OP,SRC2);

/* Experimental C++ */

#define  CPLUS_PUBLIC    1
#define  CPLUS_PRIVATE   2
#define  CPLUS_PROTECTED 3

int     cplus_mode;

extern void set_classname(char *name, char *rname, char *ctype);
extern void cplus_member_func(char *, char *, DataType *, ParmList *, int);
extern void cplus_constructor(char *, char *, ParmList *);
extern void cplus_destructor(char *, char *);
extern void cplus_variable(char *, char *, DataType *);
extern void cplus_static_func(char *, char *, DataType *, ParmList *);
extern void cplus_declare_const(char *, char *, DataType *, char *);
extern void cplus_class_close(char *);
extern void cplus_inherit(char *);
extern void cplus_cleanup(void);
extern void cplus_static_var(char *, char *, DataType *);
extern void cplus_newmethod(int);

// ----------------------------------------------------------------------
// int promote(int t1, int t2)
//
// Promote types (for constant expressions)
// ----------------------------------------------------------------------

int promote(int t1, int t2) {

  if ((t1 == T_DOUBLE) || (t2 == T_DOUBLE)) return T_DOUBLE;
  if ((t1 == T_ULONG) || (t2 == T_ULONG)) return T_ULONG;
  if ((t1 == T_LONG) || (t2 == T_LONG)) return T_LONG;
  if ((t1 == T_UINT) || (t2 == T_UINT)) return T_UINT;
  if (t1 != t2) {
    fprintf(stderr,"%s : Line %d. Type mismatch in constant expression\n",
	    input_file, line_number);
  }
  return t1;
}

// ----------------------------------------------------------------------
// create_function(int ext, char *name, DataType *t, ParmList *l)
//
// Creates a function and manages documentation creation.  Really
// only used internally to the parser.
// ----------------------------------------------------------------------

void create_function(int ext, char *name, DataType *t, ParmList *l) {
  
  if (Rename_true) tempc = yy_rename;
  else tempc = name;

  // Check if symbol already exists

  if (Add_Symbol(tempc, t, (char *) 0)) {
    fprintf(stderr,"%s : Line %d. Function %s multiply defined (2nd definition ignored).\n",
	    input_file, line_number, tempc);
  } else {
    Stat_func++;
    if (Verbose) {
      fprintf(stderr,"Wrapping function : ");
      emit_extern_func(name, t, l, 0, stderr);
    }

    // If extern, make an extern declaration in the SWIG wrapper file

    if (ext) 
      emit_extern_func(name, t, l, ext, f_header);
    else if (ForceExtern) {
	emit_extern_func(name,t,l,1,f_header);
    }
    if (Rename_true) {
      lang->create_function(name, yy_rename, t, l);
      doc_entry = new DocEntry(category,yy_rename,t,l);
    } else {
      lang->create_function(name, name, t, l);
      doc_entry = new DocEntry(category,name,t,l);
    }
    doc->add_doc(doc_entry);
  }
  Rename_true = 0;           // Turn off the %name directive
}

// -------------------------------------------------------------------
// create_variable(int ext, char *name, DataType *t)
//
// Create a link to a global variable.
// -------------------------------------------------------------------

void create_variable(int ext, char *name, DataType *t) {

  if (Rename_true) tempc = yy_rename;
  else tempc = name;
  if (Add_Symbol(tempc, t, (char *) 0)) {
    fprintf(stderr,"%s : Line %d. Variable %s multiply defined (2nd definition ignored).\n",
	    input_file, line_number, tempc);
  } else {
    Stat_var++;
    if (Verbose) {
      fprintf(stderr,"Wrapping variable : ");
      emit_extern_var(name, t, 0, stderr);
    }

    // If externed, output an external declaration

    if (ext) 
      emit_extern_var(name, t, ext, f_header);
    else if (ForceExtern) {
      emit_extern_var(name, t, 1, f_header);
    }
    // Now dump it out
     if (Rename_true) {
      lang->link_variable(name, yy_rename, t);
      doc_entry = new DocEntry(category, yy_rename, t);
    } else {
      lang->link_variable(name, name, t);
      doc_entry = new DocEntry(category, name, t);
    }
    doc->add_doc(doc_entry);
  }
  Rename_true = 0;         // No longer applies
}

// ------------------------------------------------------------------
// create_constant(char *name, DataType *type, char *value)
//
// Creates a new constant.
// *** NOTE ***.  Assumes that a documentation entry has already
// been defined for this constant and is stored in prev_doc.  There are
// some problems associating Documentation entries with constants
// correctly so the doc_entry must be created early.
// -------------------------------------------------------------------

void create_constant(char *name, DataType *type, char *value) {

  if (Rename_true) 
    fprintf(stderr,"%s : Line %d. %%name directive ignored with #define\n",
	    input_file, line_number);

  if ((type->type == T_CHAR) && (!type->is_pointer))
    type->is_pointer++;
  
  if (!value) value = copy_string(name);
  sprintf(temp_name,"const:%s", name);
  if (Add_Symbol(temp_name, type, value)) {
    fprintf(stderr,"%s : Line %d. Constant %s multiply defined. (2nd definition ignored)\n",
	    input_file, line_number, name);
  } else {
    // Update symbols value if already defined.
    Update_Symbol(name, type, value);
    Stat_const++;
    if (Verbose) 
      fprintf(stderr,"Creating constant %s = %s\n", name, value);
    lang->declare_const(name, type, value);
    
    // Now update documentation entry

    if (prev_doc) {
      prev_doc->usage = 0;
      lang->usage_const(name, type, value, &prev_doc->usage);
      doc->add_doc(prev_doc);
    } else {
      // Something has gone horribly wrong here
      fprintf(stderr,"SWIG : Internal parser error.  Missing documentation entry for constant in file %s, line %d\n",  input_file, line_number);
    }
  }
  prev_doc = 0;
}

/* Print out array brackets */
void print_array() {
  int i;
  for (i = 0; i < InArray; i++)
    fprintf(stderr,"[]");
}

/* manipulate small stack for managing if-then-else */

static int then_data[100];
static int else_data[100];
static int allow_data[100];
static int te_index = 0;
static int prev_allow = 1;

void if_push() {
  then_data[te_index] = in_then;
  else_data[te_index] = in_else;
  allow_data[te_index] = allow;
  prev_allow = allow;
  te_index++;
  if (te_index >= 100) {
    fprintf(stderr,"SWIG.  Internal parser error. if-then-else stack overflow.\n");
    SWIG_exit(1);
  }
}

void if_pop() {
  if (te_index > 0) {
    te_index--;
    in_then = then_data[te_index];
    in_else = else_data[te_index];
    allow = allow_data[te_index];
    if (te_index > 0) {
      prev_allow = allow_data[te_index-1];
    } else {
      prev_allow = 1;
    }
  }
}

%}

/* The type of each node in the parse tree
   must be one of the elements of the union
   given below.  This is used to derive the
   C++ declaration for "yylval" that appears
   in parser.tab.h. */

%union {         
  char        *id;
  struct Declaration {
    char *id;
    int   is_pointer;
    int   is_reference;
  } decl;
  struct InitList {
    char **names;
    int    count;
  } ilist;
  struct Define {
    char *id;
    int   type;
  } dtype;
  DataType     *type;
  Parm         *p;
  ParmList     *pl;
  int           ivalue;
};

%token <id> ID DOC
%token <id> HBLOCK POUND 
%token <id> STRING
%token <id> NUM_INT NUM_FLOAT CHARCONST NUM_UNSIGNED NUM_LONG NUM_ULONG
%token <ivalue> TYPEDEF
%token <type> TYPE_INT TYPE_UNSIGNED TYPE_SHORT TYPE_LONG TYPE_FLOAT TYPE_DOUBLE TYPE_CHAR TYPE_VOID TYPE_SIGNED
%token LPAREN RPAREN COMMA SEMI EXTERN INIT LBRACE RBRACE DEFINE
%token CONST STRUCT UNION EQUAL SIZEOF MODULE LBRACKET RBRACKET
%token WEXTERN SIGNED UNSIGNED
%token DCOLON READONLY READWRITE NAME INCLUDE 
%token CVALUE TITLE CATEGORY 
%token ENUM ENDDEF ILLEGAL
%token CLASS PRIVATE PUBLIC PROTECTED REFERENCE COLON STATIC VIRTUAL FRIEND OPERATOR
%token RAW_MODE ALPHA_MODE TEXT DOC_DISABLE DOC_ENABLE NATIVE
%token IFDEF IFNDEF ENDIF ELSE ELIF PRAGMA ADDMETHODS

%left  OR
%left  XOR
%left  AND
%left  LSHIFT RSHIFT
%left  PLUS MINUS
%left  STAR SLASH
%left  UMINUS NOT

%type <ivalue>   extern array array2;
%type <pl>       parms ptail;
%type <p>        parm;
%type <id>       pname inherit cpptype;
%type <type>     type opt_signed opt_unsigned
%type <decl>     declaration;
%type <ivalue>   stars;
%type <ilist>    initlist;
%type <dtype>    definetype definetail def_args;
%type <dtype>    etype;
%type <dtype>    expr;
%type <id>       ename;

%%

/* The productions of the grammar with their
   associated semantic actions. */

program        : INIT ID initlist {
                    lang->set_init($2);
		    InitNames = $3.names;
               } header {}
               | MODULE ID initlist {
                    lang->set_module($2);
               } header {}
               | header {}
               | WEXTERN {
		  // Obsolete 
	       } program { }
               | TITLE STRING {
		 sprintf(title,"%s",$2);
	       } program { }
               | ALPHA_MODE {
		  doc->set_doc_alpha();
	       } program { }
               | RAW_MODE {
		  doc->set_doc_raw();
               } program { }
               | error {
		 fprintf(stderr,"%s : Line %d.  Illegal declaration or missing %%{,%%} block. Bailing out...\n",input_file,line_number);
		 SWIG_exit(1);
	       } 
               ;
header         : HBLOCK {

                 /* C header block, print it out */
                 $1[strlen($1) - 1] = 0;
//		 fprintf(f_header,"#line %d \"%s\"\n", start_line, input_file);
		 fprintf(f_header, "%s\n", $1);

		 /* Output initialization header */
		 lang->initialize();
                 } command {
                     if (CPlusPlus)
		       cplus_cleanup();
                     lang->close();
		     if (te_index) {
		       fprintf(stderr,"%s : EOF.  Missing #endif detected.\n", input_file);
		       SWIG_exit(1);
		     }
		 }
               ;
    
command        : command statement { Error = 0; }
               | empty {
	       }
               ;

statement      : INCLUDE ID {
                  if (allow) {
		    doc_entry = 0;
		    Include($2);
		  }
                }
               | INCLUDE STRING {
		 if (allow) {
                  doc_entry = 0;
                  Include($2);
		 }
               }

/* A C preprocessor statement.  Print it out */

                | POUND {
		 if (allow) {
                  doc_entry = 0;
#ifdef ALLOW_DEFINE		  
		  fprintf(f_header,"%s\n", $1);
		  fprintf(f_wrappers,"%s\n", $1);
		  fprintf(f_init,"%s\n", $1);
#endif
		 }
		}

/* A variable declaration */

                | extern type declaration def_args {
		  if (allow) {
		    Active_type = *$2;
		    Active_extern = $1;
		    $2->is_pointer += $3.is_pointer;
		    if ($3.is_reference) {
		      fprintf(stderr,"%s : Line %d. Error. Linkage to C++ reference not allowed.\n", input_file, line_number);
		    } else {
		      if ($2->qualifier) {
			if (strcmp($2->qualifier,"const") == 0) {
			  // Okay.  This is really some sort of C++ constant here.
			       doc_entry = new DocEntry(category, $3.id, T_INT,"");
			  prev_doc = doc_entry;
			  if ($4.type != T_ERROR)
			    create_constant($3.id, $2, $4.id);
			} else 
			  create_variable($1,$3.id,$2);
		      } else
			create_variable($1,$3.id,$2);
		    }
		  }
                } stail { } 

/* A function declaration */

                | extern type declaration LPAREN parms RPAREN cpp_const {
		  if (allow) {
		    Active_type = *$2;
		    Active_extern = $1;
		    $2->is_pointer += $3.is_pointer;
		    $2->is_reference = $3.is_reference;
		    create_function($1, $3.id, $2, $5);
		  }
		} stail { } 

/* Enable Read-only mode */

               | READONLY {
		  if (allow)
		    Status = Status | STAT_READONLY;
	       }

/* Enable Read-write mode */

	       | READWRITE {
		 if (allow)
		   Status = Status & ~STAT_READONLY;
	       }

/* Obsolete %name directive */

   	       | NAME ID LBRACE {
		 if (allow) {
		   strcpy(yy_rename,$2);
		   Rename_true = 1;
		   fprintf(stderr,"%s : Line %d. Warning. This style of %%name is obsolete.  Use %%name(new_name) instead.\n", input_file, line_number);
		 }
	       } statement RBRACE {
		 if (allow)
		   Rename_true = 0;
	       }

/* New %name directive */
               | NAME LPAREN ID RPAREN {
		 if (allow) {
                     strcpy(yy_rename,$3);
                     Rename_true = 1;
		 }
               } statement {
		 if (allow) {
		   Rename_true = 0;
		 }
               }

/* Empty name directive.  Valid for C++ stuff  */

               | NAME LPAREN RPAREN {
		 if (allow) {
		   strcpy(yy_rename,"");
		   Rename_true = 1;
		 }
	       } cpp {
		 Rename_true = 0;
	       }

/* A native wrapper function */

               | NATIVE LPAREN ID RPAREN extern ID SEMI {
		 if (allow) {
		   if (Add_Symbol($3,(DataType *) 0, (char *) 0)) {
		     fprintf(stderr,"%s : Line %d. Name of native function %s conflicts with previous declaration (ignored)\n",
			     input_file, line_number, $3);
		   } else {
		     lang->add_native($3,$6);
		   }
		 }
	       }
               | NATIVE LPAREN ID RPAREN extern type declaration LPAREN parms RPAREN SEMI {
		 if (allow) {
		   $6->is_pointer += $7.is_pointer;
		   if (Add_Symbol($3,(DataType *) 0, (char *) 0)) {
		     fprintf(stderr,"%s : Line %d. Name of native function %s conflicts with previous declaration (ignored)\n",
			     input_file, line_number, $3);
		   } else {
		     if ($5) {
		       emit_extern_func($7.id, $6, $9, $5, f_header);
		     }
		     lang->add_native($3,$7.id);
		   }
		 }
	       }

/* %title directive */

               | TITLE STRING {
		 if (allow) {
		   if (Verbose) 
		     fprintf(stderr,"%s : Line %d. Repeated %%title. (ignored)\n",input_file, line_number);
		 }
	       }

/* %section directive */

               | CATEGORY STRING {
		 if (allow) {
		   sprintf(category,"%s",$2);
		   doc_entry = 0;
		 }
	       }

/* %alpha directive */
               | ALPHA_MODE {
		 if (allow) {
		   if (Verbose)
		     fprintf(stderr,"%s : Line %d. Repeated %%alpha (ignored)\n", input_file, line_number);
		 }
	       }
/* %raw directive */
               | RAW_MODE {
		 if (allow) {
		   if (Verbose)
		     fprintf(stderr,"%s : Line %d. Repeated %%raw (ignored)\n", input_file, line_number);
		 }
	       }
/* %disabledoc directive */
               | DOC_DISABLE {
		 if (allow) {
		   if (IgnoreDoc) {
		     /* Already in a disabled documentation */
		     doc_scope++;
		   } else {
		     if (Verbose)
		       fprintf(stderr,"%s : Line %d. Documentation disabled.\n", input_file, line_number);
		     IgnoreDoc = 1;
		     doc_scope = 1;
		   }
		 }
	       }
/* %enabledoc directive */
               | DOC_ENABLE {
		 if (allow) {
		   if (IgnoreDoc) {
		     if (doc_scope > 1) {
		       doc_scope--;
		     } else {
		       if (Verbose)
			 fprintf(stderr,"%s : Line %d. Documentation enabled.\n", input_file, line_number);
		       IgnoreDoc = 0;
		       doc_scope = 0;
		     }
		   }
		 }
	       }
/* %text %{ %} directive */

               | TEXT HBLOCK {
		 if (allow) {
		   $2[strlen($2) - 1] = 0;
		   doc_entry = new DocEntry(category, $2);
		   doc->add_doc(doc_entry);		  
		   doc_entry = 0;
		 }
	       }
/* a Typedef */

               | TYPEDEF type stars ID SEMI {
		 if (allow) {
		   /* Add a new typedef */
		   $2->is_pointer += $3;
		   Add_TypeDef($2,$4,0);
		   /* If this is %typedef, add it to the header */
		   if ($1) 
		     fprintf(f_header,"typedef %s %s;\n", $2->print_full(), $4);
		 }
	       }
               | TYPEDEF type ID SEMI {
		 if (allow) {
		   /* Add a new typedef */
		   Add_TypeDef($2,$3,0);
		   if ($1)
		     fprintf(f_header,"typedef %s %s;\n", $2->print_full(), $3);
		 }
	       }
               | TYPEDEF type LPAREN STAR pname RPAREN LPAREN parms RPAREN SEMI {
		 if (allow) {
		   /* Typedef'd pointer */
		   if ($1) {
		     sprintf(temp_name,"(*%s)",$5);
		     fprintf(f_header,"typedef ");
		     emit_extern_func(temp_name, $2,$8,0,f_header);
		   }
		   strcpy($2->name,"<function ptr>");
		   $2->type = T_USER;
		   $2->is_pointer = 1;
		   Add_TypeDef($2,$5,1);
		 }
	       }
               | TYPEDEF type stars LPAREN STAR pname RPAREN LPAREN parms RPAREN SEMI {
		 if (allow) {
		   if ($1) {
		     $2->is_pointer += $3;
		     sprintf(temp_name,"(*%s)",$6);
		     fprintf(f_header,"typedef ");
		     emit_extern_func(temp_name, $2,$9,0,f_header);
		   }

		   /* Typedef'd pointer */
		   strcpy($2->name,"<function ptr>");
		   $2->type = T_USER;
		   $2->is_pointer = 1;
		   Add_TypeDef($2,$6,1);
		 }
	       }
/* Code insertion block */

               | HBLOCK {
		 if (allow) {
		   $1[strlen($1) - 1] = 0;
//		   fprintf(f_header,"#line %d \"%s\"\n", start_line, input_file);
		   fprintf(f_header, "%s\n", $1);
		 }
	       }
/* Initialization code */

               | INIT HBLOCK {
		 if (allow) {
		   $2[strlen($2) -1] = 0;
//		   fprintf(f_init,"#line %d \"%s\"\n", start_line, input_file);
		   fprintf(f_init,"%s\n", $2);
		 }
	       }
/* Init directive--to avoid errors in other modules */

               | INIT ID initlist {
		 if (allow) {
		   if (Verbose)
		     fprintf(stderr,"%s : Line %d. %%init %s ignored.\n",
			     input_file, line_number, $2);
		   for (i = 0; i < $3.count; i++)
		     if ($3.names[i]) free((char *) $3.names[i]);
		 }
		 free((char *) $3.names);
	       }
/* Module directive */

               | MODULE ID initlist {
		 if (allow) {
		   if (Verbose)
		     fprintf(stderr,"%s : Line %d. %%module %s ignored.\n",
			     input_file, line_number, $2);
		   for (i = 0; i < $3.count; i++)
		     if ($3.names[i]) free((char *) $3.names[i]);
		 }
		 free((char *) $3.names);
	       }

               | WEXTERN {
		 if (allow) {
		   fprintf(stderr,"%s : Line %d. %%extern ignored.(is obsolete)\n",
			   input_file, line_number);
		 }
	       }

/* #define directive */

               | DEFINE ID {
		 if (allow) {
   		   doc_entry = new DocEntry(category, $2, T_INT, "");
  		   prev_doc = doc_entry;
		 }
	       } definetail {
		 if (allow) {
		   if ($4.type != T_ERROR) {
		     temp_typeptr = new DataType($4.type);
		     create_constant($2, temp_typeptr, $4.id);
		     delete temp_typeptr;
		   }
		 }
	       }

/* Enumerations */

               | ENUM ename LBRACE enumlist RBRACE SEMI {
		 if (allow) {
		   if ($2) {
		     temp_type.type = T_INT;
		     temp_type.is_pointer = 0;
		     temp_type.implicit_ptr = 0;
		     sprintf(temp_type.name,"int");
		     Add_TypeDef(&temp_type, $2,0);
		   }
		 }
	       }

/* A typdef'd enum.  Pretty common in C headers */

               | TYPEDEF ENUM ename LBRACE enumlist RBRACE ID SEMI {
		 if (allow) {
		   temp_type.type = T_INT;
		   temp_type.is_pointer = 0;
		   temp_type.implicit_ptr = 0;
		   sprintf(temp_type.name,"int");
		   Add_TypeDef(&temp_type, $7,0);
		 }
	       }
               | SEMI { }
               | cpp { }
               | error {
		 if (!Error) {
		   fprintf(stderr,"%s : Line %d. Syntax error in input.\n", input_file, line_number);
		   Error = 1;
		 }
	       }

/* A an extern C type declaration.  Does nothing, but is ignored */

               | EXTERN STRING LBRACE command RBRACE { }
               | cond_compile { }

/* Officially, this directive doesn't exist yet */

               | pragma { };

/* Conditional compilation. look out! */

/* %ifdef directive */
cond_compile   : IFDEF ID {
		 /* Push old if-then-else status */
		 if_push();
		 /* Look a symbol up in the symbol table */
		 if (Lookup_Symbol($2)) {
		   in_then = 1;
		   in_else = 0;
		   allow = 1 & prev_allow;
		 } else {
		   in_then = 1;
		   in_else = 0;
		   allow = 0;
		 }
	       }
/* %ifndef directive */

               | IFNDEF ID {
		 if_push();
		 if (Lookup_Symbol($2)) {
		   in_then = 1;
		   in_else = 0;
		   allow = 0;
		 } else {
		   in_then = 1;
		   in_else = 0;		   
		   allow = 1 & prev_allow;
		 }
	       }

/* %else directive */
               | ELSE {
		 if ((!in_then) || (in_else)) {
		   fprintf(stderr,"%s : Line %d. Misplaced else\n", input_file, line_number);
		 } else {
		   in_then = 0;
		   in_else = 1;
		   if (allow)
		     allow = 0;
		   else
		     allow = 1;
		   allow = allow & prev_allow;
		 }
	       }
/* %endif directive */
               | ENDIF {
		 if ((!in_then) && (!in_else)) {
		   fprintf(stderr,"%s : Line %d. Misplaced endif\n", input_file, line_number);
		 } else {
		   if_pop();
		 }
	       }
               ;


pragma         : PRAGMA LPAREN ID COMMA ID def_args RPAREN {
		 if (allow)
		   lang->pragma($3,$5,$6.id);
	       }


/* Allow lists of variables and functions to be built up */

stail          : SEMI { }
               | COMMA declaration def_args {
		 if (allow) {
		   if (Rename_true) {
		     fprintf(stderr,"%s : Line %d : Error. Can't apply %%name directive to multiple arguments.\n", input_file, line_number);
		   } else {
		     temp_type = Active_type;
		     temp_type.is_pointer += $2.is_pointer;
		     if ($2.is_reference) {
		       fprintf(stderr,"%s : Line %d. Error. Linkage to C++ reference not allowed.\n", input_file, line_number);
		     } else {
		       if (temp_type.qualifier) {
			 if (strcmp(temp_type.qualifier,"const") == 0) {
			   /* Okay.  This is really some sort of C++ constant here. */
			   doc_entry = new DocEntry(category, $2.id, T_INT,"");
			   prev_doc = doc_entry;
			   if ($3.type != T_ERROR)
			     create_constant($2.id, &temp_type, $3.id);
			 } else 
			   create_variable(Active_extern,$2.id, &temp_type);
		       } else
			 create_variable(Active_extern, $2.id, &temp_type);
		     }
		   }
		 }
	       } stail { } 
               | COMMA declaration LPAREN parms RPAREN cpp_const {
		 if (allow) {
		   if (Rename_true) {
		     fprintf(stderr,"%s : Line %d : Error. Can't apply %%name directive to multiple arguments.\n", input_file, line_number);
		   } else {
		     temp_type = Active_type;
		     temp_type.is_pointer += $2.is_pointer;
		     temp_type.is_reference = $2.is_reference;
		     create_function(Active_extern, $2.id, &temp_type, $4);
		   }
		 }
	       } stail { }
               | LBRACE { skip_brace(); }
               ;

definetail     : definetype ENDDEF {
                   $$ = $1;
                 } 
               | ENDDEF {
                   $$.type = T_ERROR;
	       }
               ;

extern         : EXTERN { $$ = 1; }
               | empty {$$ = 0; }
               | EXTERN STRING {
		 if (strcmp($2,"C") == 0) {
		   $$ = 2;
		 } else {
		   fprintf(stderr,"%s : Line %d.  Unrecognized extern type \"%s\" (ignored).\n", input_file, line_number, $2);
		 }
	       }
               ;

parms          : parm ptail {
                 if (($1->t->type != T_VOID) || ($1->t->is_pointer))
		   $2->add_param($1);
		 $$ = $2;
		}
               | empty { $$ = new ParmList;}
               ;

ptail          : COMMA parm ptail {
		 $3->add_param($2);
		 $$ = $3;
                }
               | empty { $$ = new ParmList;}
               ;

parm           :  type pname {
                    $$ = new Parm;
                    $$->t = $1;
		    if (InArray) {
		      fprintf(stderr,"%s : Line %d. Warning. Array %s", input_file, line_number, $1->print_type());
		      print_array();

		      $1->is_pointer++;
		      fprintf(stderr," has been converted to %s.\n", $1->print_type());
		    }
		    $$->name = $2;
		    $$->call_type = 0;
		    if (($1->type == T_USER) && !($1->is_pointer)) {
		      if (Verbose)
			fprintf(stderr,"%s : Line %d. Warning : Parameter of type '%s'\nhas been remapped to '%s *' and will be called using *((%s *) ptr).\n",
				input_file, line_number, $1->name, $1->name, $1->name);

		      $$->call_type = CALL_REFERENCE;
		      $$->t->is_pointer++;
		    }
                }

                | type stars pname {
		   $$  = new Parm;
		   $$->t = $1;
		   $$->name = $3;
		   $$->t->is_pointer += $2;
		   $$->call_type = 0;
		   if (InArray) {
		     fprintf(stderr,"%s : Line %d. Warning. Array %s", input_file, line_number, $$->t->print_type());
		     print_array();
		     $$->t->is_pointer++;
		     fprintf(stderr," has been converted to %s.\n", $$->t->print_type());
		    }
		}
		
                | CVALUE type stars pname {
		  $$ = new Parm;
		  $$->t = $2;
		  $$->name = $4;
		  $$->t->is_pointer += $3;
		  $$->call_type = CALL_VALUE;
		  if (InArray) {
		     fprintf(stderr,"%s : Line %d. Error. Can't use %%val with an array.\n", input_file, line_number);
		  }
		  $$->t->is_pointer--;
		}
                | CVALUE type AND pname {
		  $$ = new Parm;
		  $$->t = $2;
		  $$->name = $4;
		  $$->t->is_pointer = 1;
		  $$->t->is_reference = 1;
		  $$->call_type = CALL_VALUE;
		  if (InArray) {
		     fprintf(stderr,"%s : Line %d. Error. Can't use %%val with an array.\n", input_file, line_number);
		  }
		  $$->t->is_pointer--;
		  if (!CPlusPlus) {
			fprintf(stderr,"%s : Line %d. Warning.  Use of C++ Reference detected.  Use the -c++ option.\n", input_file, line_number);
		  }

		}

                | type AND pname {
		  $$ = new Parm;
		  $$->t = $1;
		  $$->name = $3;
		  $$->t->is_reference = 1;
		  $$->call_type = 0;
		  $$->t->is_pointer++;
		  if (!CPlusPlus) {
			fprintf(stderr,"%s : Line %d. Warning.  Use of C++ Reference detected.  Use the -c++ option.\n", input_file, line_number);
		  }
		}
                | type LPAREN stars pname RPAREN LPAREN parms RPAREN {
                  fprintf(stderr,"%s : Line %d. Error. Function pointer not allowed (remap with typedef).\n", input_file, line_number);
		  $$ = new Parm;
		  $$->t = $1;
		  $$->t->type = T_ERROR;
		  $$->name = $4;
		  strcpy($$->t->name,"<function ptr>");
		}		  
		;
    

pname          : ID def_args {$$ = $1; InArray = 0;}
               | ID array {$$ = $1; InArray = $2;}
               | empty { $$ = new char[1];
	                 $$[0] = 0;
                         InArray = 0;
               }
               ;

def_args       : EQUAL definetype { $$ = $2; }
               | EQUAL AND ID {
		 $$.id = new char[strlen($3)+2];
		 $$.id[0] = '&';
		 strcpy(&$$.id[1], $3);
		 $$.type = T_USER;
	       }
               | empty {$$.id = 0; $$.type = T_INT;}
               ;

/* Declaration must be an identifier, possibly preceded by a * for pointer types  */

declaration    : ID { $$.id = $1;
                      $$.is_pointer = 0;
		      $$.is_reference = 0;
                }
               | stars ID {
                      $$.id = $2;
		      $$.is_pointer = $1;
		      $$.is_reference = 0;
	       }
               | AND ID {
		      $$.id = $2;
		      $$.is_pointer = 1;
		      $$.is_reference = 1;
		      if (!CPlusPlus) {
			fprintf(stderr,"%s : Line %d. Warning.  Use of C++ Reference detected.  Use the -c++ option.\n", input_file, line_number);
		      }
	       }
               ;

stars :          STAR empty { $$ = 1; }
               | STAR stars { $$ = $2 + 1;}
               ;


array :        LBRACKET RBRACKET array2 {
		 $$ = $3 + 1;
              }
              | LBRACKET NUM_INT RBRACKET array2 {
                 $$ = $4 + 1;
              }
	      ;
array2 :       array {
                 $$ = $1;
              }
              | empty { $$ = 0;}
	      ;

/* Data type must be a built in type or an identifier for user-defined types
   This type can be preceded by a modifier. */

type           : TYPE_INT {
                   $$ = $1;
               }
               | TYPE_SHORT opt_int {
                   $$ = $1;
	       }
               | TYPE_LONG opt_int {
                   $$ = $1;
	       }
               | TYPE_CHAR {
                   $$ = $1;
	       }
               | TYPE_FLOAT {
                   $$ = $1;
	       }
               | TYPE_DOUBLE {
                   $$ = $1;
	       }
               | TYPE_VOID {
                   $$ = $1;
	       }
               | TYPE_SIGNED opt_signed {
                   if ($2) $$ = $2;
		   else $$ = $1;
	       }
               | TYPE_UNSIGNED opt_unsigned {
                   if ($2) $$ = $2;
		   else $$ = $1;
	       }
               | ID {
		  $$ = new DataType;
		  strcpy($$->name,$1);
		  $$->type = T_USER;
		  /* Do a typedef lookup */
		  Get_TypeDef($$);
	       }
               | CONST type {
		  $$ = $2;
                  $$->qualifier = new char[6];
		  strcpy($$->qualifier,"const");
     	       }
               | cpptype ID {
                  $$ = new DataType;
		  sprintf($$->name,"%s %s",$1, $2);
		  $$->type = T_USER;
	       }
               ;

/* Optional signed types */

opt_signed     : empty {
                   $$ = (DataType *) 0;
               }
               | TYPE_INT {
                   $$ = $1;
		   $$->type += M_SIGNED;
		   sprintf(temp_name,"signed %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               | TYPE_SHORT {
                   $$ = $1;
		   $$->type += M_SIGNED;
		   sprintf(temp_name,"signed %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               | TYPE_LONG {
                   $$ = $1;
		   $$->type += M_SIGNED;
		   sprintf(temp_name,"signed %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               | TYPE_CHAR {
                   $$ = $1;
		   $$->type += M_SIGNED;
		   sprintf(temp_name,"signed %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               ;

/* Optional unsigned types */

opt_unsigned   : empty {
                   $$ = (DataType *) 0;
               }
               | TYPE_INT {
                   $$ = $1;
		   $$->type += M_UNSIGNED;
		   sprintf(temp_name,"unsigned %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               | TYPE_SHORT {
                   $$ = $1;
		   $$->type += M_UNSIGNED;
		   sprintf(temp_name,"unsigned %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               | TYPE_LONG {
                   $$ = $1;
		   $$->type += M_UNSIGNED;
		   sprintf(temp_name,"unsigned %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               | TYPE_CHAR {
                   $$ = $1;
		   $$->type += M_UNSIGNED;
		   sprintf(temp_name,"unsigned %s",$1->name);
		   strcpy($$->name,temp_name);
	       }
               ;

opt_int        : TYPE_INT { }
               | empty { }
               ;

definetype     : expr {
                   $$ = $1;
                }
                | STRING {
                   $$.id = $1;
                   $$.type = T_CHAR;
		}
                | CHARCONST {
                   $$.id = $1;
		   $$.type = T_CHAR;
		 }
                ;	       

/* Initialization function links */

initlist       : initlist COMMA ID {
                 $$ = $1;
		 $$.names[$$.count] = copy_string($3);
		 $$.count++;
		 $$.names[$$.count] = (char *) 0;
                }
               | empty {
                 $$.names = (char **) malloc(NI_NAMES*sizeof(char *));
		 $$.count = 0;
		 for (i = 0; i < NI_NAMES; i++) 
		   $$.names[i] = (char *) 0;
	       }
               ;

/* Some stuff for handling enums */

ename          :  ID { $$ = $1; } 
               |  empty { $$ = (char *) 0;}
               ;

/* SWIG enum list.   
*/

enumlist       :  enumlist COMMA edecl {}
               |  edecl {}
               ;

edecl          :  ID {
                   prev_doc = doc_entry = new DocEntry(category, $1, T_INT, $1);
		   temp_typeptr = new DataType(T_INT);
		   create_constant($1, temp_typeptr, $1);
		   delete temp_typeptr;
		 } 
                 | ID EQUAL etype {
		   prev_doc = doc_entry = new DocEntry(category, $1, $3.type, $3.id);
		   temp_typeptr = new DataType($3.type);
		   create_constant($1, temp_typeptr, $3.id);
		   delete temp_typeptr;
                 }
                 ;
		   
etype            : expr {
                   $$ = $1;
		   if ($$.type != T_INT) 
		     fprintf(stderr,"%s : Lind %d. Type error. Expecting an int\n",
			     input_file, line_number);
		   $$.type = T_INT;
                }
                | CHARCONST {
                   $$.id = $1;
		   $$.type = T_CHAR;
		 }
                ;	       

/* Arithmetic expressions.   Used for constants and other cool stuff.
   Really, we're not doing anything except string concatenation, but
   this does allow us to parse many constant declarations.
 */

expr           :  NUM_INT { 
                  $$.id = $1;
                  $$.type = T_INT;
                 }
               |  NUM_FLOAT {
                  $$.id = $1;
                  $$.type = T_DOUBLE;
               }
               |  NUM_UNSIGNED {
                  $$.id = $1;
		  $$.type = T_UINT;
	       }
               |  NUM_LONG {
                  $$.id = $1;
		  $$.type = T_LONG;
	       } 
               |  NUM_ULONG {
                  $$.id = $1;
		  $$.type = T_ULONG;
	       }
               |  SIZEOF LPAREN type RPAREN {
	          $$.id = new char[strlen($3->name)+9];
		  sprintf($$.id,"sizeof(%s)", $3->name);
		  $$.type = T_INT;
	       }
               | ID {
		 $$.id = Lookup_SymValue($1);
		 if ($$.id == (char *) 0)
		   $$.id = $1;
		 else {
		   $$.id = new char[strlen($$.id)+3];
		   sprintf($$.id,"(%s)",Lookup_SymValue($1));
		 }
		 temp_typeptr = Lookup_SymType($1);
		 if (temp_typeptr) $$.type = temp_typeptr->type;
		 else $$.type = T_INT;
	       }
               | expr PLUS expr {
	         E_BINARY($$.id,$1.id,$3.id,"+");
		 $$.type = promote($1.type,$3.type);
	       }
               | expr MINUS expr {
	         E_BINARY($$.id,$1.id,$3.id,"-");
		 $$.type = promote($1.type,$3.type);
	       }
               | expr STAR expr {
	         E_BINARY($$.id,$1.id,$3.id,"*");
		 $$.type = promote($1.type,$3.type);
	       }
               | expr SLASH expr {
	         E_BINARY($$.id,$1.id,$3.id,"/");
		 $$.type = promote($1.type,$3.type);
	       }
               | expr AND expr {
	         E_BINARY($$.id,$1.id,$3.id,"&");
		 $$.type = promote($1.type,$3.type);
		 if (($1.type == T_DOUBLE) || ($3.type == T_DOUBLE))
		   fprintf(stderr,"%s : Line %d. Type error in constant expression (expecting integers).\n", input_file, line_number);
	       }
               | expr OR expr {
	         E_BINARY($$.id,$1.id,$3.id,"|");
		 $$.type = promote($1.type,$3.type);
		 if (($1.type == T_DOUBLE) || ($3.type == T_DOUBLE))
		   fprintf(stderr,"%s : Line %d. Type error in constant expression (expecting integers).\n", input_file, line_number);
		 $$.type = T_INT;
	       }
               | expr XOR expr {
	         E_BINARY($$.id,$1.id,$3.id,"^");
		 $$.type = promote($1.type,$3.type);
		 if (($1.type == T_DOUBLE) || ($3.type == T_DOUBLE))
		   fprintf(stderr,"%s : Line %d. Type error in constant expression (expecting integers).\n", input_file, line_number);
		 $$.type = T_INT;
	       }
               | expr LSHIFT expr {
	         E_BINARY($$.id,$1.id,$3.id,"<<");
		 $$.type = promote($1.type,$3.type);
		 if (($1.type == T_DOUBLE) || ($3.type == T_DOUBLE))
		   fprintf(stderr,"%s : Line %d. Type error in constant expression (expecting integers).\n", input_file, line_number);
		 $$.type = T_INT;
	       }
               | expr RSHIFT expr {
	         E_BINARY($$.id,$1.id,$3.id,">>");
		 $$.type = promote($1.type,$3.type);
		 if (($1.type == T_DOUBLE) || ($3.type == T_DOUBLE))
		   fprintf(stderr,"%s : Line %d. Type error in constant expression (expecting integers).\n", input_file, line_number);
		 $$.type = T_INT;
	       }

               |  MINUS expr %prec UMINUS {
	          $$.id = new char[strlen($2.id)+2];
		  sprintf($$.id,"-%s",$2.id);
		  $$.type = $2.type;
	       }
               |  NOT expr {
	          $$.id = new char[strlen($2.id)+2];
		  sprintf($$.id,"~%s",$2.id);
		  if ($2.type == T_DOUBLE)
		   fprintf(stderr,"%s : Line %d. Type error in constant expression (expecting integers).\n", input_file, line_number);
		  $$.type = $2.type;
	       }


               |  LPAREN expr RPAREN {
	          $$.id = new char[strlen($2.id)+3];
	          sprintf($$.id,"(%s)", $2.id);
		  $$.type = $2.type;
	       }
               ;

/* Super experimental C++ support */
/* This still need abit of work.... */

cpp          : cpp_class { }
             | cpp_other {}
             ;
  
cpp_class    : 

/* A class/struct/union  definition */
             extern cpptype ID inherit LBRACE {
	       if (allow) {
		 sprintf(temp_name,"CPP_CLASS:%s\n",$3);
		 if (Add_Symbol(temp_name, (DataType *) 0, (char *) 0)) {
		   fprintf(stderr,"%s : Line %d. Error. %s %s is multiply defined.\n", input_file, line_number, $2, $3);
		 }
		 if ((!CPlusPlus) && (strcmp($2,"class") == 0))
		   fprintf(stderr,"%s : Line %d. *** WARNING ***. C++ mode is disabled (enable using -c++)\n", input_file, line_number);
		 if (Rename_true) 
		   set_classname($3, yy_rename, $2);
		 else
		   set_classname($3, (char *) 0,$2);
		 if (strcmp($2,"class") == 0)
		   cplus_mode = CPLUS_PRIVATE;
		 else
		   cplus_mode = CPLUS_PUBLIC;
		 Rename_true = 0;
	       }
              } cpp_members RBRACE {
		if (allow) {
		  if ($4) {
		    if (strcmp($2,"union") != 0)
		      cplus_inherit($4);
		    else
		      fprintf(stderr,"%s : Line %d.  Inheritance not allowed for unions.\n",input_file, line_number);
		  }
		  cplus_class_close((char *) 0); 
		  doc_entry = 0;
		}
	      }

/* Class with a typedef */
		
             | TYPEDEF cpptype ID inherit LBRACE {
	       if (allow) {
		 sprintf(temp_name,"CPP_CLASS:%s\n",$3);
		 if (Add_Symbol(temp_name, (DataType *) 0, (char *) 0)) {
		   fprintf(stderr,"%s : Line %d. Error. %s %s is multiply defined.\n", input_file, line_number, $2, $3);
		 }
		 if ((!CPlusPlus) && (strcmp($2,"class") == 0))
		   fprintf(stderr,"%s : Line %d. *** WARNING ***. C++ mode is disabled (enable using -c++)\n", input_file, line_number);
		 
		 if (Rename_true) 
		   set_classname($3, yy_rename, $2);
		 else
		   set_classname($3, (char *) 0, $2);
		 if (strcmp($2,"class") == 0)
		   cplus_mode = CPLUS_PRIVATE;
		 else
		   cplus_mode = CPLUS_PUBLIC;
		 Rename_true = 0;
	       }
              } cpp_members RBRACE ID SEMI {
		if (allow) {
		  if ($4) {
		    if (strcmp($2,"union") != 0)
		      cplus_inherit($4);
		    else
		      fprintf(stderr,"%s : Line %d.  Inheritance not allowed for unions.\n",input_file, line_number);
		  }
		  cplus_class_close($9); 
		  doc_entry = 0;
		}
	      }

/* An unnamed struct with a typedef */

             | TYPEDEF cpptype LBRACE {
	       if (allow) {
		 if ((!CPlusPlus) && (strcmp($2,"class") == 0))
		   fprintf(stderr,"%s : Line %d. *** WARNING ***. C++ mode is disabled (enable using -c++)\n", input_file, line_number);
		 
		 if (Rename_true) 
		   set_classname("", yy_rename, $2);
		 else
		   set_classname("", (char *) 0, $2);
		 if (strcmp($2,"class") == 0)
		   cplus_mode = CPLUS_PRIVATE;
		 else
		   cplus_mode = CPLUS_PUBLIC;
		 Rename_true = 0;
	       }
              } cpp_members RBRACE ID SEMI {
		if (allow) {
		  sprintf(temp_name,"CPP_CLASS:%s\n",$7);
		  if (Add_Symbol(temp_name, (DataType *) 0, (char *) 0)) {
		    fprintf(stderr,"%s : Line %d. Error. %s %s is multiply defined.\n", input_file, line_number, $2, $7);
		  }
		  cplus_class_close($7); 
		  doc_entry = 0;
		}
	      }

cpp_other    :/* A dummy class name */

             extern cpptype ID SEMI { }   

/* A static C++ member function (declared out of scope)  */
            
              | extern type declaration DCOLON ID LPAREN parms RPAREN SEMI {
	       if (allow) {
		 if (!CPlusPlus) 
		   fprintf(stderr,"%s : Line %d. *** WARNING ***. C++ mode is disabled (enable using -c++)\n", input_file, line_number);
		 
		 $2->is_pointer += $3.is_pointer;
		 $2->is_reference = $3.is_reference;
		 // Fix up the function name
		      sprintf(temp_name,"%s::%s",$3.id,$5);
		 if (!Rename_true) {
		   Rename_true = 1;
		   sprintf(yy_rename,"%s_%s",$3.id,$5);
		 }
		 create_function($1, temp_name, $2, $7);
	       }
	     }
 
/* A static C++ member data */
             | extern type declaration DCOLON ID SEMI {
	       if (allow) {
                if (!CPlusPlus) 
		  fprintf(stderr,"%s : Line %d. *** WARNING ***. C++ mode is disabled (enable using -c++)\n", input_file, line_number);

	       $2->is_pointer += $3.is_pointer;
	       // Fix up the function name
	       sprintf(temp_name,"%s::%s",$3.id,$5);
	       if (!Rename_true) {
		 Rename_true = 1;
		 sprintf(yy_rename,"%s_%s",$3.id,$5);
	       }
	       create_variable($1,temp_name, $2);
	       }
	     }

             | extern type declaration DCOLON OPERATOR {
	       fprintf(stderr,"%s : Line %d. Operator overloading not supported (ignored).\n", input_file, line_number);
		skip_decl();
	     } SEMI { }
             ;

cpp_members  : cpp_member cpp_members {}
             | ADDMETHODS LBRACE {
	           cplus_newmethod(1);
	     } cpp_members RBRACE {
	       cplus_newmethod(0);
	     }
             | empty { }
             ;

cpp_member   :  type declaration LPAREN parms RPAREN cpp_end {
                if (allow) {
                if (cplus_mode == CPLUS_PUBLIC) {
		  Stat_func++;
		  $1->is_pointer += $2.is_pointer;
		  $1->is_reference = $2.is_reference;
		  if (Verbose) {
		      fprintf(stderr,"Wrapping member function : %s\n",$2.id);
		  }
		  if (Rename_true)
		    cplus_member_func($2.id,yy_rename,$1,$4,0);
		  else
		    cplus_member_func($2.id,(char *) 0, $1,$4,0);
		}
		}
             }
 
/* Virtual member function */
                      
             |  VIRTUAL type declaration LPAREN parms RPAREN cpp_vend {
	       if (allow) {
                if (cplus_mode == CPLUS_PUBLIC) {
		  Stat_func++;
		  $2->is_pointer += $3.is_pointer;
		  $2->is_reference = $3.is_reference;
		  if (Verbose) {
		      fprintf(stderr,"Wrapping virtual member function : %s\n",$3.id);
		  }
		  if (Rename_true)
		    cplus_member_func($3.id,yy_rename,$2,$5,1);
		  else
		    cplus_member_func($3.id,(char *) 0,$2,$5,1);
		}
	       }
	     }

/* Possibly a constructor */
              | ID LPAREN parms RPAREN cpp_end {
		if (allow) {
		  if (cplus_mode == CPLUS_PUBLIC) {
		    Stat_func++;
		    if (Verbose) {
		      fprintf(stderr,"Wrapping C++ constructor %s\n", $1);
		    }
		    if (Rename_true)
		      cplus_constructor($1,yy_rename,$3);
		    else
		      cplus_constructor($1,(char *) 0, $3);
		  }
		}
	      }

/* A destructor (hopefully) */

              | NOT ID LPAREN RPAREN cpp_end {
		if (allow) {
		  if (cplus_mode == CPLUS_PUBLIC) {
		    Stat_func++;
		    if (Verbose) {
		      fprintf(stderr,"Wrapping C++ destructor %s\n", $2);
		    }
		    if (Rename_true)
		      cplus_destructor($2,yy_rename);
		    else
		      cplus_destructor($2,(char *) 0);
		  }
		}
	      }

/* A virtual destructor */

              | VIRTUAL NOT ID LPAREN RPAREN cpp_end {
		if (allow) {
		  if (cplus_mode == CPLUS_PUBLIC) {
		    Stat_func++;
		    if (Verbose) {
		      fprintf(stderr,"Wrapping C++ destructor %s\n", $3);
		    }
		    if (Rename_true)
		      cplus_destructor($3,yy_rename);
		    else
		      cplus_destructor($3,(char *) 0);
		  }
		}
	      }
/* Member data */

              | type declaration def_args {
		if (allow) {
		  if (cplus_mode == CPLUS_PUBLIC) {
		    $1->is_pointer += $2.is_pointer;
		    $1->is_reference = $2.is_reference;
		    if ($1->qualifier) {
		      if (strcmp($1->qualifier,"const") == 0) {
			// Okay.  This is really some sort of C++ constant here.
	  	          if ($3.type != T_ERROR) {
			    if (Rename_true)
			      cplus_declare_const($2.id,yy_rename, $1, $3.id);
			    else
			      cplus_declare_const($2.id,(char *) 0, $1, $3.id);
			  }
		      } else {
			if (Rename_true)
			  cplus_variable($2.id,yy_rename,$1);
			else
			  cplus_variable($2.id,(char *) 0, $1);
		      }
		    } else {
		      if (Rename_true)
			cplus_variable($2.id,yy_rename,$1);
		      else
			cplus_variable($2.id,(char *) 0, $1);
		      Active_type = *$1;
		      if (Verbose) {
			fprintf(stderr,"Wrapping member data %s\n", $2.id);
		      }
		    }
		  }
		}
	      } cpp_tail { }


/* Static Member data */

              | STATIC type declaration {
		if (allow) {
		  if (cplus_mode == CPLUS_PUBLIC) {
		    $2->is_pointer += $3.is_pointer;
		    if (Rename_true)
		      cplus_static_var($3.id,yy_rename,$2);
		    else
		      cplus_static_var($3.id,(char *) 0, $2);
		    Active_type = *$2;
		    if (Verbose) {
		      fprintf(stderr,"Wrapping static member data %s\n", $3.id);
		    }
		  }
		}
	      } cpp_tail { }

/* Static member function */

              | STATIC type declaration LPAREN parms RPAREN cpp_end {
		if (allow) {
		  $2->is_pointer += $3.is_pointer;
		  $2->is_reference = $3.is_reference;
		  if (cplus_mode == CPLUS_PUBLIC) {
		    if (Rename_true)
		      cplus_static_func($3.id, yy_rename, $2, $5);
		    else
		      cplus_static_func($3.id, (char *) 0, $2, $5);
		    if (Verbose)
		      fprintf(stderr,"Wrapping static member function %s\n",$3.id);
		  }
		}
	      }
/* Turn on public: mode */

              | PUBLIC COLON {
		if (allow) {
		  cplus_mode = CPLUS_PUBLIC;
		  if (Verbose)
		    fprintf(stderr,"Public mode\n");
		}
	      }

/* Turn on private: mode */

              | PRIVATE COLON {
		if (allow) {
		  cplus_mode = CPLUS_PRIVATE;
		  if (Verbose)
		    fprintf(stderr,"Private mode\n");
		}
	      }

/* Turn on protected mode */

              | PROTECTED COLON {
		if (allow) {
		  cplus_mode = CPLUS_PROTECTED;
		  if (Verbose)
		    fprintf(stderr,"Protected mode\n");
		}
	      }

/* WARNING : This style will be eliminated in 1.0 Final */

              | NAME ID LBRACE {
		if (allow) {
		  strcpy(yy_rename,$2);
		  Rename_true = 1;
		  fprintf(stderr,"%s : Line %d. Warning. This style of %%name is obsolete.  Use %%name(new_name) instead.\n", input_file, line_number);
		}
	       } cpp_member RBRACE {
		 if (allow)
		    Rename_true = 0;
	       }

/* This is the new style rename */

             | NAME LPAREN ID RPAREN {
	       if (allow) {
		 strcpy(yy_rename,$3);
		 Rename_true = 1;
	       }
	     } cpp_member {
	       if (allow)
		 Rename_true = 0;
	     }

/* C++ Enum */
              | ENUM ename LBRACE cpp_enumlist RBRACE SEMI {

		 // if ename was supplied.  Install it as a new integer datatype.
		 // (sort of an implicit typedef)
	       if (allow) {
		 if (cplus_mode == CPLUS_PUBLIC) {
		   if ($2) {
		     temp_type.type = T_INT;
		     temp_type.is_pointer = 0;
		     temp_type.implicit_ptr = 0;
		     sprintf(temp_type.name,"int");
		     Add_TypeDef(&temp_type, $2,0);
		   }
		 }
	       }
	      }
              | READONLY {
		if (allow)
		  Status = Status | STAT_READONLY;
              }
              | READWRITE {
		if (allow) 
		  Status = Status & ~(STAT_READONLY);
	      }
/* A friend :   Illegal */
              | FRIEND {
		if (allow)
		  fprintf(stderr,"%s : Line %d. Friends are not allowed--members only! (ignored)\n", input_file, line_number);
		skip_decl();
	      }  

/* An operator: Illegal */
              | type type_extra OPERATOR {
		if (allow)
		  fprintf(stderr,"%s : Line %d. Operator overloading not supported (ignored).\n", input_file, line_number);
		skip_decl();
	      }
              | cond_compile { }
              | pragma { }
              ;

              | SEMI { }
              ;

type_extra    : stars {}
              | AND {}
              | empty {}
              ; 

cpp_tail      : SEMI { }
               | COMMA declaration def_args {
		 if (allow) {
		   if (cplus_mode == CPLUS_PUBLIC) {
		     temp_type = Active_type;
		     temp_type.is_pointer += $2.is_pointer;
		     if (Verbose) {
		       fprintf(stderr,"Wrapping member variable : %s\n",$2.id);
		     }
		     Stat_var++;
		     cplus_variable($2.id,(char *) 0,&temp_type);		   
		   }
		 }
	       } cpp_tail { } 
               ;

cpp_end        : cpp_const SEMI { } 
               | cpp_const LBRACE { skip_brace(); }
               ;

cpp_vend       : cpp_const SEMI { }
               | cpp_const EQUAL definetype SEMI { }
               | cpp_const LBRACE { skip_brace(); }
               ;

cpp_enumlist   :  cpp_enumlist COMMA cpp_edecl {}
               |  cpp_edecl {}
               ;

cpp_edecl      :  ID {
                    if (allow) {
		      if (cplus_mode == CPLUS_PUBLIC) {
			if (Verbose) {
			  fprintf(stderr,"Creating enum value %s\n", $1);
			}
			Stat_const++;
			temp_typeptr = new DataType(T_INT);
			cplus_declare_const($1, (char *) 0, temp_typeptr, (char *) 0);
			delete temp_typeptr;
		      }
		    }
                  }
                 | ID EQUAL etype {
		   if (allow) {
		     if (cplus_mode == CPLUS_PUBLIC) {
		       if (Verbose) {
			 fprintf(stderr, "Creating enum value %s = %s\n", $1, $3.id);
		       }
		       Stat_const++;
		       temp_typeptr = new DataType(T_INT);
		       cplus_declare_const($1,(char *) 0, temp_typeptr,$3.id);
		       delete temp_typeptr;
		     }
		   }
		 }
                 | NAME LPAREN ID RPAREN ID {
		   if (allow) {
		     if (cplus_mode == CPLUS_PUBLIC) {
		       if (Verbose) {
			 fprintf(stderr,"Creating enum value %s\n", $5);
		       }
		       Stat_const++;
		       temp_typeptr = new DataType(T_INT);
		       cplus_declare_const($5, $3, temp_typeptr, (char *) 0);
		       delete temp_typeptr;
		     }
		   }
		 }
                 | NAME LPAREN ID RPAREN ID EQUAL etype {
		   if (allow) {
		     if (cplus_mode == CPLUS_PUBLIC) {
		       if (Verbose) {
			 fprintf(stderr, "Creating enum value %s = %s\n", $5, $7.id);
		       }
		       Stat_const++;
		       temp_typeptr = new DataType(T_INT);
		       cplus_declare_const($5,$3, temp_typeptr,$7.id);
		       delete temp_typeptr;
		     }
		   }
		 }
                 ;

inherit        : COLON PUBLIC ID {
		   $$ = $3;
                }
                | empty {
                   $$ = (char *) 0;
                }
                ;

cpptype        : CLASS { $$ = "class"; }
               | STRUCT { $$ = "struct"; }
               | UNION {$$ = "union"; }
               ;

cpp_const      : CONST {} 
               | empty {}
               ;

empty          :   ;

%%

void error_recover() {
  int c;
  c = yylex();
  while ((c > 0) && (c != SEMI)) 
    c = yylex();
}

/* Called by the parser (yyparse) when an error is found.*/
extern "C" void yyerror (char *) {
  //  fprintf(stderr,"%s : Line %d. Syntax error.\n", input_file, line_number);
  error_recover();
}


