
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * Version 2.0 (pre-pre-pre Alpha)
 *
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/

// ---------------------------------------------------------------
// sstring.cxx
//
// This is experimental.   Eventually will be a part of SWIG 2.0
//
// SWIG String class.
// This class is used to construct long strings when writing 
// wrapper functions.  It also "mimicks" the C++ streams I/O
// library for creating strings.  For example :
//
//     str << "hi there" << 3 << "\n";
// 
// Will append the given strings to str.
//
// The idea here is to provide a mechanism for writing wrapper
// functions as strings before writing them out to a file.
//
// ---------------------------------------------------------------

#include "internal.h"

#define INIT_MAXSIZE  40

String::String() {
  maxsize = INIT_MAXSIZE;
  str = new char[maxsize];
  str[0] = 0;
  len = 0;
}

String::String(const char *s) {
  int  max = INIT_MAXSIZE;
  if (((int) strlen(s)+1) > max) max = (int) strlen(s)+1;
  str = new char[max];
  strcpy(str,s);
  maxsize = max;
  len = strlen(s);
}

String::~String() {
  delete str;
}

void String::add(const char *newstr) {
  int   newlen;
  char  *nstr = 0;
  int   newmaxsize;

  newlen = len+strlen(newstr) + 1;
  if (newlen >= maxsize-1) {
    newmaxsize = 2*maxsize;
    if (newlen >= newmaxsize -1) newmaxsize = newlen + 1;
    nstr = new char[newmaxsize];
    strcpy(nstr,str);
    delete str;
    maxsize = newmaxsize;
    str = nstr;
  }
  strcpy(str+len,newstr);
  len += strlen(newstr);
}

char *String::get() const {
  return str;
}

String &operator<<(String &t,const char *s) {
  t.add(s);
  return t;
}

String &operator<<(String &t,const int a) {
  char  temp[64];
  sprintf(temp,"%d",a);
  t.add(temp);
  return t;
}

String &operator<<(String &t, String &s) {
  t.add(s.get());
  return t;
}

String &String::operator=(const char *s) {
  if (str) delete str;
  str = new char[strlen(s)+1];
  strcpy(str,s);
  maxsize = strlen(s)+1;
  return *this;
}

  
  
