
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/types.cxx,v 1.13 1996/09/07 18:37:54 dmb Exp $
 *
 * types.cc
 *
 * This file contains functions for dealing with datatypes.  This
 * is a combination of the file typedef.cc (now obsolete) and functions
 * that used to be in the swig.h header.
 *
 * -- Revision History
 * $Log: types.cxx,v $
 * Revision 1.13  1996/09/07 18:37:54  dmb
 * Fixed bug in typedef mechanism.
 *
 * Revision 1.12  1996/08/27 05:06:46  dmb
 * Fixed bug in typedef
 *
 * Revision 1.11  1996/08/21 05:48:39  dmb
 * Made some changes to how default type-equivalences are added.
 *
 * Revision 1.10  1996/08/15 05:05:26  dmb
 * Fixed problem with default type-mappings and Perl5
 *
 * Revision 1.9  1996/08/12 01:51:36  dmb
 * Some changes for better support of C++ references
 *
 * Revision 1.8  1996/06/10 23:53:52  beazley
 * Fixed bug in typedef mechanism.
 *
// Revision 1.7  1996/06/10  23:34:14  beazley
// Took out annoying undefined type warning.
//
// Revision 1.6  1996/06/02  00:14:56  beazley
// Added function to copy datatypes
//
// Revision 1.5  1996/05/28  23:17:26  beazley
// Changed technique for handling typedef equivalences
//
// Revision 1.4  1996/05/22  20:20:21  beazley
// Added functions to keep track of class equivalences.
// (Used for pointer type-checking).
//
// Revision 1.3  1996/05/14  23:24:10  beazley
// Added reference field.
//
// Revision 1.2  1996/04/14  15:24:48  dmb
// Fixed headers.
//
 * Revision 1.1  1996/03/28 02:47:28  beazley
 * Initial revision
 *
// Revision 1.1  1996/03/16  06:29:42  beazley
// Initial revision
//
// Revision 1.1  1996/02/15  22:36:27  beazley
// Initial revision
//
 *
 *
 ***********************************************************************/

#include "internal.h"

// -------------------------------------------------------------------
// class DataType member functions.
// -------------------------------------------------------------------

DataType::DataType() {
    type = 1;
    name[0] = 0;
    is_pointer = 0;
    implicit_ptr = 0;
    qualifier = 0;
    is_reference = 0;
}

// Create a data type only from the type code (used to form constants)

DataType::DataType(int t) {
  switch(t) {
  case T_INT: case T_SINT:
    strcpy(name,"int");
    break;
  case T_UINT:
    strcpy(name,"unsigned int");
    break;
  case T_SHORT: case T_SSHORT:
    strcpy(name,"short");
    break;
  case T_USHORT:
    strcpy(name,"unsigned short");
    break;
  case T_LONG: case T_SLONG:
    strcpy(name,"long");
    break;
  case T_ULONG:
    strcpy(name,"unsigned long");
    break;
  case T_FLOAT:
    strcpy(name, "float");
    break;
  case T_DOUBLE:
    strcpy(name, "double");
    break;
  case T_CHAR: case T_SCHAR:
    strcpy(name, "char");
    break;
  case T_UCHAR:
    strcpy(name,"unsigned char");
    break;
  default :
    strcpy(name,"SWIG ERROR");
    break;
  }
  type = t;
  is_pointer = 0;
  implicit_ptr = 0;
  qualifier = 0;
  is_reference = 0;
}
 	
DataType::DataType(DataType *t) {
    type = t->type;
    strcpy(name,t->name);
    is_pointer = t->is_pointer;
    implicit_ptr = t->implicit_ptr;
    qualifier = t->qualifier;
    is_reference = t->is_reference;
}

DataType::~DataType() {
    if (qualifier) delete qualifier;
}

// --------------------------------------------------------------------
// char *print_type()
//
// Print the datatype, but without qualifiers (ie. const, volatile)
// Returns a string containing the result.
//
// If a datatype is marked as an implicit ptr it means that is_pointer
// is at least one, but we don't print '*'.
// --------------------------------------------------------------------

char *DataType::print_type() {
  static char result[128];
  char   *c;

  sprintf(result,"%s ", name);
  c = result + strlen(result);
  for (int i = 0; i < (is_pointer-implicit_ptr); i++)
    *(c++) = '*';

  *c = 0;
  return result;

}

// --------------------------------------------------------------------
// char *print_full()
//
// Prints full type, with qualifiers.
// --------------------------------------------------------------------

char *DataType::print_full() {
  static char result[128];

  if (qualifier)
    sprintf(result,"%s %s", qualifier, print_type());
  else 
    sprintf(result,"%s", print_type());

  return result;

}

// --------------------------------------------------------------------
// char *print_cast()
//
// Prints a cast.  (Basically just a type but with parens added).
// --------------------------------------------------------------------

char *DataType::print_cast() {
  static char result[128];

  sprintf(result,"(%s)", print_type());
  return result;

}

// --------------------------------------------------------------------
// char *print_mangle_default()
//
// Prints a mangled version of this datatype.   Used for run-time type
// checking in order to print out a "language friendly" version (ie. no
// spaces and no weird characters).
// --------------------------------------------------------------------

char *DataType::print_mangle_default() {
  static char result[128];
  int   i;
  char *r, *c;

  r = result;
  c = name;

  *(r++) = '_';
  for (; *c; c++,r++) {
      if (*c == ' ') *r = '_';
      else *r = *c;
    }
    if (is_pointer) *(r++) = '_';
    for (i = 0; i < (is_pointer-implicit_ptr); i++, r++)
      *r = 'p';

    *r = 0;
    return result;
}

// This is kind of ugly but needed for each language to support a
// custom name mangling mechanism.  (ie. Perl5).

char *DataType::print_mangle() {

  // Call into target language for name mangling.
  return lang->type_mangle(this);
}
	
// --------------------------------------------------------------------
// TypeDefs
//
// Class for managing typedef declarations.
// --------------------------------------------------------------------
 
struct TypeDef {
  DataType  type;
  TypeDef   *next;
};

static    Hash   typedef_table;

TypeDef   td_head;
TypeDef   td_tail;
int       td_init = 0;

// -------------------------------------------------------------
// TypeDef_Init()
//
// Initializes the typedef system.
// -------------------------------------------------------------

void TypeDef_Init() {

  td_head.next = &td_tail;
  td_tail.next = &td_tail;
  td_init = 1;
}

// -------------------------------------------------------------
// Add_TypeDef(DataType *t, char *name, int mode)
//
// Maps the given name to a supplied datatype.
//
// For example :
//       %typedef unsigned int size_t
// Makes size_t behave like an unsigned int
//
// Mode determines how the typedef is added :
//      0 == Normal mode
//      1 == Only add symbol to the table.  Don't try to
//           to fill in the equivalence tables for type checking.
// -------------------------------------------------------------

void Add_TypeDef(DataType *t, char *name, int mode) {

  TypeDef  *td;
  char     name1[256];
  char     name2[256];
  DataType t1;

  void  Get_TypeDef(DataType *);   // Forward ref.
  void  TypeEq_AddTypeDef(char *, char *);

  if (!td_init) TypeDef_Init();

  // Check to see if this typedef already defined

  td = td_head.next;
  while (td != &td_tail) {
    if (strcmp(td->type.name, name) == 0) {
      fprintf(stderr,"%s : Line %d. Warning. Datatype %s already defined (2nd definition ignored).\n", input_file, line_number, name);
      return;
    }
    td = td->next;
  }

  td = new TypeDef;
  td->type = *t;
  td->type.implicit_ptr = t->is_pointer;   // Record if mapped type is a pointer
//  strcpy(td->type.name, name);   // Copy over the new name
  Get_TypeDef(&td->type);        // Resolve any other references to this type

  strcpy(td->type.name, name);   // Copy over the new name
  td->next = td_head.next;
  td_head.next = td;

  // Now add the type mapping to a Type Equivalency
  // Only do this if t is a non-void datatype.

  if (mode == 0) {
      if ((t->type != T_VOID) && (strcmp(t->name,name) != 0)) {
	strcpy(t1.name,name);
	sprintf(name2,"%s", t1.print_mangle());
	sprintf(name1,"%s", t->print_mangle());
	TypeEq_AddTypeDef(name1, name2);
	TypeEq_AddTypeDef(name2,name1);
      }
  }
}

// ---------------------------------------------------------------
// void Get_TypeDef(DataType *t)
//
// Looks up DataType t in the typedef list by doing a name match.
// If a match is found, changes type t to the corresponding type.
// Otherwise, returns the original datatype.
// ----------------------------------------------------------------

void Get_TypeDef(DataType *t) {

  TypeDef   *td;
  if (!td_init) return;     // No typedefs initialized

  td = td_head.next;
  while (td != &td_tail) {
    if (strcmp(td->type.name, t->name) == 0) {
      // Have a match, replace datatype t with new one
      t->type = td->type.type;
      t->is_pointer += td->type.is_pointer;
      t->implicit_ptr += td->type.implicit_ptr;
      strcpy(t->name, td->type.name);
      return;
    }
    td = td->next;
  }
  // Not found, return type as is.
  return;
}


// -------------------------------------------------------------
// Class equivalency lists
// 
// These are used to keep track of which datatypes are equivalent.
// This information can be dumped in tabular form upon completion
// for use in the pointer type checker.
// --------------------------------------------------------------

struct EqEntry {
  char *name;
  EqEntry *next;
};

struct TypeEq {
  char     *name;
  EqEntry  *eq_list;
  TypeEq   *next;
};

TypeEq    te_head;
TypeEq    te_tail;
static int  te_init = 0;

   

// -------------------------------------------------------------
// TypeEq_Init()
//
// Initializes the type equivalency list
// -------------------------------------------------------------

void TypeEq_Init() {
  te_head.next = &te_tail;
  te_tail.next = &te_tail;
  te_init = 1;
}

// --------------------------------------------------------------
// TypeEq_Add(char *name, char *eqname) 
//
// Add a new name to the equivalency list.
// Creates a new entry if it doesn't exist.
// --------------------------------------------------------------

void TypeEq_Add(char *name, char *eqname) {
  TypeEq *l;
  EqEntry *e;
  void TypeEq_Standard();

  if (!te_init) {
    TypeEq_Init();
    TypeEq_Standard();
  }

  if (strcmp(name,eqname) == 0) return;   // If they're the same, forget it.
  
  // Search for a match

  l = te_head.next;
  while (l != &te_tail) {
    if (strcmp(l->name, name) == 0) break;
    l = l->next;
  }
  
  if (l == &te_tail) {
    // Create a new entry
    l = new TypeEq;
    l->name = copy_string(name);
    l->eq_list = 0;
    l->next = te_head.next;
    te_head.next = l;
  }

  // Add new type to the list

  // We'll check to see if it's already been added

  e = l->eq_list;
  while (e) {
    if (strcmp(e->name, eqname) == 0) return;
    e = e->next;
  }

  e = new EqEntry;
  e->name = copy_string(eqname);
  e->next = l->eq_list;
  l->eq_list = e;

}

// --------------------------------------------------------------
// TypeEq_AddTypeDef(char *name, char *eqname) 
//
// Add a new name to the equivalency list.
// Creates a new entry if it doesn't exist.
// 
// --------------------------------------------------------------

void TypeEq_AddTypeDef(char *name, char *eqname) {
  TypeEq *l;
  EqEntry *e;
  void TypeEq_Standard();

  if (!te_init) {
    TypeEq_Init();
    TypeEq_Standard();
  }

  // Search for a match

  l = te_head.next;
  while (l != &te_tail) {
    if (strcmp(l->name, name) == 0) break;
    l = l->next;
  }
  
  if (l == &te_tail) {
    // Create a new entry
    l = new TypeEq;
    l->name = copy_string(name);
    l->eq_list = 0;
    l->next = te_head.next;
    te_head.next = l;
  }

  // Add new type to the list

  // We'll check to see if it's already been added

  e = l->eq_list;
  while (e) {
    if (strcmp(e->name, eqname) == 0) return;
    e = e->next;
  }

  // Add it to our list
  e = new EqEntry;
  e->name = copy_string(eqname);
  e->next = l->eq_list;
  l->eq_list = e;

  // Now walk down the list add make other equivalencies

  e = l->eq_list;
  while (e) {
    if (strcmp(e->name, eqname) != 0) {
      TypeEq_Add(e->name, eqname);
      TypeEq_Add(eqname, e->name);
    }
    e = e->next;
  }
}

// ----------------------------------------------------------------
// void emit_ptr_equivalence(FILE *f)
//
// Dump out the pointer equivalence table to file.
// ----------------------------------------------------------------

void emit_ptr_equivalence(char *tablename, FILE *f) {

  TypeEq   *l;
  EqEntry  *e;
  void TypeEq_Standard();
  char     name[256], *c;
  
  
  if (!te_init) {
    TypeEq_Init();
    TypeEq_Standard();
  }

  fprintf(f,"\
/*\n\
 * This is the pointer type-equivalence table. \n\
 * (Used by the SWIG pointer type-checker).\n\
 */\n");

    l = te_head.next;
    while (l != &te_tail) {
      if (l->eq_list) {
	sprintf(name,"%s",l->name);
	for (c = name; *c; c++) {
	  if (*c == ' ') *c = '_';
	}
	fprintf(f,"static char *%s_derived[] = { \"%s\", ", name, l->name); 
	// Now walk through the equivalency list
	e = l->eq_list;
	while (e) {
	  fprintf(f,"\"%s\",", e->name);
	  e = e->next;
	}
	fprintf(f,"0 };\n");
      }
      l = l->next;
    }

    fprintf(f,"static char **%s[] = {\n",tablename);
    l = te_head.next;
    while (l != &te_tail) {
      if (l->eq_list) {
	sprintf(name,"%s",l->name);
	for (c = name; *c; c++) {
	  if (*c == ' ') *c = '_';
	}
	fprintf(f,"\t %s_derived,\n", name);
      }
      l = l->next;
    }
    fprintf(f,"\t 0\n};\n\n");
}

// ------------------------------------------------------------------------------
// TypeEq_Standard(void)
//
// Generate standard type equivalences (well, pointers that can map into
// other pointers naturally).
// 
// -------------------------------------------------------------------------------

void TypeEq_Mangle(char *n1, char *n2) {
  DataType t,t1;
  char name[256];
  char name2[256];
  
  strcpy(t.name,n1);
  strcpy(t1.name,n2);
  sprintf(name,"%s", t.print_mangle());
  sprintf(name2,"%s", t1.print_mangle());
  TypeEq_Add(name,name2);
}
  
void TypeEq_Standard(void) {
  
  TypeEq_Mangle("int", "signed int");
  TypeEq_Mangle("int", "unsigned int");
  TypeEq_Mangle("signed int", "int");
  TypeEq_Mangle("unsigned int", "int");
  TypeEq_Mangle("short","signed short");
  TypeEq_Mangle("signed short","short");
  TypeEq_Mangle("short","unsigned short");
  TypeEq_Mangle("unsigned short","short");
  TypeEq_Mangle("long","signed long");
  TypeEq_Mangle("signed long","long");
  TypeEq_Mangle("long","unsigned long");
  TypeEq_Mangle("unsigned long","long");

}


    
