
/**********************************************************************
 * Simplified Wrapper and Interface Generator  (SWIG)
 * 
 * Dave Beazley
 * 
 * Theoretical Division (T-11)           Department of Computer Science
 * Los Alamos National Laboratory        University of Utah
 * Los Alamos, New Mexico  87545         Salt Lake City, Utah  84112
 * beazley@lanl.gov                      beazley@cs.utah.edu
 *
 * Copyright (c) 1995-1996
 * The Regents of the University of California and the University of Utah
 * All Rights Reserved
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that 
 * (1) The above copyright notice and the following two paragraphs
 * appear in all copies of the source code and (2) redistributions
 * including binaries reproduces these notices in the supporting
 * documentation.   Substantial modifications to this software may be
 * copyrighted by their authors and need not follow the licensing terms
 * described here, provided that the new terms are clearly indicated in
 * all files where they apply.
 * 
 * IN NO EVENT SHALL THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, THE 
 * UNIVERSITY OF UTAH OR DISTRIBUTORS OF THIS SOFTWARE BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
 * EVEN IF THE AUTHORS OR ANY OF THE ABOVE PARTIES HAVE BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR, THE UNIVERSITY OF CALIFORNIA, AND THE UNIVERSITY OF UTAH
 * SPECIFICALLY DISCLAIM ANY WARRANTIES,INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND 
 * THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE,
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * The author requests that all users of this software return any
 * improvements made to beazley@cs.utah.edu and grant the author
 * full redistribution rights.
 *
 **************************************************************************/
/***********************************************************************
 * $Header: /b11/dmb/SWIG/SWIG1.0/SWIG/RCS/wrapper.cxx,v 1.23 1996/08/21 16:48:40 dmb Exp $
 *
 * wrapper.c
 *
 * Some class member functions and miscellaneous stuff
 *
 * -- Revision History
 * $Log: wrapper.cxx,v $
 * Revision 1.23  1996/08/21 16:48:40  dmb
 * Minor cleanup to eliminate compiler warnings.
 *
 * Revision 1.22  1996/08/15 05:05:39  dmb
 * Minor changes
 *
 * Revision 1.21  1996/08/12 01:52:03  dmb
 * Minor changes and bug fixes
 *
 * Revision 1.20  1996/08/02 02:59:40  dmb
 * Changed parameter list functions
 *
 * Revision 1.19  1996/06/02 00:16:27  beazley
 * Minor fixes.
 *
 * Revision 1.18  1996/05/14  23:24:24  beazley
 * Added some stuff to support C++ better.
 *
 * Revision 1.17  1996/05/13  23:46:27  beazley
 * Added Update_Symbol() function
 *
 * Revision 1.16  1996/04/14  15:24:56  dmb
 * Fixed headers
 *
 * Revision 1.15  1996/04/10 16:37:07  beazley
 * Minor fix to get_time().
 *
 * Revision 1.14  1996/04/08  22:09:59  beazley
 * Minor cleanup
 *
 * Revision 1.13  1996/04/08  18:55:05  beazley
 * Added some functions to support constant expressions.
 *
 * Revision 1.12  1996/03/22  23:42:51  beazley
 * Cleaned up a few things.
 *
 * Revision 1.11  1996/03/16  06:29:55  beazley
 * Changed to work with new headers.
 *
 * Revision 1.10  1996/02/15  22:36:35  beazley
 * Minor changes. Changed copyright.
 *
 * Revision 1.9  1996/02/12  08:18:58  beazley
 * Took out main() and put into main.cc
 *
 * Revision 1.8  1996/02/07  06:07:28  beazley
 * Added some default values...options to set paths to other locations.
 *
 * Revision 1.7  1996/02/07  05:26:48  beazley
 * Added copyright notice
 *
 * Revision 1.5  1996/01/16  00:55:51  beazley
 * Fixed a few bugs
 *
 * Revision 1.4  1996/01/15  22:12:08  beazley
 * Added guile support
 *
 * Revision 1.3  1996/01/13  01:33:53  beazley
 * Added command line options for Perl or TCL
 *
 * Revision 1.2  1996/01/05  22:41:07  dmb
 * *** empty log message ***
 *
 * Revision 1.1  1995/12/30 04:34:04  dmb
 * Initial revision
 *
 *
 ***********************************************************************/

#include "internal.h"
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
// #include <fcntl.h>

// Construct a new parameter list

ParmList::ParmList() {
    head = new Pnode;
    z = new Pnode;
    head->next = z;
    z->next = z;
  };

// Delete this parameter list

ParmList::~ParmList() {
    Pnode *p = head->next;
    Pnode *p1;
    while (p != z) {
      p1 = p->next;
      delete p;
      p = p1;
    }
    delete head;
    delete z;
  }

// Make a copy of this parameter list

ParmList::ParmList(ParmList *l) {
  head = new Pnode;
  Pnode  *p, *np, *parent;
  z = new Pnode;
  z->next = z;
  parent = head;
  p = l->head->next;
  while (p != l->z) {
    np = new Pnode;
    np->p = p->p;
    parent->next = np;
    parent = np;
    p = p->next;
  }
  parent->next = z;
}

// --------------------------------------------------------------------
// ParmList::add_param(Parm *p)
//
// Adds parameter p to the parameter list.
// Assumes that parameters are added right to left!
// --------------------------------------------------------------------

void ParmList::add_param(Parm *p) {

  Pnode *pn;
  pn = new Pnode;
  pn->p = p;
  pn->next = head->next;
  head->next = pn;
}

// ---------------------------------------------------------------------
// Parm * ParmList::get_first()
//
// Returns the first item on a parameter list.
// ---------------------------------------------------------------------

Parm *ParmList::get_first() {
  Pnode *p;
  current = head->next;
  if (current == z) return 0;
  p = current;
  current = current->next;
  return p->p;
}

// ----------------------------------------------------------------------
// Parm *ParmList::get_next()
//
// Returns the next item on the parameter list.
// ----------------------------------------------------------------------

Parm * ParmList::get_next() {

  Pnode *p;
  if (current == z) return 0;
  p = current;
  current = current->next;
  return p->p;

}
// ---------------------------------------------------------------------
// void ParmList::print_types(FILE *f)
//
// Prints a comma separated list of all of the parameter types.
// This is for generating valid C prototypes.   Has to do some
// manipulation of pointer types depending on how the call_type
// variable has been set.
// ----------------------------------------------------------------------

void ParmList::print_types(FILE *f) {

  Pnode *pn;
  int   is_pointer;

  pn = head->next;
  while(pn != z) {
    is_pointer = pn->p->t->is_pointer;
    if (pn->p->t->is_reference) {
	pn->p->t->is_pointer--;
	fprintf(f,"%s&", pn->p->t->print_full());
	pn->p->t->is_pointer++;
    } else {
      if (pn->p->call_type & CALL_VALUE) pn->p->t->is_pointer++;
      if (pn->p->call_type & CALL_REFERENCE) pn->p->t->is_pointer--;
      fprintf(f,"%s", pn->p->t->print_full());
      pn->p->t->is_pointer = is_pointer;
    }
    if (pn->next != z)
      fprintf(f,",");
    pn = pn->next;
  }
}

// -------------------------------------------------------------------
// void ParmList::make_string(FILE *f)
//
// Makes a string containing the parameters of a function
// -----------------------------------------------------------------

void ParmList::make_string(FILE *f)
{
  Pnode *pn;
  pn = head->next;
  while (pn != z) {
    if (pn->p->name == 0) fprintf(f,"%s",pn->p->t->print_type());
    else {
      if (strlen(pn->p->name) > 0)
	fprintf(f,"%s",pn->p->name);
      else
	fprintf(f,"%s",pn->p->t->print_type());
    }
    if (pn->next != z)
      fprintf(f,",");
    pn = pn->next;
  }
}

//-----------------------------------------------------------------
// Return current time as a character string
//-----------------------------------------------------------------

char *
get_time()
{
    time_t            ltime;
    time(&ltime);
    return ctime(&ltime);
}

//-----------------------------------------------------------------
// make_wrap_name(char *s)
//
// Takes the name at src, and converts it into a syntactically
// valid identifier name.   This is a hack to get the wrapper
// generator to support class member functions and other things.
//
// ie.  We can define a function name as obj->foo(),
// but we'll need to call the wrapper function something like
// _wrap_obj__foo()
//-----------------------------------------------------------------

void make_wrap_name(char *s) {

  char *c1 = s;
  int  i;

  for (i = 0; i < (int) strlen(s); i++, c1++) {
    if(!isalnum(*c1)) *c1 = '_';
  }
}

// ----------------------------------------------------------------
// Symbol table management functions
//
// ----------------------------------------------------------------

struct   Symbol {
  ~Symbol() {
    if (name) delete name;
    if (type) delete type;
    if (value) delete value;
  }
  char      *name;
  DataType  *type;        // Optional datatype
  char      *value;       // Optional value (for constant expressions)
};

static Hash    SymHash;   // SWIG Symbol table

//-----------------------------------------------------------------
// int Add_Symbol(char *name, DataType *type, char *value)
//
// Add symbol to table.  Returns 0 if successful, -1 is symbol already
// exists in the table.
//-----------------------------------------------------------------

int Add_Symbol(char *name, DataType *type, char *value) {

  Symbol *s;
  int ret;
  
  s = new Symbol;
  s->name = copy_string(name);
  if (type)
    s->type = new DataType(type);
  else s->type = (DataType *) 0;
  if (value) 
    s->value = copy_string(value);
  else s->value = (char *) 0;

  // Add this to the symbol table

  ret = SymHash.add(s->name, s);
  if (ret == -1) {
    delete s;
  } 
  return ret;
}

int Lookup_Symbol(char *name) {
  Symbol *s;

  s = (Symbol *) SymHash.lookup(name);
  if (s) return 1;
  else return 0;
}

DataType *Lookup_SymType(char *name) {

  Symbol *s;

  s = (Symbol *) SymHash.lookup(name);
  if (s) return s->type;
  else return (DataType *) 0;
}

char *Lookup_SymValue(char *name) {

  Symbol *s;

  s = (Symbol *) SymHash.lookup(name);
  if (s) return s->value;
  else return (char *) 0;
}

//-----------------------------------------------------------------
// int Update_Symbol(char *name, DataType *type, char *value)
//
// Update a symbol (or create it) in the hash table.
// This is used to work around some scoping problems in C++.
//-----------------------------------------------------------------

int Update_Symbol(char *name, DataType *type, char *value) {

  Symbol *s;

  s = (Symbol *) SymHash.lookup(name);
  if (s) {
    if (s->type) delete s->type;
    if (s->value) delete s->value;
    if (type) 
      s->type = new DataType(type);
    else
      s->type = (DataType *) 0;
    if (value) 
      s->value = copy_string(value);
    else
      s->value = (char *) 0;
    return 0;
  } else {
    return Add_Symbol(name, type, value);
  }
}

// -----------------------------------------------------------------
//   Unimplemented language methods
// ----------------------------------------------------------------- 

void
Language::add_native(char *, char *funcname) {

  fprintf(stderr,"%s : Line %d.  Adding native function %s not supported (ignored).\n", input_file, line_number, funcname);

}



