//
// cpp_inherit.i
// This file tests SWIG handling of inheritance and virtual
// functions.
%module shape
%{

class Shape {
private:
	int count;
public:
        virtual ~Shape() { };
        Shape() { count = 1;}
        void ref() { count++;}
	void deref() { count--; if (!count) delete this; }
        int  get_ref() { return count;}
	int  color;
virtual void print() = 0;
        char *name;


};

class TwoD : public Shape {
private:
	double x,y;
public:
        ~TwoD() { };
	void set_center(double _x, double _y) {x = _x; y= _y;}
virtual double  area() = 0;
virtual double  perimeter() = 0;
virtual void    print() = 0;
  void print_center() { printf("x = %g, y = %g\n", x, y);}
};

class ThreeD : public Shape {
private:
	double x,y,z;
public:
  ~ThreeD() { };
  void set_center(double _x, double _y, double _z) {
    x= _x; y = _y; z = _z;
  }
  virtual double volume() = 0;
  virtual double surface() = 0;
  virtual void print() = 0;
  void print_center() { printf("x = %g, y = %g, z= %g\n", x, y, z);}
};

class Circle : public TwoD {
private:
  double radius;
public:
  Circle(double _r) { radius = _r; name = "Circle";}
  double area() { return 3.1415926*radius*radius;}
  double perimeter() {return 2*3.1415926*radius;}
  void   print() { printf("Circle : radius = %g\n", radius);}
};

class Square : public TwoD {
private:
  double width;
public:
  Square(double _w) { width = _w; name = "Square";}
  double area() {return width*width;}
  double perimeter() {return 4*width;}
  void   print() {printf("Square : width = %g\n", width);}
};

class Sphere : public ThreeD {
private:
  double radius;
public:
  Sphere(double _r) { radius = _r; name = "Sphere";}
  double volume() {return (4.0/3)*3.1415926*radius*radius*radius;}
  double surface() {return 4*3.1415926*radius*radius;}
  void   print() {printf("Sphere : radius = %g\n", radius);}
};

class Cube : public ThreeD {
private:
  double width;
public:
  Cube(double _w) {width = _w; name = "Cube";}
  double volume() {return width*width*width;}
  double surface() {return 6*width*width;}
  void print() {printf("Cube : width = %g\n", width);}
};


%}

class Shape {
public:
virtual ~Shape();
  void ref();
  void deref();
  int  get_ref();
  int  color;
virtual void print() = 0;
  char *name;
};

class TwoD : public Shape {
public:
  void set_center(double _x, double _y);
  virtual double  area() = 0;
  virtual double  perimeter() = 0;
  virtual void    print() = 0;
  void print_center();
};

class ThreeD : public Shape {
public:
  void set_center(double _x, double _y, double _z);
  virtual double volume() = 0;
  virtual double surface() = 0;
  virtual void print() = 0;
  void print_center();
};

class Circle : public TwoD {
public:
  Circle(double _r);
  double area();
  double perimeter();
  void   print();
};

class Square : public TwoD {
public:
  Square(double _w);
  double area();
  double perimeter();
  void   print();
};

class Sphere : public ThreeD {
public:
  Sphere(double _r);
  double volume();
  double surface();
  void   print();
};

class Cube : public ThreeD {
public:
  Cube(double _w);
  double volume();
  double surface();
  void print();
};
			
