
//
// function.i
// SWIG interface file to test basic C function declarations
//
%module function
%{

/* Define some C functions to test */

void hello(void) { printf("hello world.\n"); }

int            sum_int(int a, int b)              { return a+b;}
short          sum_short(short a, short b)        { return a+b;}
long           sum_long(long a, long b)           { return a+b;}
unsigned int   sum_uint(unsigned int a, unsigned int b)   {return a+b;}
unsigned short sum_ushort(unsigned short a, unsigned short b) {return a+b;}
unsigned long  sum_ulong(unsigned long a, unsigned long b) {return a+b;}
unsigned char  sum_uchar(unsigned char a, unsigned char b) {return a+b;}
signed int     sum_sint(signed int a, signed int b) {return a+b;}
signed short   sum_sshort(signed short a, signed short b) {return a+b;}
signed long    sum_slong(signed long a, signed long b) {return a+b;}
signed char    sum_schar(signed char a, signed char b) {return a+b;}
float          sum_float(float a, float b)             {return a+b;}
double         sum_double(double a, double b)          {return a+b;}


void prints(char *s) {printf("%s\n",s); }
void printc(char c) {printf("character : %c\n", c); }

/* Now some pointer variables to test */

int              *sum_pint(int *a, int *b) { *a += *b; return a;}
short            *sum_pshort(short *a, short *b) { *a += *b; return a;}
long             *sum_plong(long *a, long *b) { *a += *b; return a;}
unsigned int     *sum_puint(unsigned int *a, unsigned int *b) { *a += *b; return a;}
unsigned short   *sum_pushort(unsigned short *a, unsigned short *b) { *a += *b; return a;}
unsigned long    *sum_pulong(unsigned long *a, unsigned long *b) { *a += *b; return a;}
unsigned char    *sum_puchar(unsigned char *a, unsigned char *b) { *a += *b; return a;}
signed int       *sum_psint(signed int *a, signed int *b) { *a += *b; return a;}
signed short     *sum_psshort(signed short *a, signed short *b) { *a += *b; return a;}
signed long      *sum_pslong(signed long *a, signed long *b) { *a += *b; return a;}
signed char      *sum_pschar(signed char *a, signed char *b) { *a += *b; return a;}
float            *sum_pfloat(float *a, float *b) { *a += *b; return a;}
double           *sum_pdouble(double *a, double *b) { *a += *b; return a;}
void             *incr_ptr(void *a, int incr) {return a + incr;}

/* Now some complex data types */

typedef struct Vector {
	double x,y,z;
} Vector;

Vector *         new_Vector(double x, double y, double z) {
	Vector *r;
	r = (Vector *) malloc(sizeof(Vector));
	r->x = x;
	r->y = y;
	r->z = z;
	return r;
}

void print_Vector(Vector *v) {
	printf("x = %g, y = %g, z = %g\n", v->x,v->y,v->z);
}

Vector addv(Vector v1, Vector v2) {
	Vector v3;
	v3.x = v1.x + v2.x;
	v3.y = v1.y + v2.y;
	v3.z = v1.z + v2.z;
	return v3;
}

int  *new_int(int a) { int *r; r = (int *) malloc(sizeof(int)); *r = a; return r;}
short *new_short(short a) { short *r; r = (short *) malloc(sizeof(short)); *r = a; return r;}
long *new_long(long a) { long *r; r = (long *) malloc(sizeof(long)); *r = a; return r;}
unsigned int *new_uint(unsigned int a) { unsigned int *r; r = (unsigned int *) malloc(sizeof(unsigned int)); *r = a; return r;}
unsigned short *new_ushort(unsigned short a) { unsigned short *r; r = (unsigned short *) malloc(sizeof(unsigned short)); *r = a; return r;}
unsigned long *new_ulong(unsigned long a) { unsigned long *r; r = (unsigned long *) malloc(sizeof(unsigned long)); *r = a; return r;}
unsigned char *new_uchar(unsigned char a) { unsigned char *r; r = (unsigned char *) malloc(sizeof(unsigned char)); *r = a; return r;}
signed int *new_sint(signed int a) { signed int *r; r = (signed int *) malloc(sizeof(signed int)); *r = a; return r;}
signed short *new_sshort(signed short a) { signed short *r; r = (signed short *) malloc(sizeof(signed short)); *r = a; return r;}
signed long *new_slong(signed long a) { signed long *r; r = (signed long *) malloc(sizeof(signed long)); *r = a; return r;}
signed char *new_schar(signed char a) { signed char *r; r = (signed char *) malloc(sizeof(signed char)); *r = a; return r;}

float *new_float(float a) { float *r; r = (float *) malloc(sizeof(float)); *r = a; return r;}
double *new_double(double a) { double *r; r = (double *) malloc(sizeof(double)); *r = a; return r;}

%}

// Now SWIG it

char *getenv(char *envvar);

void hello(void);

int            sum_int(int a, int b);
short          sum_short(short a, short b);
long           sum_long(long a, long b);
unsigned int   sum_uint(unsigned int a, unsigned int b);
unsigned short sum_ushort(unsigned short a, unsigned short b);
unsigned long  sum_ulong(unsigned long a, unsigned long b);
unsigned char  sum_uchar(unsigned char a, unsigned char b);
signed int     sum_sint(signed int a, signed int b);
signed short   sum_sshort(signed short a, signed short b);
signed long    sum_slong(signed long a, signed long b);
signed char    sum_schar(signed char a, signed char b);
float          sum_float(float a, float b);
double         sum_double(double a, double b);


void prints(char *s);
void printc(char c);

/* Now some pointer variables to test */

int              *sum_pint(int *a, int *b);
short            *sum_pshort(short *a, short *b);
long             *sum_plong(long *, long *b);
unsigned int     *sum_puint(unsigned int *a, unsigned int *b);
unsigned short   *sum_pushort(unsigned short *a, unsigned short *b);
unsigned long    *sum_pulong(unsigned long *a, unsigned long *b);
unsigned char    *sum_puchar(unsigned char *a, unsigned char *b);
signed int       *sum_psint(signed int *a, signed int *b);
signed short     *sum_psshort(signed short *a, signed short *b);
signed long      *sum_pslong(signed long *a, signed long *b);
signed char      *sum_pschar(signed char *a, signed char *b);
float            *sum_pfloat(float *a, float *b);
double           *sum_pdouble(double *a, double *b);
void             *incr_ptr(void *a, int incr);

Vector *  new_Vector(double x, double y, double z);
void print_Vector(Vector *v);
Vector addv(Vector v1, Vector v2);
int  *new_int(int a);
short *new_short(short a);
long *new_long(long a);
unsigned int *new_uint(unsigned int a);
unsigned short *new_ushort(unsigned short a);
unsigned long *new_ulong(unsigned long a);
unsigned char *new_uchar(unsigned char a);
signed int *new_sint(signed int a);
signed short *new_sshort(signed short a);
signed long *new_slong(signed long a);
signed char *new_schar(signed char a);

float *new_float(float a);
double *new_double(double a);
void *malloc(int);


