//
// lang.c
// This file tests SWIG's ability to handle an external language.
// When compiled and linked with the SWIG parser, no C code should
// be produced whatsoever.
//
#include "swig.h"

/* ------------------------------------------------------------------------
 * Language Template
 *
 * This file contains a template that you can follow to make SWIG support
 * a new target language.
 * ------------------------------------------------------------------------ */
class LANG : public Language {
private:
  char   *package;   
  char   *path;      
public :
  LANG() {
    package = 0; 
    path = "user";   
                     
  };
  void parse_args(int, char **) { };
  void parse() { };
  void create_function(char *, char *, DataType *, ParmList *) { };
  void link_variable(char *, char *, DataType *) { };
  void declare_const(char *, DataType *, char *) { };
  void initialize() { };
  void set_module(char *) { };
  void set_init(char *) { };
  void headers(void) { };
  void close(void) { };
  void usage_var(char *, DataType *, char **) { };
  void usage_func(char *, DataType *, ParmList *, char **) { } ;
  void usage_const(char *, DataType *, char *, char **) { };
#ifdef NOCPP
  void cpp_member_func(char *name, char *iname, DataType *t, ParmList *l) { };
  void cpp_constructor(char *name, char *iname, ParmList *l) { };
  void cpp_destructor(char *name, char *newname) { };
  void cpp_open_class(char *classname, char *rname, char *ctype) { };
  void cpp_close_class() { };
  void cpp_cleanup() { };
  void cpp_inherit(char *baseclass) { };
  void cpp_variable(char *name, char *iname, DataType *t) { };
  void cpp_static_func(char *name, char *iname, DataType *t, ParmList *l) { };
  void cpp_declare_const(char *name, char *iname, int type, char *value) { };
  void cpp_static_var(char *name, char *iname, DataType *t) { };
#endif

};

int main(int argc, char **argv) {

  Language *lang;

  /* Create a new instance of your language class */

  lang = new LANG;
  SWIG_main(argc, argv, lang, (Documentation *) 0);
  return 0;
}

  
