//
// typedef.i
// This file tests SWIG's typedef facility
%module typedefs
%{

typedef double Real;
typedef Real   Double;
typedef double * Array;

double * new_Array(int size) {
	return (double *) malloc(size*sizeof(double));
}

Double get_n(Array a, int n) {
	return a[n];
}

Real set_n(Real *a, int n, Real value) {
	a[n] = value;
}

void print_Array(Array a, int n) {
	int i;
	for (i = 0; i < n; i++) 
	  printf("a[%d] = %g\n", i, a[i]);
}

%}
typedef double Real;
typedef Real   Double;
typedef double * Array;

Double *new_Array(int size);
double get_n(double *a, int n);
Real set_n(Real *a, int n, Real value);
void print_Array(Double *a, int n);
void free(void *);

//
// Should generate a error/warning for redefined type
typedef  GLfloat Real;

//
// Should generate a warning about undefined datatype
typedef  GLfloat Myfloat;

// Should be okay

typedef Real GLdouble;
typedef GLdouble Mydouble;

// Test a bunch of equivalent types

typedef  int   int1;
typedef  int   int2;
typedef  int   int3;
typedef  int   int4;
typedef  int4  int5;
typedef  int5  int6;
typedef  int6  int7;
typedef  int3  int8;

// Do a typedef'd function pointer.

typedef int (*PFI)(int,double);
typedef double ***(*PFD)(double);

void set_callback(PFI if, PFD df);

// More complicated typedef

typedef struct Vector {
	double x;
	double y;
	double z;
} Vector;

