//
// $Header: /b11/dmb/SWIG/SWIG1.0/swig_lib/RCS/timers.i,v 1.1 1996/05/22 17:27:01 beazley Exp dmb $
//
// timers.i
// A SWIG file for adding various timing functions. 
// Really, this is modeled after the timers in the CMMD
// message passing library for the CM-5.
// 
// Dave Beazley
// April 2, 1996
//
/* Revision history 
 * $Log: timers.i,v $
 * Revision 1.1  1996/05/22 17:27:01  beazley
 * Initial revision
 *
 */

%module timers
%{

#include <time.h>
#define  SWIG_NTIMERS     64

static clock_t  telapsed[SWIG_NTIMERS];
static clock_t  tstart[SWIG_NTIMERS];
static clock_t  tend[SWIG_NTIMERS];

/*-----------------------------------------------------------------
 * SWIG_timer_clear(int i)
 *
 * Clears timer i.
 *----------------------------------------------------------------- */

void
SWIG_timer_clear(int i)
{
  if ((i >= 0) && (i < SWIG_NTIMERS))
   telapsed[i] = 0;
}


/*-----------------------------------------------------------------
 * SWIG_timer_start(int i)
 *
 * Starts timer i
 *----------------------------------------------------------------- */

void
SWIG_timer_start(int i)
{
  if ((i >= 0) && (i < SWIG_NTIMERS))
    tstart[i] = clock();
}


/*-----------------------------------------------------------------
 * SWIG_timer_stop(int i)
 *
 * Stops timer i and accumulates elapsed time
 *----------------------------------------------------------------- */

void
SWIG_timer_stop(int i)
{
  if ((i >= 0) && (i < SWIG_NTIMERS)) {
    tend[i] = clock();
    telapsed[i] += (tend[i] - tstart[i]);
  }
}

/*-----------------------------------------------------------------
 * SWIG_timer_elapsed(int i)
 *
 * Returns the time elapsed on timer i in seconds.
 *----------------------------------------------------------------- */

double
SWIG_timer_elapsed(int i)
{
  double   t;
  if ((i >= 0) && (i < SWIG_NTIMERS)) {
    t = (double) telapsed[i]/(double) CLOCKS_PER_SEC;
    return(t);
  } else {
    return 0;
  }
}

%}

%section "SWIG Timing Functions"

#define  SWIG_NTIMERS     64
void SWIG_timer_clear(int n);   // Clears timer n
void SWIG_timer_start(int n);   // Starts timer n
void SWIG_timer_stop(int n);    // Stops timer n
double SWIG_timer_elapsed(int n); // Returns number of seconds elapsed on timer n



