
#include <stdio.h>
#include <Xm/MessageB.h>
#include <Xm/List.h>

char *fallbackResources[] = {
	"*list.visibleItemCount: 10",
	"*msg.okLabelString: Quit",
	"*send.labelString: Send",
	"*clear.labelString: Clear",
	NULL
    };

XtInputId inputID;
Widget msg, list;

void
inputReady(client_data, source, id)
    XtPointer client_data;
    int *source;
    XtInputId *id;
{
    XmString xmstr;
    char s[1024];

    if (gets(s) == NULL) {
	XtRemoveInput(*id);
	return;
    }

    xmstr = XmStringCreateSimple(s);
    XmListAddItem(list, xmstr, 0);
}

void
exitCB(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    exit(0);
}

void
sendSelection(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    XmStringTable items;

    XtVaGetValues(list, XmNselectedItems, &items);
    puts((char *) items);
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    Widget label;
    XtAppContext app;
    Widget toplevel;
    Arg args[10];
    int n = 0;

    toplevel = XtAppInitialize(&app, "XmSend", NULL, 0, &argc, argv,
				fallbackResources, NULL, 0);


    n = 0;
    XtSetArg(args[n], XmNdialogType, XmDIALOG_MESSAGE); n++;
    msg = XmCreateMessageBox(toplevel, "msg", args, n);
    XtManageChild(msg);
    XtAddCallback(msg, XmNokCallback, exitCB, NULL);

    n = 0;
    XtSetArg(args[n], XmNselectionPolicy, XmSINGLE_SELECT); n++;
    list = XmCreateScrolledList(msg, "list", args, n);
    XtManageChild(list);
    XtAddCallback(list, XmNsingleSelectionCallback, sendSelection, NULL);
    XtAddCallback(list, XmNdefaultActionCallback, sendSelection, NULL);

    XtRealizeWidget(toplevel);

    inputID = XtAppAddInput(app, 0, XtInputReadMask, inputReady, NULL);

    XtAppMainLoop(app);
}
