proc ButtonEditorProc {} {
global beparent be xf bcomm bargs bindex

set xf(be_on) 1
if [winfo exists .button_edit] {
wm deiconify .button_edit
raise .button_edit
return
}
set xf(editmode) 1
set be(editedi) 0
source $xf(main_pophelp_file)
source $xf(user_pophelp_file)
if ![info exists xf(Help.Version)] {
ConvertHelp
} elseif {$xf(Help.Version) != 2} {
ConvertHelp
}

SetCnfMenuBg
BE_UnSetTrace

set be(gludge) 1
set be(txt) {}
set be(cmdtxt) Execute
set be(cmdarg) {}
set be(style) {-relief raised -bd 3}
set be(editmode) "Advanced..."
set be(font) default
set be(colormode) {-fg}
set be(confirm) 0
set be(dialog) 0
set be(win) 0
set be(update) 0
set be(bg) 0

set beparent [toplevel .button_edit  -height 150 -width 500]
wm geometry $beparent +100+100
frame $beparent.entframe -relief groove -bd 3 -height 60 -width 500

set bemfont "*helvetica-bold-r-*-*-12*"
frame $beparent.menu -relief raised -borderwidth 1
menubutton $beparent.menu.toolmenu -text Tools \
-menu $beparent.menu.toolmenu.m\
-underline 0 -height 1 -font $bemfont
menu $beparent.menu.toolmenu.m
$beparent.menu.toolmenu.m add command -label "Put Button"  \
-underline 0 -command PutButton -state disabled
$beparent.menu.toolmenu.m add separator
$beparent.menu.toolmenu.m add command -label "Write Help"  \
-underline 0 -command {WriteHelp}
message $beparent.menu.msg -text "Please, CLICK the ActionButton \
You want to edit.." -fg "#a00000" -width 400 -anchor center \
-justify center
frame $beparent.entframe.up
frame $beparent.entframe.up.0
frame $beparent.entframe.up.1
frame $beparent.entframe.up.2
frame $beparent.entframe.up.separator -relief flat  -bd 2 -width 4
frame $beparent.entframe.up.3 -relief sunken  -bd 1

label $beparent.entframe.up.0.txtmsg -text "Button label:"
entry $beparent.entframe.up.1.txtentry -textvariable be(txt) -width 13

frame $beparent.entframe.fc
checkbutton $beparent.entframe.fc.chkcfr -text "Confirm" -bd 2 \
-relief ridge\
-onvalue "C" -offvalue "" -variable be(confirm)
checkbutton $beparent.entframe.fc.chkdia -text "Dialog" -bd 2 -relief ridge\
-onvalue "D" -offvalue "" -variable be(dialog)
checkbutton $beparent.entframe.fc.chkwin -text "OutputWin" -bd 2 \
-relief ridge\
-onvalue "W" -offvalue "" -variable be(win)
checkbutton $beparent.entframe.fc.chkupd -text "Update" -bd 2 -relief ridge\
-onvalue "U" -offvalue "" -variable be(update)

label $beparent.entframe.up.0.cmdmsg -text "Command:"
menubutton $beparent.entframe.up.1.cmdmb -textvariable be(cmdtxt) -menu \
$beparent.entframe.up.1.cmdmb.cmdmenu  -relief raised\
-indicatoron true -width 8 -justify left
set cm [menu $beparent.entframe.up.1.cmdmb.cmdmenu -tearoff 1]

$cm add radio -label Execute -variable be(cmdtxt) \
-command [list BE_Hack exec pack pack] \
-value Execute

$cm add separator

$cm add radio -label ChangeDir -variable be(cmdtxt) \
-command [list BE_Hack {ChangeDir %s} pack] \
-value ChangeDir

$cm add radio -label Copy -variable be(cmdtxt) \
-command [list BE_Hack {FileOps cp %s}] \
-value Copy

$cm add radio -label CopyAs -variable be(cmdtxt) \
-command [list BE_Hack {CopyAs %s}] \
-value CopyAs

$cm add radio -label Delete -variable be(cmdtxt) \
-command [list BE_Hack {FileOps rm %s}] \
-value Delete

$cm add radio -label DirSize -variable be(cmdtxt) \
-command [list BE_Hack {DirSize %s}] \
-value DirSize

$cm add radio -label Grep -variable be(cmdtxt) \
-command [list BE_Hack {Grep %s}] \
-value Grep

$cm add radio -label MakeDir -variable be(cmdtxt) \
-command [list BE_Hack {MkDir %s}] \
-value MakeDir

$cm add radio -label Mount -variable be(cmdtxt) \
-command [list BE_Hack {Mount %s} pack] \
-value Mount

$cm add radio -label Move -variable be(cmdtxt) \
-command [list BE_Hack {FileOps mv %s}] \
-value Move

$cm add radio -label PatternSel -variable be(cmdtxt) \
-command [list BE_Hack {PatternSelect %s}] \
-value PatternSel

$cm add radio -label ProtEdit -variable be(cmdtxt) \
-command [list BE_Hack {ProtEditor %s}] \
-value ProtEdit

$cm add radio -label ReadFiles -variable be(cmdtxt) \
-command [list BE_Hack {ReadFiles %s %f}] \
-value ReadFiles

$cm add radio -label Rename -variable be(cmdtxt) \
-command [list BE_Hack {Rename %s}] \
-value Rename

$cm add radio -label VirtualTar -variable be(cmdtxt) \
-command [list BE_Hack {VirtualTar %f %s}] \
-value VirtualTar

$cm add radio -label VirtualZip -variable be(cmdtxt) \
-command [list BE_Hack {VirtualZip %f %s}] \
-value VirtualZip

checkbutton $beparent.entframe.up.2.bg -text "Background" -variable be(bg)\
-onvalue "&" -offvalue ""
entry $beparent.entframe.up.2.cmdentry -textvariable be(cmdarg) -width 20

frame $beparent.middle
button $beparent.middle.advbutt -textvariable be(editmode)\
-width 10 -command ChEditMode

message $beparent.entframe.up.3.label -aspect 200 \
-text "                                               "

eval {menubutton $beparent.entframe.up.3.button -textvariable $be(txt) \
-width 6 -menu $beparent.entframe.up.3.button.stylemenu} $be(style)

set sm [menu $beparent.entframe.up.3.button.stylemenu -tearoff 1]

$sm add radio -label DefaultL -command { ButtonStyles {-bd 1 -bg #c8c8ee -relief raised -fg #000000 -activebackground #dcdcff -activeforeground Black -font -Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*}}

$sm add radio -label DefaultR -command {ButtonStyles {-bd 1 -bg #b7d5cc -relief raised -fg #000000 -activebackground #c2e7c8 -activeforeground Black -font -Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*}}

$sm add radio -label Flat -command {ButtonStyles {-relief flat \
-activebackground "#ececec" -cursor top_left_arrow}}

$sm add radio -label Ridge3 -command {ButtonStyles {-relief ridge -bd 3 \
-activebackground "#ececec" -cursor top_left_arrow}}

$sm add radio -label Groove3 -command {ButtonStyles {-relief groove -bd 3 \
-activebackground "#ececec" -cursor top_left_arrow}}

$sm add radio -label Sunken3 -command {ButtonStyles {-relief sunken -bd 3 \
-activebackground "#ececec" -cursor top_left_arrow }}

$sm add radio -label Raised2 -command {ButtonStyles {-relief raised -bd 2 \
-activebackground "#ececec" -cursor top_left_arrow}}

$sm add radio -label Raised1 -command {ButtonStyles {-relief raised -bd 1 \
-activebackground "#ececec" -cursor top_left_arrow}}

$sm add radio -label Warning -command {ButtonStyles {-relief raised -bd 3 \
-activebackground "#ffa0a0" -cursor pirate }}

$sm add radio -label Trek -command {ButttonStyles {-relief raised -bd 3 \
-activebackground "#ececec" -cursor trek}}

frame $beparent.bottom -relief groove -bd 3 -height 50 -width 500


frame $beparent.bottom.applyframe -relief sunken -bd 1 -height 34 -width 65
button $beparent.bottom.applyframe.apply -text Apply -command {
eval {ApplyProc $bindex}
} -state disabled
button $beparent.bottom.undo -text Undo -command UndoProc  -state disabled

button $beparent.bottom.save -text Save\
-command {ApplyProc $bindex; ButtonSave} -state disabled
button $beparent.bottom.close -text Close\
-command "BE_Close"

frame $beparent.adv -relief raised -bd 2
frame $beparent.adv.0 -relief ridge -bd 2
frame $beparent.adv.0.opt
frame $beparent.adv.0.args
frame $beparent.adv.0.opt.0
frame $beparent.adv.0.opt.1
frame $beparent.adv.1 -relief sunken -bd 2 -bg "#cacaca"
frame $beparent.adv.1.0  -bg "#cacaca"
frame $beparent.adv.1.0.sld -relief raised -bd 2
frame $beparent.adv.1.1 -bg "#cacaca"
label $beparent.adv.1.0.l1 -text RGB-sliders: -bg "#cacaca"
label $beparent.adv.1.1.l2 -text Property: -bg "#cacaca"

radiobutton $beparent.adv.1.1.rb1 -text "Text color" -value \
{-fg} -variable be(colormode)\
-indicatoron false -selectcolor "#dcdcdc" -width 10\
-command {SetScale}
radiobutton $beparent.adv.1.1.rb2 -text "Backgound" -value \
{-bg} -variable be(colormode)\
-indicatoron false -selectcolor "#dcdcdc" -width 10\
-command {SetScale}
radiobutton $beparent.adv.1.1.rb3 -text "Active Txt" -value \
{-activeforeground} -variable be(colormode)\
-indicatoron false -selectcolor "#dcdcdc" -width 10\
-command {SetScale}
radiobutton $beparent.adv.1.1.rb4 -text "Active BG" -value \
{-activebackground} -variable be(colormode)\
-indicatoron false -selectcolor "#dcdcdc" -width 10\
-command {SetScale}

frame $beparent.adv.1.1.cf -relief sunken -bd 1 -width 80 -height 45

scale $beparent.adv.1.0.sld.rslider -orient vertical -from 255 -to 0\
-resolution 1\
-length 4c -fg "#af3030" -variable be(red) -command {ChColor ;\
set be(red) }
scale $beparent.adv.1.0.sld.gslider -orient vertical -from 255 -to 0\
-resolution 1\
-length 4c -fg "#30af30" -variable be(green) -command {ChColor ;\
set be(green) }
scale $beparent.adv.1.0.sld.bslider -orient vertical -from 255 -to 0\
-resolution 1\
-length 4c -fg "#3030af" -variable be(blue) -command {ChColor ;\
set be(blue) }

label $beparent.adv.0.opt.0.cmblabel -text Cursor:
menubutton $beparent.adv.0.opt.0.cmb  -textvariable be(cursor) -relief raised\
-menu $beparent.adv.0.opt.0.cmb.cm -indicatoron true -width 6
set cm [menu $beparent.adv.0.opt.0.cmb.cm -tearoff 1]

$cm add command -label "default " -command \
{set be(cursor) {default};\
SetButtonStyle -cursor top_left_arrow }
$cm add command -label \x26\x3a -font cursor  -command \
{set be(cursor) {hand1};\
SetButtonStyle -cursor hand1 }
$cm add command -label \x26\x3e -font cursor  -command \
{set be(cursor) {heart};\
SetButtonStyle -cursor heart }
$cm add command -label \x26\x58 -font cursor  -command \
{set be(cursor) {pirate};\
SetButtonStyle -cursor pirate }
$cm add command -label \x26\x56 -font cursor  -command \
{set be(cursor) {pencil};\
SetButtonStyle -cursor pencil }
$cm add command -label \x26\x8e -font cursor  -command \
{set be(cursor) {trek};\
SetButtonStyle -cursor trek }

label $beparent.adv.0.opt.1.rmblabel -text Relief:
menubutton $beparent.adv.0.opt.1.rmb -textvariable be(relief) -relief raised\
-menu $beparent.adv.0.opt.1.rmb.rm -indicatoron true -width 6
set cm [menu $beparent.adv.0.opt.1.rmb.rm -tearoff 1]

$cm add command -label "Raised" -command \
{set be(relief) {raised };\
SetButtonStyle -relief raised }
$cm add command -label "Sunken" -command \
{set be(relief) {sunken };\
SetButtonStyle -relief sunken }
$cm add command -label "Groove" -command \
{set be(relief) {groove };\
SetButtonStyle -relief groove }
$cm add command -label "Ridge" -command \
{set be(relief) {ridge };\
SetButtonStyle -relief ridge }
$cm add command -label "Flat" -command \
{set be(relief) {flat };\
SetButtonStyle -relief flat }

label $beparent.adv.0.opt.0.fmblabel -text Font:
menubutton $beparent.adv.0.opt.0.fmb -textvariable be(font) -relief raised\
-menu $beparent.adv.0.opt.0.fmb.fm -indicatoron true -width 6
set cm [menu $beparent.adv.0.opt.0.fmb.fm -tearoff 1]

$cm add command -label "Default" -command \
{set be(font) {Default };\
SetButtonStyle \
-font -Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*}
$cm add command -label "Fixed" -command \
{set be(font) {Fixed };\
SetButtonStyle -font fixed }
$cm add command -label "Helvet" -command \
{set be(font) {Helvet};\
SetButtonStyle -font *helvetica* }
$cm add command -label "Times" -command \
{set be(font) {Times };\
SetButtonStyle -font *Times* }
$cm add command -label "Lucida" -command \
{set be(font) {Lucida};\
SetButtonStyle -font *lucida* }
$cm add command -label "Utopia" -command \
{set be(font) {Utopia};\
SetButtonStyle -font *utopia* }
$cm add separator
$cm add command -label "Other..." -command \
{set be(font) {Other}; \
SetButtonStyle -font [SelectFont [.button_edit.entframe.up.3.button cget -font]]}

label $beparent.adv.0.opt.1.bdlabel -text Borderwidth:
scale $beparent.adv.0.opt.1.bds -from 0 -to 5 -orient horizontal\
-width 10 -length 70 -variable be(bd) -showvalue false -command\
{SetButtonStyle -bd}

label $beparent.adv.0.args.arglabel -text "Button arguments:"
entry $beparent.adv.0.args.argentry -textvariable be(style) -width 24

wm title $beparent "ButtonEditor v1.1 "
wm resizable $beparent 0 0

pack  $beparent.menu -side top -fill x
pack $beparent.entframe.up -side top  -fill both
pack $beparent.entframe.up.0 -side left -fill both
pack $beparent.entframe.up.1 -side left -fill both
pack $beparent.entframe.up.2 -side left -fill both
pack $beparent.entframe.up.3 -side right -fill both
pack $beparent.entframe.up.separator -side right -fill both -padx 5
pack $beparent.entframe.up.0.txtmsg -side top -anchor nw
pack $beparent.entframe.up.0.cmdmsg -side bottom -anchor nw
pack $beparent.entframe.up.1.txtentry -side top -fill x
pack $beparent.entframe.up.1.cmdmb -side bottom -fill x
pack $beparent.entframe.up.2.bg -side top
pack $beparent.entframe.up.2.cmdentry -side bottom
pack $beparent.entframe.up.3.label -side top
place $beparent.entframe.up.3.button -relx 0.5 -rely 0.5 -anchor center
raise $beparent.entframe.up.3.button
pack $beparent.entframe.fc.chkcfr -side left -fill x -expand true
pack $beparent.entframe.fc.chkdia -side left -fill x -expand true
pack $beparent.entframe.fc.chkwin -side left -fill x -expand true
pack $beparent.entframe.fc.chkupd -side right -fill x -expand true
pack $beparent.entframe.fc -fill x -side bottom -pady 5

pack $beparent.middle.advbutt -pady 2 -side left
pack $beparent.bottom -side bottom -fill x
pack $beparent.bottom.applyframe -side left -padx 3 -pady 2
pack $beparent.bottom.applyframe.apply -anchor center -padx 3 -pady 2
pack $beparent.bottom.undo -side left -padx 3 -pady 2
pack $beparent.bottom.save -side left -padx 3 -pady 2
pack $beparent.bottom.close -side right -padx 3 -pady 2
pack $beparent.adv.0 -side left -fill both -padx 5 -pady 5
pack $beparent.adv.0.opt -side top -fill both
pack $beparent.adv.0.args -side bottom -fill both
pack $beparent.adv.0.opt.0 -side left -fill both -padx 4
pack $beparent.adv.0.opt.1 -side right -fill both
pack $beparent.adv.1 -side right -fill both -padx 5 -pady 5
pack $beparent.adv.1.0 -side left -fill both
pack $beparent.adv.1.0.sld -side bottom -fill both -padx 5 -pady 5
pack  $beparent.adv.1.1 -side right -fill both

pack $beparent.adv.0.opt.0.cmblabel -side top
pack $beparent.adv.0.opt.0.cmb -side top
pack $beparent.adv.0.opt.0.fmblabel -side top
pack $beparent.adv.0.opt.0.fmb -side top
pack $beparent.adv.0.opt.1.rmblabel -side top
pack $beparent.adv.0.opt.1.rmb -side top
pack $beparent.adv.0.opt.1.bdlabel -side top
pack $beparent.adv.0.opt.1.bds -side top

pack $beparent.adv.0.args.arglabel -side top
pack $beparent.adv.0.args.argentry -side bottom -padx 2

pack $beparent.adv.1.0.sld.rslider -side left
pack $beparent.adv.1.0.sld.gslider -side left
pack $beparent.adv.1.0.sld.bslider -side left
pack $beparent.adv.1.0.l1 -side top
pack $beparent.adv.1.1.l2 -side top
pack $beparent.adv.1.1.rb1 -side top
pack $beparent.adv.1.1.rb2 -side top
pack $beparent.adv.1.1.rb3 -side top
pack $beparent.adv.1.1.rb4 -side top
pack $beparent.adv.1.1.cf -side bottom -fill x -padx 5 -pady 5
pack $beparent.menu.msg -side top

bind .button_edit <Return> {
catch {focus .button_edit
SetButtonStyle {} {}
ApplyProc $bindex}
}
bind .button_edit <Control-c> {
BE_Close
}
bind .button_edit <Escape> {
BE_Close
}
bind .button_edit.entframe.up.1.txtentry <KeyPress> {
after 50 {eval {SetButtonStyle {-text} \
[$beparent.entframe.up.1.txtentry get]}}
}
bind .button_edit <Control-d> {PrintCmdLine; break}
bind .button_edit <Button> {set be(gludge) 1}
bind .button_edit <Key> {set be(gludge) 1}

proc BE_Close {} {
global xf bargs bcomm bindex be

if [info exists bindex] {
if {[set par "$be(dialog)$be(update)$be(confirm)$be(win)"] == ""} {
set par N
}
if {$be(bg) == "&"} {
set cmdarg "$be(cmdarg) $be(bg)"
} {
set cmdarg $be(cmdarg)
}
if {$be(editedi) > 0} {
set ret [AskWin "You have made changes! Close the editor without saving?" -100 -100 "Save"]
switch $ret {
0 {return}
2 {ApplyProc $bindex ; ButtonSave}
default {}
}
}
}
set xf(editmode) 0

if !$xf(helpmode) {
foreach var [array names xf Help*] {
unset xf($var)
}
}

set xf(editbutton) ""
catch {unset bindex be}
destroy .button_edit

set xf(be_on) 0
BE_UnSetTrace
SetCnfMenuBg
}

proc ApplyProc {index} {
global beparent xf be bargs bcomm
if {[regexp %o1 $be(cmdarg)]} {
set be(dialog) D
} {
set be(dialog) ""
}
if {[set par "$be(dialog)$be(update)$be(confirm)$be(win)"] == ""} {
set par N
}
if {$be(bg) == "&"} {
set cmdarg "$be(cmdarg) $be(bg)"
} {
set cmdarg $be(cmdarg)
}
set bcomm($index) [format "%s%s%s" "$par " "$be(cmd) " "$cmdarg"]
set bargs($index) $be(style)
$xf(editbutton) flash
eval {$xf(editbutton) config} $bargs($index)
$xf(editbutton) flash
set be(editedi) 1
}

proc PutButton {} {
global beparent bindex xf be bargs bcomm
incr xf(editmode)
. config -cursor cross
$beparent.menu.msg config -text "Where You want to PUT it ?!?"\
-fg "#a00000" -width 400 -anchor center -justify center
button $beparent.menu.cb -text Cancel -bg #ffacac -padx 1 -pady 1 \
-command {
incr xf(editmode) -1
set tmp $xf(editbutton)
set xf(editbutton) ""
set xf(editbutton) $tmp
}
pack $beparent.menu.msg -side left
pack $beparent.menu.cb -side right -ipadx 0 -ipady 0 -padx 0 -pady 0
tkwait variable xf(editbutton)
pack forget $beparent.menu.msg
if {$xf(editmode) > 1} {
regexp {(left|right)} $xf(editbutton) newside
regsub {(left|right)} $be(cmd) $newside be(cmd)

ApplyProc $bindex
incr xf(editmode) -1
}
catch "destroy $beparent.menu.cb"
SetArrowPointer
}

proc UndoProc {} {
global beparent bindex xf be bargs bcomm
focus $xf(editbutton)
set be(editedi) 0
set bargs($bindex) $be(undoargs)
set bcomm($bindex) $be(undocomm)
eval {$xf(editbutton) config} $bargs($bindex)
$xf(editbutton) invoke
}

proc ChEditMode {} {
global xf be beparent
if {$be(editmode) == "Advanced..."} {
trace vdelete be(style) w BE_SetEdi
set be(editmode) "Normal..."
pack $beparent.adv -side top -fill both
update idletasks
tkwait variable be(gludge)
trace variable be(style) w BE_SetEdi
} {
set be(editmode) "Advanced..."
pack forget $beparent.adv
}
}

proc SetButtonStyle { opt val} {
global be beparent
set a [regsub {-all} {--} -borderwidth $be(style) -bd tmp2]
set a [regsub {-all} {--} -foreground $tmp2 -fg tmp2]
set a [regsub {-all} {--} -background $tmp2 -bg tmp2]
set be(style) $tmp2
if {$opt == ""} {return 0}
set pos [lsearch $be(style) $opt]
set tmp $be(style)
if {$pos < 0 } {
set be(style) [append tmp " $opt $val "]
} {
set be(style) [lreplace $tmp $pos [expr {$pos + 1}] $opt $val]
}
if [catch {eval {$beparent.entframe.up.3.button config} $be(style)}] {
if {[focus] == "$beparent.entframe.up.1.txtentry"} {
SetButtonStyle -text {}
} {
puts stderr "Error in but.args!"
}
}
}

proc ButtonStyles {style} {
global be
for {set i 0} {$i < [llength $style]} {incr i} {
SetButtonStyle [lindex $style $i] [lindex $style [incr i]]
}
}

proc ChColor {} {
global be beparent
set color [format "#%02x%02x%02x" $be(red) $be(green) $be(blue)]
SetButtonStyle $be(colormode) $color
$beparent.adv.1.1.cf  config -bg $color
}

proc SetScale {} {
global beparent be
set color [$beparent.entframe.up.3.button cget $be(colormode)]
$beparent.adv.1.1.cf  config -bg $color
if {[string range $color 0 0] != "#"} {
set tmpcol [winfo rgb $beparent $color]
set be(red) [expr round([lindex $tmpcol 0])]
set be(green) [expr round([lindex $tmpcol 1])]
set be(blue) [expr round([lindex $tmpcol 2])]
} {
set red [string range $color 1 2]
set green [string range $color 3 4]
set blue [string range $color 5 6]
set be(red) [format %d "0x$red"]
set be(green) [format %d "0x$green"]
set be(blue) [format %d "0x$blue"]
}
}

proc PrintCmdLine {} {
global be
set comm "\[list $be(cmd) $be(cmdarg) $be(bg)\]"
set barg $be(style)
puts stdout "COMM: $comm \nBARGS: $barg"
}

proc ButtonSave {} {
global be bcomm bargs xf xf(actionbuttons_file) bindex
set idx 0
MakeSaveDir
set xf(actionbuttons_file) "$xf(user_home)[file tail $xf(actionbuttons_file)]"
set out [open $xf(actionbuttons_file) w]
while {[info exists bcomm($idx)] && [info exists bargs($idx)]} {
puts $out "set bargs($idx) \{$bargs($idx)\}"
puts $out "set bcomm($idx) \[list $bcomm($idx)\]"
incr idx
}
close $out
.button_edit.bottom.save flash
set be(editedi) 0
set be(undoargs) $bargs($bindex)
set be(undocomm) $bcomm($bindex)
}

proc WriteHelp {} {
global xf
if [winfo exists .write_help] {
wm deiconify .write_help
raise .write_help
return
}
set tl [toplevel .write_help -height 150 -width 100]
wm geometry $tl +100+100
wm title $tl "X-Files Button Help"
frame $tl.tf
entry $tl.tf.entry -textvariable hl
pack $tl.tf.entry -side top -fill x
text $tl.tf.text -width 40 -height 10
frame $tl.bf
button $tl.bf.ok -text OK -command {WriteHelp_OK ; destroy .write_help}
button $tl.bf.cancel -text Cancel -command {destroy .write_help}
pack $tl.tf -side top
pack $tl.bf -side bottom -fill x -expand true
pack $tl.bf.ok -side left
pack $tl.bf.cancel -side right
pack $tl.tf.text -side top
WriteHelp_Get $tl
}

proc WriteHelp_Get {tl} {
global xf
set eb $xf(editbutton)
$tl.tf.entry delete 0 end
$tl.tf.text delete 0.0 end
if {[info exists xf(Help$eb)] == 1} {
set hl [lindex $xf(Help$eb) 0]
$tl.tf.entry insert 0 $hl
$tl.tf.entry icursor end
update idletasks
set temp [lreplace $xf(Help$eb) 0 0 ]
foreach line $temp {
$tl.tf.text insert end "$line\n"
}
}
}
}
proc WriteHelp_OK {{c 1}} {
global xf tl hline hl
set hbl .Version
set xf(Help.Version) 2
if $c {
set eb $xf(editbutton)
set xf(Help$eb) ""
lappend xf(Help$eb) $hl
set xf(Help$eb) "$xf(Help$eb) [split [string trim [.write_help.tf.text get 0.0 end]] \n]"
}
for {set i 0} {$i < 16} {incr i 2} {
for {set j 0} {$j < 6} {incr j} {
set tleft ".xfleft.bf($i).f($j).b($j)"
if {[info exists xf(Help$tleft)] == 1} {
set hbl [linsert $hbl end "$tleft"]
}
set tright ".xfright.bf([expr $i + 1]).f($j).b($j)"
if {[info exists xf(Help$tright)] == 1} {
set hbl [linsert $hbl end "$tright"]
}
}
}
MakeSaveDir
set xf(user_pophelp_file) "$xf(user_home)[file tail $xf(user_pophelp_file)]"
set out [open $xf(user_pophelp_file) w]
foreach b $hbl {
puts $out "set xf(Help$b) \[list $xf(Help$b)\]"
}
close $out
}

proc ConvertHelp {} {
global xf
set ret [AskWin  "Your pop-help file is in the old format. If you do not convert it, help-texts are unusable and also they will be lost if You write any new ones.\n\nConvert old help-file to new format now? " -100 -100]
switch $ret {
0 {return}
1 {}
default {}
}
for {set i 0} {$i < 16} {incr i 2} {
for {set j 0} {$j < 6} {incr j} {
set tleft ".xfleft.bf($i).b($j)"
if {[info exists xf(Help$tleft)] == 1} {
set  xf(Help.xfleft.bf($i).f($j).b($j)) $xf(Help$tleft)
}
set tright ".xfright.bf([expr $i + 1]).b($j)"
if {[info exists xf(Help$tright)] == 1} {
set xf(Help.xfright.bf([expr $i + 1]).f($j).b($j)) $xf(Help$tright)
}
}
}
WriteHelp_OK 0
}

proc BE_Hack {cmd {entry ""} {bg ""}}  {
global be

if {[string compare "pack" $entry] == 0} {
pack .button_edit.entframe.up.2.cmdentry -side bottom
} {
pack forget .button_edit.entframe.up.2.cmdentry
}
if {[string compare "pack" $bg] == 0} {
pack .button_edit.entframe.up.2.bg -side top
} {
pack forget .button_edit.entframe.up.2.bg
}
set be(cmd) $cmd
set be(cmdarg) ""
}

proc BE_SetTrace {} {
global be
trace variable be(txt) w  BE_SetEdi
trace variable be(cmdtxt) w BE_SetEdi
trace variable be(cmdarg) w BE_SetEdi
trace variable be(style) w BE_SetEdi
trace variable be(bg) w BE_SetEdi
trace variable be(win) w BE_SetEdi
trace variable be(update) w BE_SetEdi
trace variable be(confirm) w BE_SetEdi
trace variable be(dialog) w BE_SetEdi
}
proc BE_UnSetTrace {} {
global be
trace vdelete be(txt) w  BE_SetEdi
trace vdelete be(cmdtxt) w BE_SetEdi
trace vdelete be(cmdarg) w BE_SetEdi
trace vdelete be(style) w BE_SetEdi
trace vdelete be(bg) w BE_SetEdi
trace vdelete be(win) w BE_SetEdi
trace vdelete be(update) w BE_SetEdi
trace vdelete be(confirm) w BE_SetEdi
trace vdelete be(dialog) w BE_SetEdi

}
proc BE_SetEdi {t y u} {
global be
set be(editedi) 2
}

