proc VirtualTar {tarfile {s {}} {upd 0}} {
global xf zz

if [CheckVirtuals "$tarfile" $s $upd] {
return
}
set zz 0
set filelist ""
set block 0
if {[catch {eval exec zcat < [list $tarfile] | $xf(LISTTAR) -} filelist] \
&& [CheckTar 1 $filelist block]} {
if {[catch {eval exec cat < [list $tarfile] | $xf(LISTTAR) -} filelist] \
&& [CheckTar 2 $filelist block]} {
if {[catch {eval exec $xf(LISTTAR) [list $tarfile]} filelist] \
&& [CheckTar 3 $filelist block]} {
if {[catch {eval exec tar ztvf [list $tarfile]} filelist] \
&& [CheckTar 4 $filelist block]} {
MessageBox "Error opening tar-file\n[file tail $tarfile] !" $s
if {$xf(fsmode_$s)} {
AfterVirtual xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
}
return 1
} {
set zz 1
}
}
}
} {
set zz 1
}
set filelist [split $filelist \n]
if $block {
set filelist [lrange $filelist 0 [expr [llength $filelist]-2]]
}
set xf(fsmode_$s) 2

VirtualFs xf $tarfile $s 2 {} $filelist
}
proc CheckTar {mode files var} {
upvar $var block
# 1: zcat <
# 2: cat <
# 3: tar tvf
# 4: tar ztvf
if {($mode == 1 || $mode == 4) && [string match "*gzip format*" $files]} {
return 1
}
if [string match "*blocksize*" [lindex [split $files \n] end]] {
set block 1
}
return 0
}
proc VirtualZip {zipfile {s {}} {upd 0}} {
global xf

if [CheckVirtuals $zipfile $s $upd] {
return
}

if [catch {eval exec $xf(LISTZIP) [list $zipfile]} filelist] {
MessageBox "Error opening zip-file\n[file tail $zipfile] !" $s
return
} {
set xf(fsmode_$s) 1
set filelist [split $filelist \n]
set k [lsearch $filelist {\ ------*}]
set filelist [lreplace $filelist 0 $k]
set filelist [lreplace $filelist [expr [llength $filelist]-2] end]
VirtualFs xf $zipfile $s 0 27 $filelist
}
}

proc CheckVirtuals {file s upd} {
global xf vfs

if {[string compare {} $s] == 0} {
after 100 [list InfoChange xf $file "No files selected!"]
bell
after 4000 [list DefaultInfo xf $file]
return 1
}
if {$upd == 0} {
if {$xf(fsmode_left) || $xf(fsmode_right)} {
MessageBox "Sorry, you are already using virtual filesystem!" $s
return 1
}
} {
catch {unset vfs}
}
if ![file readable $file] {
MessageBox "Unable to open file\n$file\nCheck permissions." $s
return 1
}
if ![file writable $file] {
MessageBox "You will not be able to write to\n$file\nNo write permission." $s
}
return 0
}

proc VirtualFs {arr filename s sizei namei filelist} {
global vfs xf

if [info exists vfs] {
catch {unset vfs}
}
set n 0
foreach l $filelist {
if {$xf(fsmode_$s) == 2} {
if ![regexp {^[-rwx]+$} [string range $l 1 7]] {
continue
}
set namei [string first : $l]
for {set c 0} {$c < 2} {incr c} {
set namei [expr $namei+[string first { } [string range $l $namei end]]]
incr namei
}
}
regsub {\./} [string range $l $namei end] {} new
set list($new) [lindex $l $sizei]
incr n
}
unset filelist
set vfs(/) {}
set vfs(/dirs) {}

foreach item [lsort [array names list]] {
if [string match */ $item] {
ProcessVFsDir vfs /$item
} {
regexp {[^/]*$} $item file
if [string match */* $item] {
set dir [file dirname $item]/
if ![info exists vfs(/${dir}dirs)] {
ProcessVFsDir vfs /$dir
}
lappend vfs(/$dir) [list $file $list($item)]
} {
lappend vfs(/) [list $file $list($item)]
}
}
}
if ![info exists xf(virtualfile)] {
set xf(virtualfile) $xf(pathi$s)[string trimleft $filename "\./"]
BeforeVirtual xf $s
FileList $s $xf(pathi$s)
DefaultInfo xf $s
}
}
proc ProcessVFsDir {arr dir} {
upvar $arr vfs

if [string match $dir "/"] {
set path ""
} {
set dir [string trimright $dir /]
set path [file dirname $dir]/
if [string match "//" $path] {
set path "/"
}
set dir [file tail $dir]/
}

if [info exists vfs(${path}dirs)] {
lappend vfs(${path}dirs) $dir
if {[info exists vfs(${path}$dir)] == 0} {
set vfs(${path}$dir) {}
}
if {[info exists vfs(${path}${dir}dirs)] == 0} {
set vfs(${path}${dir}dirs) {}
}
} {
ProcessVFsDir vfs $path
lappend vfs(${path}dirs) $dir
if {[info exists vfs(${path}$dir)] == 0} {
set vfs(${path}$dir) {}
}
set vfs(${path}${dir}dirs) {}
}
}

proc BeforeVirtual {arr s} {
upvar $arr xf

set xf(pathfs) $xf(pathi$s)
set xf(pathi$s) "/"
$xf(pathEnt_$s) xview moveto 1
$xf(pathEnt_$s) icursor end
set xf(parent_$s) $xf(pathfs)
set xf(backup_$s) $xf(pathfs)

NullSelect xf $s

if {$xf(fsmode_$s) == 2 && $xf(notardel)} {
$xf(fuf).${s}list.popup_menu entryconfigure Mov* -state disabled
$xf(fuf).${s}list.popup_menu entryconfigure Del* -state disabled
}
.xfmenu.butt.m entryconfigure Prot* -state disabled
.xfmenu.butt.m entryconfigure Show* -state disabled
foreach z [list $s.dirHistory middle.hide$s middle.copyleft middle.copyright] {
.ff.top.$z config -state disabled
}
$xf(fuf).${s}list config -bg #eeeece
}

proc AfterVirtual {arr s} {
upvar $arr xf
global vfs

catch {unset vfs}
SetPaths xf $s $xf(pathfs)

NullSelect xf $s

if {$xf(fsmode_$s) == 2 && $xf(notardel)} {
$xf(fuf).${s}list.popup_menu entryconfigure Mov* -state normal
$xf(fuf).${s}list.popup_menu entryconfigure Del* -state normal
}
.xfmenu.butt.m entryconfigure Prot* -state normal
.xfmenu.butt.m entryconfigure Show* -state normal
set xf(fsmode_$s) 0
foreach z [list right.dirHistory middle.hideleft middle.copyleft middle.copyright \
middle.hideright left.dirHistory] {
.ff.top.$z config -state normal
}
$xf(fuf).${s}list config  -bg [option get $xf(fuf).${s}list background {}]
unset xf(virtualfile)
unset xf(pathfs)
}

proc VirtualOutput {arr mode vf file s} {
upvar $arr xf
switch $mode {
1 {OutputWindow [eval exec $xf(ZIPOUTP) [list $vf] [list $file]] [list $xf(backup_$s)]}
2 {
if [catch {eval exec cat < [list $vf] | tar Oxf - [list $file]} txt] {
if [catch {eval exec zcat < [list $vf] | tar Oxf - [list $file]} txt] {
if [catch {eval exec $xf(TAROUTP) [list $vf] [list $file]} txt] {
if [catch {eval exec tar zOxf [list $vf] [list $file]} txt] {
MessageBox "Cannot read\n$file\nin\n[file tail $vf] !" $s
return
}
}
}
}
OutputWindow $txt [list $xf(backup_$s)]
}
}
SetArrowPointer
}

proc FO_Nor_Virt {arr s o filelist operation mode} {
upvar $arr xf
global zz XF_TMP

set rc 0
if [string match $mode "tar"] {
if $zz {
MessageBox "The archive is compressed! Please uncompress it first." $s
return 1
}
set voper $xf(TOTAR)
set vproc "VirtualTar"
} {
set voper $xf(TOZIP)
set vproc "VirtualZip"
}
set rc [DelFile $s "/tmp" "$XF_TMP/"]
set temppi "/tmp/$XF_TMP[string trimright $xf(pathi$o) /]"
if [catch {eval exec $xf(MKDIR) [list $temppi]}] {
MakeDirProc $temppi
}
set rc [CopyFiles $s $xf(pathi$s) $filelist $temppi/]
if {$rc == 0 && [string match $operation "mv"]} {
set rc [DelFiles $s $xf(pathi$s) $filelist]
}
cd /tmp/$XF_TMP/
set k 0
if {[llength $filelist] > 1} {
foreach d $filelist {
set dirri [string trimleft $xf(pathi$o) /]
set filelist [lreplace $filelist $k $k [append dirri "$d"]]
incr k
}
eval exec $voper [list $xf(virtualfile)] $filelist
} {
set dirri [string trimleft $xf(pathi$o) /]
set filelist [append dirri [lindex $filelist 0]]
set k 1
eval exec $voper [list $xf(virtualfile)] [list $filelist]
}

set rc [DelFile $s "/tmp" "$XF_TMP/"]
cd $xf(pathfs)
if $k {
$vproc $xf(virtualfile) $o 1
}
return $rc
}

proc FO_Zip {arr1 arr2 s o filelist intlist list operation op} {
upvar $arr1 xf
upvar $arr2 vfs

set inpath [string trimleft $xf(pathi$s) /]
set rmflag 0
set rc 0
set n 0
foreach i [list files dirs files_num dirs_num] {
set $i {}
}
set rc 0
foreach f $filelist {
if [string match */ $f] {
lappend dirs_num [lindex $intlist $n]
lappend dirs $f
} {
lappend files_num [lindex $intlist $n]
lappend files $inpath$f
}
incr n
}

InfoChange xf $s "$op..."
switch $operation {
rm {
if [string compare {} $files] {
eval exec $xf(DELZIP) [list $xf(virtualfile)] $files
}
DelZipDir xf vfs $dirs $inpath $xf(virtualfile)
set rmflag 1
}
cp {
if [string compare {} $files] {
if [catch {eval exec $xf(FROMZIP)j [list $xf(virtualfile)] $files -d [list $xf(pathi$o)]}] {
set rc [CopyCatch $s $files $xf(pathi$o)]
}
}
if [string compare {} $dirs] {
foreach d $dirs {
set oo $inpath
if [string compare {} $vfs(/$inpath$d)] {
lappend dirrit [append oo $d "*"]
} {
lappend dirrit [append oo $d]
}
}
if [catch {eval exec $xf(FROMZIP) [list $xf(virtualfile)] $dirrit -d [list $xf(pathi$o)]}] {
set rc [CopyCatch $s $dirrit $xf(pathi$o)]
}
set gg $xf(pathi$o)$inpath
cd $gg
set files [lsort [glob -nocomplain -- $gg{*,.*}]]
foreach c [list .. .] {
set i [lsearch -glob $files *$c]
set files [lreplace $files $i $i]
}
if [string compare {} $inpath] {
set rc [CopyFiles $s $gg $files $xf(pathi$o)]
cd $xf(pathfs)
if {$rc == 0} {
set rc [DelFile $s $gg $xf(pathi$o)$inpath]
}
}
}
}
mv {
if [string compare {} $files] {
if [catch {eval exec $xf(FROMZIP)j [list $xf(virtualfile)] $files -d [list $xf(pathi$o)]}] {
set rc [CopyCatch $s $files $xf(pathi$o)]
}
}
if {$rc == 0 && [string compare {} $files]} {
eval exec $xf(DELZIP) [list $xf(virtualfile)] $files
}
if [string compare {} $dirs] {
foreach d $dirs {
set oo $inpath
lappend dirrit [append oo $d "*"]
}
if [catch {eval exec $xf(FROMZIP) [list $xf(virtualfile)] $dirrit -d [list $xf(pathi$o)]}] {
set rc [CopyCatch $s $files $xf(pathi$o)]
}
set gg $xf(pathi$o)$inpath
cd $gg
set files [lsort [glob -nocomplain -- $gg{*,.*}]]
foreach c [list .. .] {
set i [lsearch -glob $files *$c]
set files [lreplace $files $i $i]
}
if [string compare {} $inpath] {
set rc [CopyFiles $s $gg $files $xf(pathi$o)]
if {$rc == 0} {
set rc [DelFile $s $gg $xf(pathi$o)$inpath]
}
}
}
DelZipDir xf vfs $dirs $inpath $xf(virtualfile)
set rmflag 1
}
}
if $rmflag {
VirtualZip $xf(virtualfile) $s 1
}
return $rc
}

proc FO_Tar {arr s o filelist intlist list operation op} {
upvar $arr xf

set inpath [string trimleft $xf(pathi$s) /]
set n 0
set rmflag 0
set rc 0
foreach i [list files files_num dirs_num] {
set $i {}
}
foreach f $filelist {
if [string match */ $f] {
lappend dirs_num [lindex $intlist $n]
} {
lappend files_num [lindex $intlist $n]
}
incr n
lappend files $inpath$f
}
InfoChange xf $s "$op..."
switch $operation {
rm {
if {[AskWin "This might corrupt\n\
\"[file tail $xf(virtualfile)]\"\nProceed ?!"] == 1} {
catch {eval exec $xf(DELTAR) [list $xf(virtualfile)] $files}
set rmflag 1
}
}
cp {
if [catch {eval exec cat < [list $xf(virtualfile)] | tar -C [list $xf(pathi$o)] -xf - $files}] {
if [catch {eval exec zcat < [list $xf(virtualfile)] | tar -C [list $xf(pathi$o)] -xf - $files}] {
if [catch {eval exec $xf(FROMTAR) [list $xf(virtualfile)] -C [list $xf(pathi$o)] $files}] {
if [catch {eval exec tar -C [list $xf(pathi$o)] -zxf [list $xf(virtualfile)] $files}] {
MessageBox "Cannot copy from\n[file tail $xf(virtualfile)] !" $s
return 1
}
}
}
}
if {[string compare {} $inpath] != 0} {
set rc [CopyFiles $s $xf(pathi$o) $files $xf(pathi$o)]
if {$rc == 0} {
regexp {([^/]*)/} "$inpath" "" kuole
set rc [DelFile $s $xf(pathi$o) $kuole/]
}
}
}
mv {
if {[AskWin "This might corrupt\n\
\"[file tail $xf(virtualfile)]\"\nProceed ?!"] == 1} {
if [catch {eval exec cat < [list $xf(virtualfile)] | tar -C [list $xf(pathi$o)] -xf - $files}] {
if [catch {eval exec zcat < [list $xf(virtualfile)] | tar -C [list $xf(pathi$o)] -xf - $files}] {
if [catch {eval exec $xf(FROMTAR) [list $xf(virtualfile)] -C [list $xf(pathi$o)] $files}] {
if [catch {eval exec tar -C [list $xf(pathi$o)] -zxf [list $xf(virtualfile)] $files}] {
MessageBox "Cannot copy from\n[file tail $xf(virtualfile)] !" $s
return 1
}
}
}
}
if {[string compare {} $inpath] != 0} {
set rc [CopyFiles $s $xf(pathi$o) $files $xf(pathi$o)]
if {$rc == 0} {
regexp {([^/]*)/} "$inpath" "" kuole
set rc [DelFile $s $xf(pathi$o) $kuole/]
}
}
catch {eval exec $xf(DELTAR) [list $xf(virtualfile)] $files}
set rmflag 1
}
}
}
if $rmflag {
VirtualTar $xf(virtualfile) $s 1
}
return $rc
}
proc DelZipDir {arr1 arr2 dirs path zipfile} {
upvar $arr1 xf $arr2 vfs

if {[string compare {} $dirs] == 0} {
return
}
foreach d $dirs {
if [string compare {} $vfs(/${path}${d}dirs)] {
DelZipDir xf vfs $vfs(/${path}${d}dirs) $path$d $zipfile
} elseif ![string compare {} $vfs(/${path}${d})] {
eval exec $xf(DELZIP) [list $zipfile] [list $path$d]
}
if [string compare {} $vfs(/${path}${d})] {
eval exec $xf(DELZIP) [list $zipfile] [list $path$d*]
}
}
}

