proc SelectFont {{font fixed}} {
global fsrc

catch {destroy .self}
set w [toplevel .self]
wm withdraw $w
wm title $w "X-Files Font Selector v0.1"
wm resizable $w 0 0

frame $w.l -bd 2 -relief ridge
frame $w.b -bd 4 -relief raised

label $w.c -anchor w
pack $w.c -side top -fill x -expand 1

listbox $w.l.lb -yscrollcommand [list $w.l.sy set] \
-selectbackground "#dfdf0f" -setgrid 1 \
-font *fixed-bold-r*13*iso8859-1 -width 75
scrollbar $w.l.sy -orient vertical -command \
[list $w.l.lb yview] -relief ridge
pack $w.l.lb -side left -fill both -expand 1
pack $w.l.sy -side left -fill y
pack $w.l -side top -fill both -expand 1

text $w.t -bd 3 -relief ridge -height 7 -width 50 -wrap none -pady 5
pack $w.t -side top -fill x
$w.t insert 0.0 "ABCDEFGHIJKLMNOPQRSTUVXYZ\nabcdefghijklmnopqrstuvxyz\n0123456789"
$w.t tag add TEXT 0.0 end
$w.t tag configure TEXT -justify center

button $w.b.ok -text "Select" -width 6 -command {set fsrc 1}
button $w.b.cancle -text "Cancel" -width 6 -command {set fsrc 0}
pack $w.b.ok -side left -padx 10 -pady 10
pack $w.b.cancle -side right -padx 10 -pady 10
pack $w.b -side top -fill x -expand 1

bind $w <Control-c> {set fsrc 0}
bind $w <Escape> {set fsrc 0}
bind $w.l.lb <ButtonRelease-1> {SF_Select .self [%W nearest %y] [%W get [%W nearest %y]]}
bind $w.l.lb <Double-Button-1> {.self.b.ok flash; set fsrc 1}
bind $w.l.lb <Key> {
switch %K {
Up -
Down {
set sel [%W curselection]
if [string match Up %K] {set i -1} {set i 1}
%W select clear $sel
set ind [expr $sel+$i]
%W select set $ind
%W see $ind
SF_Select .self $ind [%W get $ind]
}
Return {.self.b.ok flash; set fsrc 1}
}
}
$w.c config -text "Font count: n/a"
$w.l.lb insert 0 "Reading fonts, please wait..."
wm deiconify $w
tkwait visibility $w.l.lb
after 100
update
if [catch {set tmp [lsort [exec xlsfonts]]} err] {
MessageBox "This option requires external 'xlsfonts'-utility!\n\nError: $err !"
destroy $w
return $font
}
set pr ""
set fonts {}
foreach f $tmp {
if {[string compare $pr $f] == 0} {continue}
set pr $f
lappend fonts $f
}
$w.l.lb delete 0
eval "$w.l.lb insert end $fonts"
$w.c config -text "Font count: [$w.l.lb size]"
if {[string compare {} $font] == 0} {
$w.t config -state disabled
SF_Select $w 0 [$w.l.lb get 0]
$w.l.lb select set 0
$w.l.lb activate 0
} {
set ind [lsearch -glob $fonts *$font*]
$w.l.lb select set $ind
$w.l.lb activate $ind
$w.l.lb see $ind
$w.t config -state disabled -font [$w.l.lb get $ind]
}
grab $w
focus $w.l.lb
tkwait variable fsrc
if $fsrc {
set rc [$w.l.lb get [$w.l.lb curselection]]
} {set rc $font}
destroy $w
return $rc
}
proc SF_Select {w ind font {iter 0}} {
if [catch {$w.t tag configure TEXT -font $font}] {
if {$iter == 0} {
MessageBox "Non-existing font, updating view..."
}
$w.l.lb delete $ind
$w.l.lb select set $ind
$w.l.lb activate $ind
$w.c config -text "Font count: [$w.l.lb size]"
SF_Select $w $ind [$w.l.lb get $ind] 1
}
}

proc FS { num defdir mode {file ""}} {
global filesel xf xf_image
set filesel(result) {}
set filesel(dir) $defdir
set filesel(mode) $mode
set filesel(file) $file

switch $mode {
load {set filesel(modtxt) "Load File"
set filesel(mc) "#c0c0e0"
set lab "File: "}
save {set filesel(modtxt) "Save File"
set filesel(mc) "#e0c0c0"
set lab "File: "}
dir  {set filesel(modtxt) " Get Dir "
set filesel(mc) "#d0d0a0"
set lab " Dir: "}
}
set fs [toplevel .fs -borderwidth 5]
wm geometry $fs +300+200
wm title $fs "FileSelector#$num"

frame $fs.buttons -relief groove -bd 2
frame $fs.top
frame $fs.lbframe
label $fs.label -text $filesel(modtxt) -relief sunken -bd 0 -bg $filesel(mc)
pack $fs.label -fill x
frame $fs.top.pf
label $fs.top.pf.lab -text "Path: "
label $fs.top.pf.pathlabel -textvariable filesel(dir)
frame $fs.top.ef
label $fs.top.ef.lab -text $lab
entry $fs.top.ef.entry -textvariable filesel(file)
pack $fs.top.ef.lab -side left -fill x
pack $fs.top.ef.entry -side left -fill x -expand true
$fs.top.ef.entry xview moveto 1
$fs.top.ef.entry icursor end
frame $fs.buttons.ok -relief sunken -bd 1
button $fs.buttons.ok.b -text OK!  -command {FS_ok b 1}
pack $fs.buttons.ok.b -padx 0 -pady 1
button $fs.buttons.cancel -text Cancel -command {set filesel(result) {}}
pack $fs.buttons.cancel -side right -pady 5 -padx 5
pack $fs.buttons.ok -side left -pady 5 -padx 5
pack $fs.buttons -side bottom -fill x
pack $fs.top.pf.lab -side left -fill x
pack $fs.top.pf.pathlabel -side left -fill x
pack $fs.top.pf -fill x
pack $fs.top.ef -fill x
pack $fs.top -fill x
frame $fs.lbframe.sb
listbox $fs.lbframe.lb -yscrollcommand [list $fs.lbframe.sb.sy set]\
-width 30 -height 7 -selectmode browse -selectbackground #dfdfaf\
-selectborderwidth 2 -selectforeground #101000 -bg #cccccc \
-setgrid true -exportselection false
scrollbar $fs.lbframe.sb.sy -orient vertical\
-command [list $fs.lbframe.lb yview]
button $fs.lbframe.sb.t -image $xf_image(topimage) -padx 0 -pady 0\
-command {.fs.lbframe.lb yview 0} -bd 1
button $fs.lbframe.sb.b -image $xf_image(bottomimage) -padx 0 -pady 0\
-command {.fs.lbframe.lb yview end} -bd 1
pack $fs.lbframe.sb.t -side top -fill x
pack $fs.lbframe.sb.sy -side top -fill y -expand true
pack $fs.lbframe.sb.b -side top -fill x
pack $fs.lbframe.sb -side right -fill y
pack $fs.lbframe.lb -side left -expand true -fill both
pack $fs.lbframe -side top -expand true -fill both
bind .fs.buttons.ok.b <Return> {.fs.buttons.ok.b invoke}
bind .fs.buttons.cancel <Return> {.fs.buttons.cancel invoke}
bind .fs.buttons.ok.b <Key> {focus .fs.top.ef.entry}

bind .fs.top.ef.entry <Return> {catch {FS_ok b}}
bind .fs.lbframe.lb <Return> {catch {FS_ok b}}

bind .fs.lbframe.lb <Key-Down> {
tkListboxUpDown %W 1
catch {FS_Sel b}
break
}
bind .fs.lbframe.lb <Key-Up> {
tkListboxUpDown %W -1
catch {FS_Sel b}
break
}
bind .fs <Escape> {focus .fs.top.ef.entry}
bind .fs.lbframe.lb <Button-1> {
tkListboxBeginSelect %W [%W index @%x,%y]
FS_Sel %y
break
}
bind .fs.lbframe.lb <ButtonRelease-1> {break}
bind .fs.lbframe.lb <B1-Motion> {
tkListboxBeginSelect %W [%W index @%x,%y]
FS_Sel %y
break
}
bind .fs.lbframe.lb  <Double-Button-1> { FS_ok %y ; break}
bind .fs.lbframe.lb <Button-2> {
set filesel(b2r) 1
tkCancelRepeat
%W scan mark %x %y
set tkPriv(x) %x
set tkPriv(y) %y
set tkPriv(mouseMoved) 0
%W activate @%x,%y
after 300 [list set filesel(b2r) 0]
break
}
bind .fs.lbframe.lb <ButtonRelease-2> {
if {$filesel(b2r)} {
tkListboxBeginSelect %W [%W index @%x,%y]
update idletasks
FS_Sel %y
FS_ok %y
}
break
}
bind .fs.lbframe.lb <B2-Motion> {
set filesel(b2r) 0
#if [info exists tkPriv(x)] {
#    set tkPriv(x) %x
#    puts "Meinas bugata..!! Catch You!!"
#}
#puts "tkPriv(x): $tkPriv(x)"
if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {
set tkPriv(mouseMoved) 1
}
if $tkPriv(mouseMoved) {
%W scan dragto 10000 %y
}
break
}
bind .fs.lbframe.lb <Button-3> {break}
bind .fs <Prior> {focus .fs.lbframe.lb }
bind .fs <Next> {focus .fs.lbframe.lb }
bind .fs <Up> {focus .fs.lbframe.lb }
bind .fs <Down> {focus .fs.lbframe.lb }
bind .fs <Home> {focus .fs.lbframe.lb }
bind .fs <End> {focus .fs.lbframe.lb }
bind .fs <Control-c> {set filesel(result) {}}
bind .fs <Escape> {set filesel(result) {}}

proc FS_List { dir } {
global filesel env
#puts "Exists? [file exists $dir]"
if ![file exists $dir] {
#puts "Directory \"$dir\" not found!"
set dir $env(HOME)
}
set files [glob -nocomplain -- $dir/{.*,*}]
.fs.lbframe.lb delete 0 end
set dirs {}
set others {}
foreach f [lsort $files] {
if [file isdirectory $f] then {
if {[file tail $f] != "."} then {
if {$dir != "/"} then {
lappend dirs [file tail $f]/
} {
if {[file tail $f] != ".."} {
lappend dirs [file tail $f]/
}
}
}
} {
if {[string compare $filesel(mode) "dir"]} {
lappend others [file tail $f]
} {
set filesel(file) $dir
.fs.top.ef.entry icursor end
set others ""
}
}
}
set all [concat $dirs $others]
foreach f $all {
.fs.lbframe.lb insert end $f
}
cd $dir
#puts $dir
set filesel(dir) $dir
}

proc FS_Sel {{y ""}} {
global filesel
set t .fs.lbframe.lb
update idletasks
if {[string compare $y ""] && [string compare $y "b"]} {
set sel [$t get [$t nearest $y]]
} {
if [catch {set sel [$t get [$t curselection]]}] {
set sel [$t get [$t nearest 0]]
}
}
if {![string compare $y b]} {
if {[string compare $filesel(mode) dir]} {
set filesel(file) $sel
} {
if [string compare $sel "../"] {
set filesel(file) "$filesel(dir)$sel"
} {
set filesel(file) [GetParentDir $filesel(dir)]
}
}
.fs.top.ef.entry icursor end
return
}
if {[file isdirectory $sel] && $filesel(mode) == "dir"} {
#puts "Dir: $sel"
if [string compare $sel "../"] {
set filesel(file) "$filesel(dir)$sel"
} {
set filesel(file) $filesel(dir)
}
.fs.top.ef.entry icursor end
return
}
if {[string compare [string index $sel [expr [string length $sel] -1]] "/"]} {
set filesel(file) $sel
.fs.top.ef.entry icursor end
}
#puts "File: $sel"
}

proc FS_ok {{y ""} {ok 0}} {
global filesel
set t .fs.lbframe.lb
if {[file isdirectory "$filesel(dir)$filesel(file)"]} {
if ![string compare $filesel(file) "../"] {
set filesel(dir) [GetParentDir $filesel(dir)]
} {
set filesel(dir) "$filesel(dir)$filesel(file)"
}
set filesel(file) ""
}
if [string compare $y "b"] {
if {[string compare $y ""]} {
set sel [$t get [$t nearest $y]]
} {
set sel [$t get [$t curselection]]
}
set tmp $filesel(dir)$sel
} {
set sel $filesel(file)
if ![string compare $filesel(mode) "dir"] {
if ![string compare $sel $filesel(dir)] {
focus .fs.buttons.ok.b
#puts [focus]
}
set tmp $filesel(file)
} {
set tmp $filesel(dir)$sel
}
}
if {[file isdirectory $tmp]} {
if {![string compare $sel "../"]} {
set filesel(dir) [GetParentDir $filesel(dir)]
#puts  "..: $filesel(dir)"
} {
#puts  "other_dir: $filesel(dir)"
set filesel(dir) "$tmp"
}
if {![file exists $filesel(dir)]} {
set temp $filesel(dir)
set filesel(dir) "Dir not found!"
after 1500 [list set filesel(dir) $temp]
return 0
}
if {![string compare $y "b"] && ![string compare $filesel(mode) "dir"] \
&& $ok} {
set filesel(result) $filesel(dir)
}

FS_List $filesel(dir)

if ![string compare $filesel(mode) "dir"] {
set filesel(file) $filesel(dir)
}
} {
if {[file exists $tmp]} {
if {![string compare $filesel(mode) "save"]} {
if [AskWin "File exists!\nOverwrite ?!"] {
set filesel(result) $tmp
} {
return 0
}
}
set filesel(result) $tmp
} {
if {![string compare $filesel(mode) "save"]} {
set filesel(result) $tmp
}
set temp $filesel(dir)
set filesel(dir) "File not found!"
after 1500 [list set filesel(dir) $temp]
return 0
}

}
}

FS_List $filesel(dir)
focus .fs.top.ef.entry
tkwait variable filesel(result)
destroy .fs
return $filesel(result)
}

