#
# tkImg Help
#
#


######################################################################
#
# text formatting routines derived from Klondike
# Reproduced here with permission from their author.
#
# Copyright (C) 1993,1994 by John Heidemann <johnh@ficus.cs.ucla.edu>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of John Heidemann may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY JOHN HEIDEMANN ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL JOHN HEIDEMANN BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
######################################################################

proc put-text {tw txt} {

    $tw configure -font -*-Times-Medium-R-Normal-*-140-*

    $tw tag configure bld -font -*-Times-Bold-R-Normal-*-140-*
    $tw tag configure cmp -font -*-Courier-Bold-R-Normal-*-120-*
    $tw tag configure h1 -font -*-Helvetica-Bold-R-Normal-*-180-* -underline 1
    $tw tag configure h2 -font -*-Helvetica-Bold-R-Normal-*-180-*
    $tw tag configure h3 -font -*-Helvetica-Bold-R-Normal-*-140-*
    $tw tag configure itl -font -*-Times-Medium-I-Normal-*-140-*
    $tw tag configure rev -foreground red

    $tw tag configure btn \
            -font -*-Courier-Medium-R-Normal-*-120-* \
            -foreground black -background white \
            -relief groove -borderwidth 2

    $tw mark set insert 0.0

    set t $txt

    while {[regexp -indices {<([^@>]*)>} $t match inds] == 1} {

        set start [lindex $inds 0]
        set end [lindex $inds 1]
        set keyword [string range $t $start $end]

        set oldend [$tw index end]

        $tw insert end [string range $t 0 [expr $start - 2]]

        purge-all-tags $tw $oldend insert

        if {[string range $keyword 0 0] == "/"} {
            set keyword [string trimleft $keyword "/"]
            if {[info exists tags($keyword)] == 0} {
                error "end tag $keyword without beginning"
            }
            $tw tag add $keyword $tags($keyword) insert
            unset tags($keyword)
        } else {
            if {[info exists tags($keyword)] == 1} {
                error "nesting of begin tag $keyword"
            }
            set tags($keyword) [$tw index insert]
        }

        set t [string range $t [expr $end + 2] end]
    }

    set oldend [$tw index end]
    $tw insert end $t
    purge-all-tags $tw $oldend insert
}

proc purge-all-tags {w start end} {
    foreach tag [$w tag names $start] {
        $w tag remove $tag $start $end
    }
}

######################################################################
#
# End of text formatting routines.
#
######################################################################


proc do_help {title helptext} {

  destroy .help if exists

  toplevel .help
  text .help.text -setgrid yes -wrap word \
    -width 55 -relief sunken -border 2 \
    -yscroll ".help.scroll set"
  scrollbar .help.scroll -relief sunken \
    -command ".help.text yview"
  button .help.ok -text "OK" \
    -command { destroy .help }

  pack .help.ok -side bottom -fill x
  pack .help.scroll -side right -fill y -padx 2 -pady 2
  pack .help.text -fill both -expand 1 -padx 5

  wm title .help "$title Help"
  wm minsize .help 1 1

  put-text .help.text $helptext
}

proc help {} {
  global tkimg

  do_help "tkImg $tkimg(ver)" {

<h1>Features of tkImg</h1>

  tkImg is a simple viewer that works with TCL/TK. Only reads the graphics formats that TCL/TK makes avaliable. So, you couldn't see .PCX files p.e. But it's a basic tool that allow you to see some pics like .GIF.

<h3>File formats supported by tkImg</h3>

  I don't know. Well, there are some than you can see without problems -i think-:
 
 . GIF
 . PPM
 . BMP - I'm not sure of this. Is not tested. - 

<h3>If this is a shit... Why?</h3>

  Ok. Ok. I tried to learn a bit of TCL/TK programming... and well. If you have the TCL/TK libraries installed yet. Use it if you think it worth it. But don't keen on me: works but isn't a migthy app.

<h3>Future and... what a hell!</h3>

  Yeah, yeah... i'm spanish and my english is... uf! Sorry if you don't understand anything.

  The future is obscure -'obscure' realy means anything?-. I think i'm not going to make another version of tkImg.

<h3>Usage</h3>

  Hey Joe! If you don't know what you can do with tkImg your mind is worst than my english.
  And my english SUCKS!

  Forgive me. The <itl>prefereces</itl> option in file menu is for set the path of resources. It uses to be <itl>/usr/lib/tkImg/resources</itl>. I hope you don't need to touch this.

<h2>Notes and Contacts</h2>

  If you want to send me any money... Ok. Just forget it!
  But if you want speak about programming or something like this, i am here:

   <rev>reidrac@rocketmail.com</rev>


  Bye an ThanX for nothing!

 }
}